package immibis.core.porting;

import net.minecraft.src.Container;
import net.minecraft.src.EntityPlayer;
/* $if bukkit$
import net.minecraft.src.EntityPlayerMP;
$endif$ */
import net.minecraft.src.IInventory;

public class PortableContainer extends Container {
	
	protected EntityPlayer player;
	protected IInventory inv;
	
	/* $if bukkit$
	public EntityPlayerMP getPlayer() {
    	return (EntityPlayerMP)player;
    }
    
    public IInventory getInventory() {
    	return inv;
    }
	$endif$ */
	
	public PortableContainer(EntityPlayer player, IInventory inv) {
		this.player = player;
		this.inv = inv;
	}

	@Override
	public final boolean canInteractWith(EntityPlayer var1) {
		return inv.isUseableByPlayer(var1);
	}

}
