package immibis.core.covers;

import java.io.ByteArrayOutputStream;
import java.io.IOException;


import immibis.core.*;
import net.minecraft.src.*;

public class TileMultipart extends TileEntity implements ICoverableTile {
	public CoverImpl cover;
	
	public TileMultipart() {
		cover = new CoverImpl(this);
	}
	
	//@Override // server-only override
	public final Packet getDescriptionPacket() {
		return cover.getDefaultDescriptionPacket();
	}

	@Override
	public CoverImpl getCoverImpl() {
		return cover;
	}
	
	@Override
	public void writeToNBT(NBTTagCompound tag) {
		super.writeToNBT(tag);
		cover.writeToNBT(tag);
	}
	
	@Override
	public void readFromNBT(NBTTagCompound tag) {
		super.readFromNBT(tag);
		cover.readFromNBT(tag);
	}
}
