package immibis.core.covers;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import immibis.core.BlockMetaPair;
import immibis.core.Config;
import immibis.core.CoreProxy;
import immibis.core.IBlockIDCallback;
import immibis.core.NonSharedProxy;
import immibis.core.covers.recipes.RecipeHollowCover;
import immibis.core.covers.recipes.RecipeHorizontalCut;
import immibis.core.covers.recipes.RecipeUnHollowCover;
import immibis.core.covers.recipes.RecipeVerticalCut;
import net.minecraft.src.Block;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NetworkManager;
import net.minecraft.src.Packet1Login;
import net.minecraft.src.StringTranslate;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;
import net.minecraft.src.mod_ImmibisCore;
import net.minecraft.src.forge.IConnectionHandler;
import net.minecraft.src.forge.IPacketHandler;
import net.minecraft.src.forge.MessageManager;
import net.minecraft.src.forge.MinecraftForge;

public class CoverSystemProxy {
	static int coverModel;
	public static BlockMultipart blockMultipart;
	public static ItemSaw itemSaw;
	public final static HashMap<Integer, PartType> parts = new HashMap<Integer, PartType>();
	
	public static ArrayList<Integer> neiDamageValues = new ArrayList<Integer>();
	public static int neiMaxDamage = 0;
	
	public static void ModsLoaded() {
	}
	
	public static void init(int model) {
		coverModel = model;
		
		/* $if client $ */
		MinecraftForge.registerConnectionHandler(new IConnectionHandler() {
			
			@Override
			public void onLogin(NetworkManager network, Packet1Login login) {
				MessageManager.getInstance().registerChannel(network, new IPacketHandler() {
					@Override
					public void onPacketData(NetworkManager network, String channel, byte[] bytes) {
						if(!channel.equals("ImmibisCoreCDP"))
							return;
						try {
							DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
							int x = data.readInt();
							int y = data.readInt();
							int z = data.readInt();
							World w = ModLoader.getMinecraftInstance().thePlayer.worldObj;
							ICoverableTile te = ((ICoverableTile)w.getBlockTileEntity(x, y, z));
							if(te == null) {
								TileMultipart tm = new TileMultipart();
								te = tm;
								w.setBlockTileEntity(x, y, z, tm);
							}
							te.getCoverImpl().readDescriptionPacket(data);
						} catch(Exception e) {
							e.printStackTrace();
						}
					}
				}, "ImmibisCoreCDP");
			}
			
			@Override
			public void onDisconnect(NetworkManager network, String message, Object[] args) {
			}
			
			@Override
			public void onConnect(NetworkManager network) {
			}
		});
		/* $endif$ */
		
		CoreProxy.RegisterBlockID("blockMultipart", new IBlockIDCallback() {
			
			@Override
			public void registerBlock(int blockID) {
				if(blockID == 0)
				{
					mod_ImmibisCore.coversEnabled = false;
					return;
				}
				
				blockMultipart = new BlockMultipart(blockID, Material.rock, coverModel);
				itemSaw = new ItemSaw(Config.getInt("itemSaw.id", 22123));
				blockMultipart.setBlockName("immibis.multipart");
				
				NonSharedProxy.AddLocalization("immibis.multipart.name", "Multipart Block");
				ModLoader.registerBlock(blockMultipart);
				
				ModLoader.registerBlock(blockMultipart, ItemMultipart.class);
				CoversNonSharedProxy.RegisterHighlightHandler();
				ModLoader.registerTileEntity(TileMultipart.class, "immibis.core.multipart");
				
				List recipes = CraftingManager.getInstance().getRecipeList();
				recipes.add(new RecipeHollowCover());
				recipes.add(new RecipeUnHollowCover());
				recipes.add(new RecipeVerticalCut());
				
				RegisterPartsBasedOnBlock(0, Block.bedrock);
				RegisterPartsBasedOnBlock(1, Block.blockClay);
				RegisterPartsBasedOnBlock(2, Block.blockDiamond);
				RegisterPartsBasedOnBlock(3, Block.blockGold);
				RegisterPartsBasedOnBlock(4, Block.blockLapis);
				RegisterPartsBasedOnBlock(5, Block.blockSnow);
				RegisterPartsBasedOnBlock(6, Block.blockSteel);
				RegisterPartsBasedOnBlock(7, Block.bookShelf);
				RegisterPartsBasedOnBlock(8, Block.brick);
				RegisterPartsBasedOnBlock(9, Block.cobblestone);
				RegisterPartsBasedOnBlock(10, Block.cobblestoneMossy);
				RegisterPartsBasedOnBlock(11, Block.dirt);
				RegisterPartsBasedOnBlock(12, Block.glass);
				RegisterPartsBasedOnBlock(13, Block.gravel);
				RegisterPartsBasedOnBlock(14, Block.ice);
				RegisterPartsBasedOnBlock(15, Block.melon);
				RegisterPartsBasedOnBlock(16, Block.obsidian);
				RegisterPartsBasedOnBlock(17, Block.oreCoal);
				RegisterPartsBasedOnBlock(18, Block.oreDiamond);
				RegisterPartsBasedOnBlock(19, Block.oreGold);
				RegisterPartsBasedOnBlock(20, Block.oreIron);
				RegisterPartsBasedOnBlock(21, Block.oreLapis);
				RegisterPartsBasedOnBlock(22, Block.oreRedstone);
				RegisterPartsBasedOnBlock(23, Block.planks);
				RegisterPartsBasedOnBlock(24, Block.pumpkin);
				RegisterPartsBasedOnBlock(25, Block.sand);
				RegisterPartsBasedOnBlock(26, Block.sandStone);
				RegisterPartsBasedOnBlock(27, Block.sponge);
				RegisterPartsBasedOnBlock(28, Block.stone);
				RegisterPartsBasedOnBlock(29, Block.tnt);
				RegisterPartsBasedOnBlock(30, Block.wood);
				RegisterPartsBasedOnBlock(31, Block.wood, 1);
				RegisterPartsBasedOnBlock(32, Block.wood, 2);
				RegisterPartsBasedOnBlock(33, Block.workbench);
				RegisterPartsBasedOnBlock(34, Block.cloth, 0);
				RegisterPartsBasedOnBlock(35, Block.cloth, 1);
				RegisterPartsBasedOnBlock(36, Block.cloth, 2);
				RegisterPartsBasedOnBlock(37, Block.cloth, 3);
				RegisterPartsBasedOnBlock(38, Block.cloth, 4);
				RegisterPartsBasedOnBlock(39, Block.cloth, 5);
				RegisterPartsBasedOnBlock(40, Block.cloth, 6);
				RegisterPartsBasedOnBlock(41, Block.cloth, 7);
				RegisterPartsBasedOnBlock(42, Block.cloth, 8);
				RegisterPartsBasedOnBlock(43, Block.cloth, 9);
				RegisterPartsBasedOnBlock(44, Block.cloth, 10);
				RegisterPartsBasedOnBlock(45, Block.cloth, 11);
				RegisterPartsBasedOnBlock(46, Block.cloth, 12);
				RegisterPartsBasedOnBlock(47, Block.cloth, 13);
				RegisterPartsBasedOnBlock(48, Block.cloth, 14);
				RegisterPartsBasedOnBlock(49, Block.cloth, 15);
				//RegisterPartsBasedOnBlock(50, Block.leaves, 0);
				//RegisterPartsBasedOnBlock(51, Block.leaves, 1);
				//RegisterPartsBasedOnBlock(52, Block.leaves, 2);
				
				ModLoader.addRecipe(new ItemStack(itemSaw), new Object[] {
					"III",
					"DDI",
					'I', Item.ingotIron,
					'D', Item.diamond
				});
			}
		});
	}
	
	private static void RegisterPartsBasedOnBlock(int n, Block block) {
		RegisterPartsBasedOnBlock(n, block, 0);
	}
	
	private static class Info {
		public EnumPartClass clazz;
		public double size;
		public String prefix, suffix;
		public Info(EnumPartClass c, double s, String pr, String su)
		{
			clazz = c;
			size = s;
			prefix = pr;
			suffix = su;
		}
	}
	
	private static Info blockparts[] = new Info[] {
		new Info(EnumPartClass.Panel, 1.0/8.0, "", " Cover"),
		new Info(EnumPartClass.Panel, 2.0/8.0, "", " Panel"),
		new Info(EnumPartClass.Panel, 3.0/8.0, "", " Triple Cover"),
		new Info(EnumPartClass.Panel, 4.0/8.0, "", " Slab"),
		new Info(EnumPartClass.Panel, 5.0/8.0, "", " Cover Slab"),
		new Info(EnumPartClass.Panel, 6.0/8.0, "", " Triple Panel"),
		new Info(EnumPartClass.Panel, 7.0/8.0, "", " Anticover"),
		null,
		new Info(EnumPartClass.Strip, 1.0/8.0, "", " Cover Strip"),
		new Info(EnumPartClass.Strip, 2.0/8.0, "", " Panel Strip"),
		new Info(EnumPartClass.Strip, 3.0/8.0, "", " Triple Cover Strip"),
		new Info(EnumPartClass.Strip, 4.0/8.0, "", " Slab Strip"),
		new Info(EnumPartClass.Strip, 5.0/8.0, "", " Cover Slab Strip"),
		new Info(EnumPartClass.Strip, 6.0/8.0, "", " Triple Panel Strip"),
		new Info(EnumPartClass.Strip, 7.0/8.0, "", " Anticover Strip"),
		null,
		new Info(EnumPartClass.Corner, 1.0/8.0, "", " Cover Corner"),
		new Info(EnumPartClass.Corner, 2.0/8.0, "", " Panel Corner"),
		new Info(EnumPartClass.Corner, 3.0/8.0, "", " Triple Cover Corner"),
		new Info(EnumPartClass.Corner, 4.0/8.0, "", " Slab Corner"),
		new Info(EnumPartClass.Corner, 5.0/8.0, "", " Cover Slab Corner"),
		new Info(EnumPartClass.Corner, 6.0/8.0, "", " Triple Panel Corner"),
		new Info(EnumPartClass.Corner, 7.0/8.0, "", " Anticover Corner"),
		null,
		new Info(EnumPartClass.HollowPanel, 1.0/8.0, "Hollow ", " Cover"),
		new Info(EnumPartClass.HollowPanel, 2.0/8.0, "Hollow ", " Panel"),
		new Info(EnumPartClass.HollowPanel, 3.0/8.0, "Hollow ", " Triple Cover"),
		new Info(EnumPartClass.HollowPanel, 4.0/8.0, "Hollow ", " Slab"),
		new Info(EnumPartClass.HollowPanel, 5.0/8.0, "Hollow ", " Cover Slab"),
		new Info(EnumPartClass.HollowPanel, 6.0/8.0, "Hollow ", " Triple Panel"),
		new Info(EnumPartClass.HollowPanel, 7.0/8.0, "Hollow ", " Anticover"),
		null,
	};
	
	private static void RegisterPartsBasedOnBlock(int n, Block block, int meta) {
		assert(blockparts.length == 32);
		
		String name = StringTranslate.getInstance().translateKey(
			Item.itemsList[block.blockID].getItemNameIS(
				new ItemStack(block.blockID, 1, meta)
			)+".name"
		);
		
		float hardness = block.getHardness(meta);
		
		int[] texindices = new int[6];
		for(int k = 0; k < 6; k++)
			texindices[k] = block.getBlockTextureFromSideAndMetadata(k, meta);
		
		for(int k = 0; k < 7; k++)
		{
			// making hollow covers
			RecipeHollowCover.addMap(n*32 + k, n*32 + k + 24);
			// reverting hollow covers
			RecipeUnHollowCover.addMap(n*32 + k + 24, n*32 + k);
			
			// cutting covers into strips
			RecipeHorizontalCut.addMap(new BlockMetaPair(n*32 + k, blockMultipart.blockID), new ItemStack(blockMultipart.blockID, 2, n*32 + k + 8));
			
			// cutting strips into corners
			RecipeHorizontalCut.addMap(new BlockMetaPair(n*32 + k + 8, blockMultipart.blockID), new ItemStack(blockMultipart.blockID, 2, n*32 + k + 16));
		}
		
		// cutting full blocks/slabs/panels
		RecipeVerticalCut.addMap(new BlockMetaPair(block.blockID, meta), new ItemStack(blockMultipart.blockID, 2, n*32+3));
		RecipeVerticalCut.addMap(new BlockMetaPair(blockMultipart.blockID, n*32+3), new ItemStack(blockMultipart.blockID, 2, n*32+1));
		RecipeVerticalCut.addMap(new BlockMetaPair(blockMultipart.blockID, n*32+1), new ItemStack(blockMultipart.blockID, 2, n*32+0));
		
		// cutting hollow slabs/panels
		RecipeVerticalCut.addMap(new BlockMetaPair(blockMultipart.blockID, n*32+27), new ItemStack(blockMultipart.blockID, 2, n*32+25));
		RecipeVerticalCut.addMap(new BlockMetaPair(blockMultipart.blockID, n*32+25), new ItemStack(blockMultipart.blockID, 2, n*32+24));
		
		for(int k = 0; k < blockparts.length; k++)
			if(blockparts[k] != null)
			{
				PartType type = new PartType(
					blockparts[k].clazz,
					blockparts[k].size,
					blockparts[k].prefix+name+blockparts[k].suffix,
					hardness,
					block,
					meta
				);
				type.textures = texindices;
				RegisterPartType(n*32+k, type);
			}
	}
	
	public static void RegisterPartType(int id, PartType type) {
		if(parts.containsKey(id))
			throw new PartIDInUseException(id, parts.get(id), type);
		parts.put(id, type);
		neiDamageValues.add(id);
		if(id >= neiMaxDamage)
			neiMaxDamage = id + 1;
		type.id = id;
		NonSharedProxy.AddLocalization("immibis.core.multipart."+id+".name", type.name);
	}
}
