package immibis.core.covers;

import java.util.ArrayList;

import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BlockContainer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Material;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.TileEntity;
import net.minecraft.src.Vec3D;
import net.minecraft.src.World;

public abstract class BlockCoverableBase extends BlockMultipart {

	static boolean useRealRenderType = false;

	protected BlockCoverableBase(int i, Material material) {
		super(i, material, CoverSystemProxy.coverModel);
	}
	
	public int getRenderTypeMultipart() {
		return 0;
	}
	
	public MovingObjectPosition collisionRayTraceMultipart(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
		return defaultCollisionRayTrace(world, i, j, k, vec3d, vec3d1);
	}
	
	public final MovingObjectPosition collisionRayTrace(World world, int x, int y, int z, Vec3D src, Vec3D dst) {
		MovingObjectPosition pos = super.collisionRayTrace(world, x, y, z, src, dst);
		if(pos != null)
			return pos;
		
		pos = collisionRayTraceMultipart(world, x, y, z, src, dst);
		if(pos != null)
		{
			pos.subHit = -2;
			return pos;
		}
		
		return null;
	}
	
	@Override
	public final int getRenderType() {
		return useRealRenderType ? getRenderTypeMultipart() : super.getRenderType();
	}
	
	@Override
	public final void getCollidingBoundingBoxes(World world, int x, int y, int z, AxisAlignedBB mask, ArrayList list) {
		super.getCollidingBoundingBoxes(world, x, y, z, mask, list);
		getCollidingBoundingBoxesMultipart(world, x, y, z, mask, list);
	}
	
	public void getCollidingBoundingBoxesMultipart(World world, int i, int j, int k, AxisAlignedBB mask, ArrayList arraylist) {
		AxisAlignedBB axisalignedbb1 = getCollisionBoundingBoxFromPool(world, i, j, k);
        if (axisalignedbb1 != null && axisalignedbb1.intersectsWith(mask))
        {
            arraylist.add(axisalignedbb1);
        }
	}
}
