package immibis.core;

import java.io.File;

import net.minecraft.src.*;

public class NonSharedProxy {
	
	/* $if client$ */
	public static boolean CLIENT = true;
	public static boolean SERVER = false;
	public static boolean isSSP() {
		return !ModLoader.getMinecraftInstance().theWorld.isRemote;
	}
	/* $else$
	public static boolean CLIENT = false;
	public static boolean SERVER = true;
	public static boolean isSSP() {
		return false;
	}
	$endif$ */
	
	public static File getMinecraftDir() {
		/* $if client$ */
		return ModLoader.getMinecraftInstance().mcDataDir;
		/* $else$
		return new File(".");
		$endif$ */
	}
	
	public static void AddLocalization(String a, String b) {
		/* $if client$ */
		ModLoader.addLocalization(a, b);
		/* $endif$ */
	}

	public static void sendChat(EntityPlayer ply, String string) {
		/* $if server$ */
		if(!(ply instanceof EntityPlayerMP))
			return;
		
		((EntityPlayerMP)ply).playerNetServerHandler.netManager.addToSendQueue(new Packet3Chat(string));
		/* $else$
		ModLoader.getMinecraftInstance().ingameGUI.addChatMessage(string);
		$endif$ */
	}
	
	/* $if client$ */
	public static double getPlayerReach(EntityPlayer ply) {
		return ModLoader.getMinecraftInstance().playerController.getBlockReachDistance();
	}
	/* $endif$ */

	public static EntityPlayer getThePlayer() {
		/* $if client$ */
		return ModLoader.getMinecraftInstance().thePlayer;
		/* $else$
		return null;
		$endif$ */
	}
	
	public static int getUniqueBlockModelID(BaseMod mod, boolean b) {
		/* $if client$ */
		return ModLoader.getUniqueBlockModelID(mod, b);
		/* $else$
		return 0;
		$endif$ */
	}
	
	// Returns whether the player is a server op, or it's SSP.
	// Note: Always returns false on SMP clients.
	public static boolean isOp(String player) {
		/* $if client$ */
		return !ModLoader.getMinecraftInstance().theWorld.isRemote;
		/* $else$
		return ModLoader.getMinecraftServerInstance().configManager.isOp(player);
		$endif$ */
	}
}
