package immibis.core;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ModInfoReader {
	private static Map<String, Properties> files = new HashMap<String, Properties>();
	
	public static String getModInfoField(String file, String field) {
		Properties p = files.get(file);
		if(p == null)
		{
			p = new Properties();
			InputStream in = null;
			
			try {
				in = ModInfoReader.class.getResourceAsStream(file);
				in.available(); // check for null
			} catch(Exception e) {
				throw new RuntimeException(e);
			}
			
			try {
				p.load(in);
				in.close();
			} catch(IOException e) {
				throw new RuntimeException(e);
			}
			
			files.put(file, p);
		}
		return p.getProperty(field);
	}
}
