package immibis.core;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Slot;
import immibis.core.porting.PortableContainer;

public class FakeSlotContainer extends PortableContainer {
	
	public FakeSlotContainer(EntityPlayer player, IInventory inv) {
		super(player, inv);
	}

	@Override
	public ItemStack slotClick(int slot, int button, boolean shift, EntityPlayer player)
    {
        if(slot >= 0 && inventorySlots.get(slot) instanceof SlotFake) {
        	SlotFake fs = (SlotFake)inventorySlots.get(slot);
        	fs.onClickByItem(player.inventory.getItemStack(), button, shift);
        	return null;
        }
        return super.slotClick(slot, button, shift, player);
    }
}
