package immibis.core;

import java.util.ArrayList;

import net.minecraft.src.*;
import net.minecraft.src.forge.ITextureProvider;

public class BlockMultiTile extends BlockContainer implements ITextureProvider {

	public static int model;
	static int normalModel;
	int textures[] = new int[6];
	private String texfile;

	protected BlockMultiTile(int id, Material material, String texfile) {
		super(id, material);
		this.texfile = texfile;
		setHardness(2.0F);
	}
	
	@Override
	public boolean isOpaqueCube() {
		return false;
	}
	
	@Override
	public boolean renderAsNormalBlock() {
		return false;
	}
	
	@Override
	public void addCreativeItems(ArrayList items) {
		ItemBlockMultiTile i = (ItemBlockMultiTile)Item.itemsList[blockID];
		for(int k = 0; k < i.max_meta; k++) {
			items.add(new ItemStack(this, 1, k));
		}
	}
	
	/* $if client$ */
	public boolean renderStatic(RenderBlocks rb, IBlockAccess world, int x, int y, int z) {
		TileEntity te = world.getBlockTileEntity(x, y, z);
		if(te instanceof TileMultiTile) {
			return ((TileMultiTile)te).renderStatic(rb, world, x, y, z);
		}
		return false;
	}
	/* $endif$ */
	
	@Override
	public int getBlockTextureFromSideAndMetadata(int side, int meta) {
		return textures[side];
	}

	@Override
	public int getRenderType() {
		return model;
	}

	@Override
	public TileEntity getBlockEntity() {
		return null;
	}

	@Override
	public String getTextureFile() {
		return texfile;
	}
}
