package immibis.core.covers;

import immibis.core.NonSharedProxy;
import immibis.core.Side;
import immibis.core.covers.CoverImpl;
import immibis.core.covers.CoverSystemProxy;
import immibis.core.covers.EnumPartClass;
import immibis.core.covers.EnumPosition;
import immibis.core.covers.ICoverableTile;
import immibis.core.covers.Part;
import immibis.core.covers.PartType;
import immibis.core.covers.TileCoverableBase;
import immibis.core.covers.TileMultipart;
import net.minecraft.src.Block;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.ItemBlock;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class ItemMultipart extends ItemBlock {
	
	private BlockMultipart block;

	public ItemMultipart(int id) {
		super(id);
		block = (BlockMultipart)block.blocksList[id+Block.blocksList.length];
	}

	public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int dir)
    {
		return false;
    }
	
	public void placeInBlock(World world, int x, int y, int z, EnumPosition pos, ItemStack itemstack)
	{
		int d = itemstack.getItemDamage();
        if(d < 0 || d >= CoverSystemProxy.parts.size())
        	return;
        
        TileEntity newTE = world.getBlockTileEntity(x, y, z);
        if(newTE == null || !(newTE instanceof ICoverableTile))
        {
        	if(world.getBlockId(x, y, z) != 0)
        		return;
        	if(!world.canBlockBePlacedAt(block.blockID, x, y, z, true, 0))
        		return;
        	
        	world.setBlock(x, y, z, block.blockID);
        	newTE = new TileMultipart();
        	world.setBlockTileEntity(x, y, z, newTE);
        }
        
        PartType type = CoverSystemProxy.parts.get(d);
        // should not be null
        
        CoverImpl cover = ((ICoverableTile)newTE).getCoverImpl();
        // should not be null
        
        if(!cover.addPart(new Part(type, pos)))
			return;
        
        itemstack.stackSize--;
		world.notifyBlocksOfNeighborChange(x, y, z, block.blockID);
		world.markBlockNeedsUpdate(x, y, z);
	}
	
	@Override
	public String getItemNameIS(ItemStack is) {
		return "immibis.core.multipart." + is.getItemDamage();
	}
	
	@Override
	public boolean getHasSubtypes() {
		return true;
	}

}
