package immibis.core.covers;

import immibis.core.CoreProxy;
import immibis.core.NonSharedProxy;
import immibis.core.Side;
import net.minecraft.src.*;
import immibis.core.*;

public class ItemMultipart extends ItemBlock {
	
	private BlockMultipart block;

	public ItemMultipart(int id) {
		super(id);
		block = (BlockMultipart)block.blocksList[id+Block.blocksList.length];
	}

	public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int x, int y, int z, int dir)
    {
        MovingObjectPosition ray = entityplayer.rayTrace(NonSharedProxy.getPlayerReach(entityplayer), 0);
        if(ray == null)
        	return false;

        x = ray.blockX;
        y = ray.blockY;
        z = ray.blockZ;
        dir = ray.sideHit;
        TileEntity rayTE = (world.getBlockTileEntity(ray.blockX, ray.blockY, ray.blockZ));
        Part rayPart = null;
        if(rayTE instanceof ICoverableTile) 
        {
        	 if(ray.subHit >= 0)
        		 rayPart = ((ICoverableTile)rayTE).getCoverImpl().parts.get(ray.subHit);
        	 else if(ray.subHit == -2)
        		 rayPart = ((TileCoverableBase)rayTE).getFakeCentrePart();
        }
        
        int oldblock = world.getBlockId(x, y, z);
        if (oldblock == Block.snow.blockID)
            dir = 0;
        else if (oldblock != Block.vine.blockID)
        {
        	int dx=0, dy=0, dz=0;
        	switch(dir)
        	{
        	case Side.NX: if(rayPart == null || rayPart.pos.x.touchesNegative()) dx=-1; break;
        	case Side.PX: if(rayPart == null || rayPart.pos.x.touchesPositive()) dx=1; break;
        	case Side.NY: if(rayPart == null || rayPart.pos.y.touchesNegative()) dy=-1; break;
        	case Side.PY: if(rayPart == null || rayPart.pos.y.touchesPositive()) dy=1; break;
        	case Side.NZ: if(rayPart == null || rayPart.pos.z.touchesNegative()) dz=-1; break;
        	case Side.PZ: if(rayPart == null || rayPart.pos.z.touchesPositive()) dz=1; break;
        	}
        	if(dx != 0 || dy != 0 || dz != 0)
        	{
        		x += dx;
        		y += dy;
        		z += dz;
        		rayPart = null;
        	}
        }
        if (itemstack.stackSize == 0)
            return false;
        if (!entityplayer.canPlayerEdit(x, y, z))
            return false;
        
        PartType type = CoverSystemProxy.parts.get(itemstack.getItemDamage());
     	EnumPosition pos;
    	if(type.clazz == EnumPartClass.Panel || type.clazz == EnumPartClass.HollowPanel)
    	{
    		pos = MultipartHighlightHandler.getPanelPlacement(entityplayer, ray, rayPart == null ? null : rayPart.pos);
    	}
    	else if(type.clazz == EnumPartClass.Corner)
    	{
    		pos = MultipartHighlightHandler.getCornerPlacement(entityplayer, ray, rayPart == null ? null : rayPart.pos);
    	}
    	else if(type.clazz == EnumPartClass.Strip)
    	{
    		pos = MultipartHighlightHandler.getStripPlacement(entityplayer, ray, rayPart == null ? null : rayPart.pos);
    	}
    	else
    		return false;
    	
    	if(world.isRemote)
    	{
    		world.playSoundEffect((float)x + 0.5F, (float)y + 0.5F, (float)z + 0.5F, block.stepSound.getStepSound(), (block.stepSound.getVolume() + 1.0F) / 2.0F, block.stepSound.getPitch() * 0.8F);
    		//Packet230ModLoader packet = new Packet230ModLoader();
            //packet.packetType = CoreProxy.PACKET_TYPE_C2S_MICROBLOCK_PLACE;
            //packet.dataInt = new int[] {x, y, z, pos.ordinal()};
            //mod_ImmibisCore.instance.sendPacket(packet);
    	}
    	else
    	{
    		TileEntity newTE = world.getBlockTileEntity(x, y, z);
            if(newTE == null || !(newTE instanceof ICoverableTile))
            {
            	if(world.getBlockId(x, y, z) != 0)
            		return false;
            	if(!world.canBlockBePlacedAt(block.blockID, x, y, z, true, dir))
            		return false;
            	
            	world.setBlock(x, y, z, block.blockID);
            	newTE = new TileMultipart();
            	world.setBlockTileEntity(x, y, z, newTE);
            }
            
            CoverImpl cover = ((ICoverableTile)newTE).getCoverImpl();
            
            if(!cover.addPart(new Part(type, pos)))
    			return false;
            
            itemstack.stackSize--;
    		world.notifyBlocksOfNeighborChange(x, y, z, block.blockID);
    		world.markBlockNeedsUpdate(x, y, z);
    	}
        return true;
    }
	
	@Override
	public String getItemNameIS(ItemStack is) {
		return "immibis.core.multipart." + is.getItemDamage();
	}
	
	@Override
	public boolean getHasSubtypes() {
		return true;
	}

}
