package mffs.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import mffs.mod_ModularForceFieldSystem;
import net.minecraft.src.EntityPlayer;

import immibis.core.NonSharedProxy;
import immibis.core.net.AbstractContainerSyncPacket;

public class PacketGenericUpdate extends AbstractContainerSyncPacket {
	public int[] data;
	public int[] baseData;
	
	@Override
	public void onReceived(EntityPlayer player) {
		if(NonSharedProxy.SERVER)
			return;
		super.onReceived(player);
	}
	
	@Override
	public void write(DataOutputStream out) throws IOException {
		if(data == null)
			out.writeInt(0);
		else {
			out.writeInt(data.length);
			for(int k = 0; k < data.length; k++)
				out.writeInt(data[k]);
		}
		if(baseData == null)
			out.writeInt(0);
		else {
			out.writeInt(baseData.length);
			for(int k = 0; k < baseData.length; k++)
				out.writeInt(baseData[k]);
		}
	}
	
	@Override
	public void read(DataInputStream in) throws IOException {
		data = new int[in.readInt()];
		for(int k = 0; k < data.length; k++)
			data[k] = in.readInt();
		baseData = new int[in.readInt()];
		for(int k = 0; k < baseData.length; k++)
			baseData[k] = in.readInt();
	}
	
	@Override
	public byte getID() {
		return mod_ModularForceFieldSystem.PKT_GENERIC_UPDATE;
	}
}
