package mffs;

import mffs.*;
import mffs.packet.PacketGenericUpdate;
import ic2.api.ExplosionWhitelist;
import ic2.api.Items;
import immibis.core.ModInfoReader;
import immibis.core.NonSharedProxy;
import immibis.core.net.IPacket;
import immibis.core.net.IPacketMap;
import immibis.core.net.OneTwoFiveNetworking;

import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

import cpw.mods.fml.common.FMLCommonHandler;
//import org.lwjgl.input.Keyboard;
//import net.minecraft.client.Minecraft;
import net.minecraft.src.*;
import net.minecraft.src.forge.*;

public class mod_ModularForceFieldSystem extends NetworkMod implements IGuiHandler {


	public static Configuration config;
	
	public static Block MFFSMaschines;
	public static Block MFFSUpgrades;
	public static Block MFFSFieldblock;
	
	public static Item MFFSitemMFDReaktorlink;
	public static Item MFFSitemMFDwrench;
	public static Item MFFSitemMFDidtool;
	public static Item MFFSitemMFDdebugger;
	public static Item MFFSitemcardempty;
	public static Item MFFSitemfc;
	public static Item MFFSitemidc;
	public static Item MFFSitemsclc;
	
	public static final int GUI_ID_GENERATOR = 1;
	public static final int GUI_AREA_PROJECTOR = 2;
	public static final int GUI_DIRECTIONAL_PROJECTOR = 3;
	public static final int GUI_DEFLECTOR_PROJECTOR = 4;
	public static final int GUI_DIRECTIONAL_UPGRADE = 5;
	public static final int GUI_TUBE_PROJECTOR = 6;
	public static final int GUI_CAMOFLAGE_UPGRADE = 7;
	public static final int GUI_REACTOR_FIELD = 8;
	public static final int GUI_REACTOR_COOLER = 9;
	public static final int GUI_REACTOR_MONITOR = 10;
	public static final int GUI_REACTOR_MONITOR_CLIENT = 11;
	public static final int GUI_REACTOR_MONITOR_REMOTE = 12;

	public static final String CHANNEL = "MFFS-immiSMP";

	public static final byte PKT_GENERIC_UPDATE = 0;
	public static final byte PKT_PROJECTOR_DESCRIPTION = 1;
	
	public static int forcefieldblockcost;
	public static int forcefieldblockcreatemodifier;
	public static int forcefieldblockzappermodifier;
	
	public static int reaktorheatcontrolice;
	public static int reaktorheatcontrolwater;
	public static int reaktorheatcontrollava;
	
	@Override
	public String getPriorities() {
		return "after:mod_IC2;after:mod_ImmibisCore";
	}

	public static StringBuffer hasher = new StringBuffer();
	public static Map<Integer, int[]> idtotextur = new HashMap<Integer, int[]>();
	
	public static mod_ModularForceFieldSystem instance;

	public static int maxCamoBlockId;
	
	public static boolean slowRefresh;
	public static int maxSize, maxDeflectorDistance, maxTubeRadius;
	public static int refreshSpeed;

	public mod_ModularForceFieldSystem() {
		instance = this;
	}
	
	@Override
	public void load() {
		try {
			config = new Configuration(new File(Functions.getMinecraftDir(), "/config/ModularForceFieldSystem.cfg"));
			config.load();
		} catch (Exception exception) {
			config = null;
			System.err.print(exception.toString());
		}
		
		BlockForceField.model = NonSharedProxy.getUniqueBlockModelID(this, true);
		
		Property oldNamesProp = config.getOrCreateBooleanProperty("useOldNames", Configuration.CATEGORY_GENERAL, false);
		oldNamesProp.comment = "If true, this will use the old names from Thunderdark's version.";
		boolean oldNames = Boolean.valueOf(oldNamesProp.value);
		
		/*Property slowRefreshProp = config.getOrCreateBooleanProperty("slowRefresh", Configuration.CATEGORY_GENERAL, false);
		slowRefreshProp.comment = "If true, forcefields will refresh every second. If false every tick (as before).";		
		slowRefresh = Boolean.valueOf(slowRefreshProp.value);*/
		slowRefresh = false;

		reaktorheatcontrolice = Functions.getBlockIdFor("reaktorheatcontrolice", 100);
		reaktorheatcontrolwater = Functions.getBlockIdFor("reaktorheatcontrolwater", 50);
		reaktorheatcontrollava = Functions.getBlockIdFor("reaktorheatcontrollava", 100);
		
		forcefieldblockcost = Functions.getBlockIdFor("forcefieldblockcost", 1);
		forcefieldblockcreatemodifier = Functions.getBlockIdFor("forcefieldblockcreatemodifier", 10);
		forcefieldblockzappermodifier = Functions.getBlockIdFor("forcefieldblockzappermodifier", 2);
		maxSize = Integer.parseInt(config.getOrCreateIntProperty("maxProjectorSize", Configuration.CATEGORY_GENERAL, 32).value);
		maxDeflectorDistance = Integer.parseInt(config.getOrCreateIntProperty("maxDeflectorDistance", Configuration.CATEGORY_GENERAL, 10).value);
		maxTubeRadius = Integer.parseInt(config.getOrCreateIntProperty("maxTubeRadius", Configuration.CATEGORY_GENERAL, 5).value);
		refreshSpeed = Integer.parseInt(config.getOrCreateIntProperty("refreshSpeed", Configuration.CATEGORY_GENERAL, 100).value);

		MFFSFieldblock = new BlockForceField(Functions.getBlockIdFor("HFFPFieldblock", 255));
		MFFSMaschines = new BlockMachine(Functions.getBlockIdFor("HFFPMaschines", 253));
		MFFSUpgrades = new BlockUpgrades(Functions.getBlockIdFor("HFFSUpgrades", 254));

		MFFSitemMFDReaktorlink = new ItemMFD_Reaktorlink(Functions.getItemIdFor("itemMFDReaktorlink", 11110)).setItemName("itemMFDReaktorlink");
		MFFSitemMFDdebugger = new ItemMFD_debuger(Functions.getItemIdFor("itemMFDdebugger", 11111)).setItemName("itemMFDdebugger");
		MFFSitemMFDidtool = new ItemMFD_IDwriter(Functions.getItemIdFor("itemMFDidtool", 11112)).setItemName("itemMFDidtool");
		MFFSitemMFDwrench = new ItemMFD_wrench(Functions.getItemIdFor("itemMFDwrench", 11114)).setItemName("itemMFDwrench");
		MFFSitemcardempty = new ItemCardempty(Functions.getItemIdFor("itemcardempty", 11115)).setItemName("itemcardempty");
		MFFSitemfc = new ItemFrequenzCard(Functions.getItemIdFor("itemfc", 11116)).setItemName("itemfc");
		MFFSitemidc = new ItemIDCard(Functions.getItemIdFor("itemidc", 11117)).setItemName("itemidc");
		MFFSitemsclc = new ItemSecLinkCard(Functions.getItemIdFor("itemsclc", 11118)).setItemName("itemsclc");
		
		if (config != null) {
			config.save();
		}
		
		ModLoader.registerBlock(MFFSMaschines, ItemMachines.class);
		ModLoader.registerBlock(MFFSUpgrades, ItemUpgrades.class);

		ModLoader.registerTileEntity(TileEntityMaschines.class, "Maschines_Multi");
		ModLoader.registerTileEntity(TileEntityGeneratorCore.class, "Generator_Core");
		ModLoader.registerTileEntity(TileEntityAreaProjektor.class, "Area_Projektor");
		ModLoader.registerTileEntity(TileEntityPassivUpgrade.class, "Generator_Upgrade");
		ModLoader.registerTileEntity(TileEntityGeneratorEUInjector.class, "Generator_EU_Injektor");
		ModLoader.registerTileEntity(TileEntityDirectionalProjektor.class, "Directional_Projektor");
		ModLoader.registerTileEntity(TileEntityDeflectorProjektor.class, "Deflector_Projektor");
		ModLoader.registerTileEntity(TileEntityDirectionalExtender.class, "Directional_Extender");
		ModLoader.registerTileEntity(TileEntityTubeProjektor.class, "Tube_Projektor");
		ModLoader.registerTileEntity(TileEntityCamoflageUpgrade.class, "Projektor_camouflage");
		ModLoader.registerTileEntity(TileEntityReaktorField.class, "Reaktor_Field");
		ModLoader.registerTileEntity(TileEntityReaktorConnector.class, "Reactor_Connector");
		ModLoader.registerTileEntity(TileEntityReaktorCooler.class, "Reaktor_Cooler");
		ModLoader.registerTileEntity(TileEntityReaktorMonitor.class, "Reaktor_Monitor");
		ModLoader.registerTileEntity(TileEntityReaktorMonitorClient.class, "Reaktor_Monitor_Client");
		ModLoader.registerTileEntity(TileCamouflagedField.class, "MFFS camo");
		
		ModLoader.addName(MFFSitemMFDidtool, "MFDevice <ID-Tool>");
		ModLoader.addName(MFFSitemMFDwrench, "MFDevice <Wrench>");
		ModLoader.addName(MFFSitemcardempty, oldNames ? "MFFS Card blank " : "Blank MFFS card");
		ModLoader.addName(MFFSitemfc, oldNames ? "MFFS Frequency Card" : "MFFS frequency card");
		ModLoader.addName(MFFSitemidc, oldNames ? "MFFS ID Card" : "MFFS ID card");
		ModLoader.addName(MFFSitemMFDdebugger, "MFDevice <Debugger>");
		ModLoader.addName(MFFSitemsclc, oldNames ? "MFFS  Link Card" : "MFFS link card");
		ModLoader.addName(MFFSitemMFDReaktorlink, oldNames ? "MFFS Remote Reaktor Link" : "MFFS remote reactor link");

		ModLoader.addLocalization("Tube_Projektor.name", oldNames ? "MFFS Tube Projector" : "Tube forcefield projector");
		ModLoader.addLocalization("Directional_Extender.name", "MFFS directional extender");
		ModLoader.addLocalization("Deflector_Projektor.name", "MFFS deflector");
		ModLoader.addLocalization("Generator_Core.name", oldNames ? "MFFS generator core" : "Forcefield core");
		ModLoader.addLocalization("Area_Projektor.name", oldNames ? "MFFS Area Projector" : "MFFS area projector");
		ModLoader.addLocalization("Generator_Storage.name", oldNames ? "MFFS generator storage upgrade" : "Forcefield core storage upgrade");
		ModLoader.addLocalization("Generator_Linkex.name", oldNames ? "MFFS generator range upgrade" : "Forcefield core range upgrade");
		ModLoader.addLocalization("Generator_EU_Injektor.name", oldNames ? "MFFS generator EU-injector" : "Forcefield EU injector");
		ModLoader.addLocalization("Directional_Projektor.name", oldNames ? "MFFS directional projektor" : "Directional forcefield projector");
		ModLoader.addLocalization("Projektor_Subwater.name", oldNames ? "MFFS Projector underwater upgrade" : "Forcefield underwater upgrade");
		ModLoader.addLocalization("Projektor_Dome.name", oldNames ? "MFFS Projector dome upgrade" : "Forcefield dome upgrade");
		ModLoader.addLocalization("Projektor_Hardner.name", oldNames ? "MFFS Projector block cutter upgrade" : "Forcefield block cutter upgrade");
		ModLoader.addLocalization("Projektor_Zapper.name", oldNames ? "MFFS Projector ZAPPER upgrade" : "Forcefield zapper upgrade");
		ModLoader.addLocalization("Projektor_camouflage.name", oldNames ? "MFFS Projector camouflage upgrade" : "Forcefield camouflage upgrade");
		ModLoader.addLocalization("Reaktor_Field.name", oldNames ? "MFFS nuclear reactor containment " : "Reactor containment field projector");
		ModLoader.addLocalization("Reactor_Connector.name", "MFFS reactor connector");
		ModLoader.addLocalization("Reaktor_Cooler.name", "MFFS reactor heat control");
		ModLoader.addLocalization("Reaktor_Monitor.name", "MFFS reactor heat monitor server");
		ModLoader.addLocalization("Reaktor_Monitor_Client.name", "MFFS reactor heat monitor client");
		
		/* $if client$ */
		MinecraftForgeClient.preloadTexture("/mffs_grafik/upgrades.png");
		MinecraftForgeClient.preloadTexture("/mffs_grafik/machines.png");
		MinecraftForgeClient.preloadTexture("/mffs_grafik/blocks.png");
		MinecraftForgeClient.preloadTexture("/mffs_grafik/items.png");
		/* $endif$ */
		
		addCamoBlock(Block.stone, 0);
		addCamoBlock(Block.grass, 0);
		addCamoBlock(Block.dirt, 0);
		addCamoBlock(Block.cobblestone, 0);
		addCamoBlock(Block.planks, 0);
		addCamoBlock(Block.planks, 1);
		addCamoBlock(Block.planks, 2);
		addCamoBlock(Block.planks, 3);
		addCamoBlock(Block.bedrock, 0);
		addCamoBlock(Block.sand, 0);
		addCamoBlock(Block.gravel, 0);
		addCamoBlock(Block.oreGold, 0);
		addCamoBlock(Block.oreIron, 0);
		addCamoBlock(Block.oreCoal, 0);
		addCamoBlock(Block.wood, 0);
		addCamoBlock(Block.wood, 1);
		addCamoBlock(Block.wood, 2);
		addCamoBlock(Block.wood, 3);
		addCamoBlock(Block.leaves, 0);
		addCamoBlock(Block.leaves, 1);
		addCamoBlock(Block.leaves, 2);
		addCamoBlock(Block.leaves, 3);
		addCamoBlock(Block.sponge, 0);
		addCamoBlock(Block.glass, 0);
		addCamoBlock(Block.oreLapis, 0);
		addCamoBlock(Block.blockLapis, 0);
		addCamoBlock(Block.sandStone, 0);
		addCamoBlock(Block.sandStone, 1);
		addCamoBlock(Block.sandStone, 2);
		addCamoBlock(Block.music, 0);
		for(int k = 0; k < 16; k++)
			addCamoBlock(Block.cloth, k);
		addCamoBlock(Block.blockGold, 0);
		addCamoBlock(Block.blockSteel, 0);
		addCamoBlock(Block.brick, 0);
		addCamoBlock(Block.tnt, 0);
		addCamoBlock(Block.bookShelf, 0);
		addCamoBlock(Block.cobblestoneMossy, 0);
		addCamoBlock(Block.obsidian, 0);
		addCamoBlock(Block.oreDiamond, 0);
		addCamoBlock(Block.blockDiamond, 0);
		addCamoBlock(Block.workbench, 0);
		addCamoBlock(Block.oreRedstone, 0);
		addCamoBlock(Block.ice, 0);
		addCamoBlock(Block.blockSnow, 0);
		addCamoBlock(Block.blockClay, 0);
		addCamoBlock(Block.jukebox, 0);
		addCamoBlock(Block.netherrack, 0);
		addCamoBlock(Block.slowSand, 0);
		addCamoBlock(Block.glowStone, 0);
		addCamoBlock(Block.stoneBrick, 0);
		addCamoBlock(Block.stoneBrick, 1);
		addCamoBlock(Block.stoneBrick, 2);
		for(int k = 0; k < 11; k++) {
			addCamoBlock(Block.mushroomCapBrown, k);
			addCamoBlock(Block.mushroomCapRed, k);
		}
		addCamoBlock(Block.melon, 0);
		addCamoBlock(Block.mycelium, 0);
		addCamoBlock(Block.netherBrick, 0);
		addCamoBlock(Block.whiteStone, 0);
		addCamoBlock(Block.whiteStone, 1);
		addCamoBlock(Block.redstoneLampIdle, 0);
		
		maxCamoBlockId = Block.redstoneLampIdle.blockID;
		
		ModLoader.setInGameHook(this, true, true);
		MinecraftForge.setGuiHandler(this, this);
		OneTwoFiveNetworking.initReceive(new PacketMap(), CHANNEL);
	}
	
	@Override
	/* $if client$ */
	public boolean onTickInGame(float f, net.minecraft.client.Minecraft mc) {
	/* $else$
	public boolean onTickInGame(net.minecraft.server.MinecraftServer mc) {
	$endif$ */
		FFWorld.tickAll();
		return true;
	}
	
	private void addCamoBlock(Block block, int meta)
	{
		int[] t = new int[6];
		for(int k = 0; k < 6; k++)
			t[k] = block.getBlockTextureFromSideAndMetadata(k, meta);
		idtotextur.put(block.blockID + meta*1000, t);
	}
	
	@Override
    public void modsLoaded()
    {
    	ExplosionWhitelist.addWhitelistedBlock(MFFSFieldblock);
    	ExplosionWhitelist.addWhitelistedBlock(MFFSUpgrades);
    	ExplosionWhitelist.addWhitelistedBlock(MFFSMaschines);
    	
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 5), new Object[] { " B ", "ACA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.diamond, Character.valueOf('D'), Items.getItem("frequencyTransmitter") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 4), new Object[] { "ABA", "BCB", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.diamond, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 1), new Object[] { "BBB", "BCB", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.diamond, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 3), new Object[] { "BAB", "ACA", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.diamond, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 2), new Object[] { "ABA", "ACA", "DED", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.diamond, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('C'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzedWaterCell") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 6), new Object[] { "ABA", "CDC", "ABA", Character.valueOf('A'), Items.getItem("refinedIronIngot"), Character.valueOf('B'), Items.getItem("insulatedCopperCableItem"), Character.valueOf('C'), Items.getItem("electrolyzedWaterCell"), Character.valueOf('D'), Items.getItem("batBox") });
		ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 0), new Object[] { "ABA", "CDC", "AEA", Character.valueOf('A'), Items.getItem("electrolyzedWaterCell"), Character.valueOf('B'), Items.getItem("advancedAlloy"), Character.valueOf('C'), Items.getItem("electronicCircuit"), Character.valueOf('D'), Items.getItem("frequencyTransmitter"), Character.valueOf('E'), Items.getItem("electrolyzer") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 4), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("electrolyzedWaterCell") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 2), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("electronicCircuit") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 3), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("carbonPlate") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 5), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("frequencyTransmitter") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 1), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.bucketEmpty });
		ModLoader.addRecipe(new ItemStack(MFFSitemMFDwrench), new Object[] { "BCB", "DAD", "DDD", Character.valueOf('A'), Item.diamond, Character.valueOf('B') ,Items.getItem("insulatedCopperCableItem")  , Character.valueOf('C') ,Item.redstone , Character.valueOf('D') ,Items.getItem("refinedIronIngot")  });
		ModLoader.addRecipe(new ItemStack(MFFSitemcardempty), new Object[] { "AAA", "ABA", "AAA", Character.valueOf('A'), Item.paper, Character.valueOf('B'), Items.getItem("electronicCircuit") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 6), new Object[] { " A ", "ABA", " A ", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Items.getItem("teslaCoil") });
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 7), new Object[] { "BAB", "ACA", "BAB", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.diamond, Character.valueOf('C'), Items.getItem("frequencyTransmitter") });
		ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 8), new Object[] { "ACA", "BDB", "ACA", Character.valueOf('A'), Items.getItem("advancedAlloy"), Character.valueOf('B'), Item.redstone, Character.valueOf('C'), Items.getItem("trippleInsulatedIronCableItem"), Character.valueOf('D'), Items.getItem("frequencyTransmitter") });
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 7), new Object[] { "ADA", "BCB", "ABA", Character.valueOf('A'), Items.getItem("carbonPlate"), Character.valueOf('B'), Items.getItem("advancedAlloy"), Character.valueOf('C'), new ItemStack(MFFSMaschines, 1, 1), Character.valueOf('D'), Items.getItem("advancedCircuit") });    	
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 8), new Object[] { "DCD", "CAC", "DBD", Character.valueOf('A'), Items.getItem("advancedMachine"),Character.valueOf('B'), Block.chest,Character.valueOf('C'), Items.getItem("integratedHeatDisperser") , Character.valueOf('D'), Items.getItem("advancedAlloy")});    
        ModLoader.addRecipe(new ItemStack(MFFSMaschines, 1, 9), new Object[] { "ECE", "DBD", "EAE", Character.valueOf('A'), Items.getItem("advancedMachine"),Character.valueOf('B'), Items.getItem("frequencyTransmitter") , Character.valueOf('C'), Items.getItem("detectorCableItem"), Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('E'), Items.getItem("refinedIronIngot")});
        ModLoader.addRecipe(new ItemStack(MFFSUpgrades, 1, 0), new Object[] { "ECE", "DBD", "EAE", Character.valueOf('A'), Items.getItem("machine"),Character.valueOf('B'), Items.getItem("frequencyTransmitter") , Character.valueOf('C'), Item.redstone, Character.valueOf('D'), Items.getItem("electronicCircuit"), Character.valueOf('E'), Items.getItem("refinedIronIngot")});
    	
        ModLoader.addRecipe(new ItemStack(MFFSitemMFDReaktorlink), new Object[] { "DCD", "BAB", "CBC", Character.valueOf('A'), Items.getItem("frequencyTransmitter"), Character.valueOf('B'), Items.getItem("electronicCircuit") , Character.valueOf('C'), Items.getItem("carbonPlate"), Character.valueOf('D'), Item.redstone});
 
        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDwrench), new Object[]{new ItemStack(MFFSitemMFDidtool)});
        ModLoader.addShapelessRecipe(new ItemStack(MFFSitemMFDidtool), new Object[]{new ItemStack(MFFSitemMFDwrench)});
         
    }
	
	/* $if client$ */
	@Override
	public boolean renderWorldBlock(RenderBlocks rb, IBlockAccess w, int x, int y, int z, Block b, int model) {
		if(b == MFFSFieldblock) {
			int meta = w.getBlockMetadata(x, y, z);
			
			boolean usingCamo = false;
			
			if(BlockForceField.isCamo(meta))
			{
				TileEntity te = w.getBlockTileEntity(x, y, z);
				if(te != null)
				{
					int camoBlock = ((TileCamouflagedField)te).camoBlockId;
					BlockForceField.useTextures = idtotextur.get(camoBlock);
					usingCamo = (BlockForceField.useTextures != null);
					//System.out.println("camoblock "+camoBlock+", textures "+BlockForceField.useTextures);
				}
			}
			
			if(!usingCamo)
			{
				MinecraftForgeClient.bindTexture("/mffs_grafik/blocks.png");
				rb.renderStandardBlock(b, x, y, z);
				MinecraftForgeClient.unbindTexture();
			}
			else
			{
				rb.renderStandardBlock(b, x, y, z);
				BlockForceField.useTextures = null;
			}
			
			return true;
		}
		return false;
	}
	
	@Override
	public void renderInvBlock(RenderBlocks rb, Block b, int meta, int model) {
		// field blocks shouldn't be in inventories - let them be invisible
	}
	/* $endif$ */

	public static Object getGuiForId(EntityPlayer entityplayer, int i, TileEntity tileentity) {

		int meta = tileentity.worldObj.getBlockMetadata(tileentity.xCoord, tileentity.yCoord, tileentity.zCoord);
		int blockid = tileentity.worldObj.getBlockId(tileentity.xCoord, tileentity.yCoord, tileentity.zCoord);
		if ((meta == 4 || meta == 5) && blockid == MFFSUpgrades.blockID) {
			// TODO WTF?
			i = GUI_ID_GENERATOR;
		}
		
		switch(i) {
		/* $if client$ */
		case GUI_ID_GENERATOR:
			return new GuiGenerator(entityplayer, tileentity == null ? new TileEntityGeneratorCore() : ((TileEntityGeneratorCore) tileentity));
		case GUI_AREA_PROJECTOR:
			return new GuiProjektorArea(entityplayer, tileentity == null ? new TileEntityAreaProjektor() : ((TileEntityAreaProjektor) tileentity));
		case GUI_DIRECTIONAL_PROJECTOR:
			return new GuiProjektorDirectional(entityplayer, tileentity == null ? new TileEntityDirectionalProjektor() : ((TileEntityDirectionalProjektor) tileentity));
		case GUI_DEFLECTOR_PROJECTOR:
			return new GuiDeflectorDirectional(entityplayer, tileentity == null ? new TileEntityDeflectorProjektor() : ((TileEntityDeflectorProjektor) tileentity));
		case GUI_DIRECTIONAL_UPGRADE:
			return new GuiDirectionalUpgrade(entityplayer, tileentity == null ? new TileEntityDirectionalExtender() : ((TileEntityDirectionalExtender) tileentity));
		case GUI_TUBE_PROJECTOR:
			return new GuiProjTube(entityplayer, tileentity == null ? new TileEntityTubeProjektor() : ((TileEntityTubeProjektor) tileentity));
		case GUI_CAMOFLAGE_UPGRADE:
			return new GuiCamouflageUpgrade(entityplayer, tileentity == null ? new TileEntityCamoflageUpgrade() : ((TileEntityCamoflageUpgrade) tileentity));
		case GUI_REACTOR_FIELD:
			return new GuiReaktorField(entityplayer, tileentity == null ? new TileEntityReaktorField() : ((TileEntityReaktorField) tileentity));
		case GUI_REACTOR_COOLER:
			return new GuiReaktorCooler(entityplayer, tileentity == null ? new TileEntityReaktorCooler() : ((TileEntityReaktorCooler) tileentity));
		case GUI_REACTOR_MONITOR:
			return new GuiReaktorMonitor(entityplayer, tileentity == null ? new TileEntityReaktorMonitor() : ((TileEntityReaktorMonitor) tileentity));
		case GUI_REACTOR_MONITOR_CLIENT:
			return new GuiReaktorMonitorClient(entityplayer, tileentity == null ? new TileEntityReaktorMonitorClient() : ((TileEntityReaktorMonitorClient) tileentity));
		/* $else$
		case GUI_ID_GENERATOR:
			return new ContainerGenerator(entityplayer, tileentity == null ? new TileEntityGeneratorCore() : ((TileEntityGeneratorCore) tileentity));
		case GUI_AREA_PROJECTOR:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityAreaProjektor() : ((TileEntityAreaProjektor) tileentity));
		case GUI_DIRECTIONAL_PROJECTOR:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityDirectionalProjektor() : ((TileEntityDirectionalProjektor) tileentity));
		case GUI_DEFLECTOR_PROJECTOR:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityDeflectorProjektor() : ((TileEntityDeflectorProjektor) tileentity));
		case GUI_DIRECTIONAL_UPGRADE:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityDirectionalExtender() : ((TileEntityDirectionalExtender) tileentity));
		case GUI_TUBE_PROJECTOR:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityTubeProjektor() : ((TileEntityTubeProjektor) tileentity));
		case GUI_CAMOFLAGE_UPGRADE:
			return new ContainerCamoflage(entityplayer, tileentity == null ? new TileEntityCamoflageUpgrade() : ((TileEntityCamoflageUpgrade) tileentity));
		case GUI_REACTOR_FIELD:
			return new ContainerProjektor(entityplayer, tileentity == null ? new TileEntityReaktorField() : ((TileEntityReaktorField) tileentity));
		case GUI_REACTOR_COOLER:
			return new ContainerReactorCooler(entityplayer, tileentity == null ? new TileEntityReaktorCooler() : ((TileEntityReaktorCooler) tileentity));
		case GUI_REACTOR_MONITOR:
			return new ContainerReaktorMonitor(entityplayer, tileentity == null ? new TileEntityReaktorMonitor() : ((TileEntityReaktorMonitor) tileentity));
		case GUI_REACTOR_MONITOR_CLIENT:
			return new ContainerReaktorMonitorClient(entityplayer, tileentity == null ? new TileEntityReaktorMonitorClient() : ((TileEntityReaktorMonitorClient) tileentity));
		$endif$ */
		}
		return null;
	}

	public String getVersion() {
		return ModInfoReader.getModInfoField("/mffs/mod_ModularForceFieldSystem.info.txt", "version");
	}

	@Override
	public Object getGuiElement(int ID, EntityPlayer player, World world,
			int x, int y, int z) {
		TileEntity te = world.getBlockTileEntity(x, y, z);
		if(te == null)
			return null;
		return getGuiForId(player, ID, te);
	}

	private static class PacketMap implements IPacketMap {
		@Override
		public IPacket createPacket(byte id) {
			if(id == PKT_GENERIC_UPDATE)
				return new PacketGenericUpdate();
			return null;
		}
	}

	public static World getClientWorld() {
		/* $if client$ */
		return ModLoader.getMinecraftInstance().theWorld;
		/* $else$
		return null;
		$endif$ */
	}

}