package mffs;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;

import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.TileEntity;

public abstract class TileEntityProjektor extends TileEntityMaschines {
	
	// for field shape CoordinateLists
	// not currently used, may be used for inhibitor projectors
	public static final int MODE_FIELD = 1; // force field block
	public static final int MODE_GAP = 2; // pokes holes in existing forcefields from the same generator
	

	private ItemStack ProjektorItemStacks[];

	private boolean camouflage;
	private boolean zapper;
	private boolean dropper;
	private boolean Subwater;
	private boolean Dome;
	private boolean hardner;
	private int Projektor_ID;
	private int linkGenerator_ID;
	private boolean linkGenerator;
	private int linkPower;
	private int maxlinkPower;
	private short ticker;
	private int fpcost;
	private boolean create;
	private int energy_ticker = 0;
	private short ffmeta;
	private int textur;
	
	protected short specialffmeta = (short)-1;
	
	@Override
	public void handleBaseUpdate(int[] p) {
		Projektor_ID = p[0];
		linkGenerator_ID = p[1];
		linkPower = p[2];
		maxlinkPower = p[3];
		textur = p[4];
	}
	@Override
	public int[] getBaseUpdate() {
		return new int[] {
			Projektor_ID,
			linkGenerator_ID,
			linkPower,
			maxlinkPower,
			textur
		};
	}

	public TileEntityProjektor() {
		Random random = new Random();

		ProjektorItemStacks = new ItemStack[1];
		linkGenerator_ID = 0;
		Projektor_ID = random.nextInt();
		linkGenerator = false;
		linkPower = 0;
		maxlinkPower = 1000000;
		ticker = 0;
		create = true;
		Subwater = false;
		Dome = false;
		hardner = false;
		dropper = true;
		zapper = false;
		camouflage = false;
		textur = -1;
		ffmeta = 0;
	}
	
	public final void addtogrid() {
		if(worldObj.isRemote) throw new RuntimeException("do not call this on smp clients");
		Linkgrid.getWorldMap(worldObj).getProjektor().put(getProjektor_ID(), this);
	}

	public final void removefromgrid() {
		if(worldObj.isRemote) throw new RuntimeException("do not call this on smp clients");
		Linkgrid.getWorldMap(worldObj).getProjektor().remove(getProjektor_ID());
	}
	
	// Can be approximate, but not too far off, since it's used to calculate
	// power consumption
	// (area projectors double-count edges and triple-count corners and always
	// assume cube shape in this; Thunderdark's version did the same thing)
	public abstract int estimateBlockCount();
	
	public void checkupgrades() {

		this.setSubwater(false);
		this.setDome(false);
		this.setHardner(false);
		this.setZapper(false);
		this.setCamouflage(false);

		for (int x = xCoord - 1; x <= xCoord + 1; x++) {
			for (int y = yCoord - 1; y <= yCoord + 1; y++) {
				for (int z = zCoord - 1; z <= zCoord + 1; z++) {

					if (worldObj.getBlockId(x, y, z) == mod_ModularForceFieldSystem.MFFSUpgrades.blockID) {

						int meta = worldObj.getBlockMetadata(x, y, z);

						TileEntity upgrades = worldObj.getBlockTileEntity(x, y, z);
						if (upgrades != null) {
							if (((TileEntityPassivUpgrade) upgrades).getconectet_ID() == 0 && (meta == 1 || meta == 2 || meta == 3 || meta == 6 || meta == 7)) {
								((TileEntityPassivUpgrade) upgrades).setconectet_ID(getProjektor_ID());
								((TileEntityPassivUpgrade) upgrades).setConnectet_typID((short) 2);
								worldObj.markBlockAsNeedsUpdate(upgrades.xCoord, upgrades.yCoord, upgrades.zCoord);
							}

							if (meta == 7) {
								if (((TileEntityCamoflageUpgrade) upgrades).getItem_ID() != getTextur()) {
									this.setTextur(((TileEntityCamoflageUpgrade) upgrades).getItem_ID());
								}

							}

							if (((TileEntityPassivUpgrade) upgrades).getconectet_ID() == getProjektor_ID() && ((TileEntityPassivUpgrade) upgrades).getConnectet_typID() == 2) {

								if (((TileEntityPassivUpgrade) upgrades).getActive() != this.getActive()) {
									((TileEntityPassivUpgrade) upgrades).setActive(this.getActive());
								}

								switch (meta) {
								case 1:
									this.setSubwater(true);
									break;
								case 2:
									this.setDome(true);
									break;
								case 3:
									this.setHardner(true);
									break;
								case 6:
									this.setZapper(true);
									break;
								case 7:
									this.setCamouflage(true);
									break;
								}
							}
						}
					}
				}
			}
		}
		
		if(specialffmeta != -1)
			setffmeta(specialffmeta);
		else if(isCamouflage() && isZapper())
			setffmeta((short)BlockForceField.META_ZAPPER_CAMO);
		else if(isCamouflage())
			setffmeta((short)BlockForceField.META_CAMO);
		else if(isZapper())
			setffmeta((short)BlockForceField.META_ZAPPER);
		else
			setffmeta((short)BlockForceField.META_NORMAL);
	}
	
	private CoordinateList fieldBlocks = null; // all blocks that are part of the field, regardless of mode
	private CoordinateList refreshBlocks = null; // all blocks that need refreshing each tick
	
	protected abstract void getFieldShape(CoordinateList list);
	
	private final boolean needsRefreshing(int mode) {
		return mode == MODE_FIELD;
	}
	
	protected final void createField() {
		fieldBlocks = new CoordinateList(estimateBlockCount());
		getFieldShape(fieldBlocks);
		
		{
			int k = 0;
			CoordinateList.CoordIterator it = fieldBlocks.iterate();
			while(it.hasNext()) {
				it.next();
				if(needsRefreshing(it.mode))
					k++;
			}
			
			refreshBlocks = new CoordinateList(k);
			it = fieldBlocks.iterate();
			while(it.hasNext()) {
				it.next();
				if(needsRefreshing(it.mode))
					refreshBlocks.add(it.x, it.y, it.z, it.mode);
			}
			
			refreshIterator = refreshBlocks.iterate();
		}
		
		CoordinateList.CoordIterator it = fieldBlocks.iterate();

		while(it.hasNext()) {
			it.next();
			
			FFBlock ffblock = FFWorld.get(worldObj).addOrGet(it.x, it.y, it.z);
			
			ffblock.addEntry(new FFBlock.Entry(getffmeta(), getLinkGenerator_ID(), getProjektor_ID(), it.mode, isHardner(), getTextur(), activatedTime));
		}
	}
	
	public void onActivateProjector() {}
	public void onDeactivateProjector() {}
	public void onEveryTick() {}
	public void onFieldTick() {}
	public boolean overrideActivationStatus(boolean redstone) {return redstone;}
	
	@Override
	public void updateEntity() {
		if(!worldObj.isRemote) {

			if (this.isCreate() && this.getLinkGenerator_ID() != 0) {
				addtogrid();
				addfreqcard();
				this.setCreate(false);
				if (this.getActive()) {
					checkupgrades();
					onActivateProjector();
					createField();
				}
			}

			if (this.getLinkGenerator_ID() != 0) {
				this.setLinkGenerator(true);
				try {
					this.setLinkPower(Linkgrid.getWorldMap(worldObj).getGenerator().get(this.getLinkGenerator_ID()).getForcepower());
					this.setMaxlinkPower(Linkgrid.getWorldMap(worldObj).getGenerator().get(this.getLinkGenerator_ID()).getMaxforcepower());
				} catch (java.lang.NullPointerException ex) {
					this.setLinkGenerator(false);
					this.setLinkPower(0);
					this.setMaxlinkPower(1000000);
				}
			} else {
				this.setLinkGenerator(false);
				this.setLinkPower(0);
				this.setMaxlinkPower(1000000);
			}

			boolean powerdirekt = worldObj.isBlockGettingPowered(xCoord, yCoord, zCoord);
			boolean powerindrekt = worldObj.isBlockIndirectlyGettingPowered(xCoord, yCoord, zCoord);
			
			boolean shouldActivate = overrideActivationStatus(powerdirekt || powerindrekt);

			if (shouldActivate && this.isLinkGenerator() && this.getLinkPower() > Forcepowerneed(estimateBlockCount(), true)) {

				if (getActive() != true) {
					setActive(true);
					createField();
					FieldGenerate(true);
					onActivateProjector();
					worldObj.markBlockNeedsUpdate(xCoord, yCoord, zCoord);
				}
			}
			if (!shouldActivate || !this.isLinkGenerator() || this.getLinkPower() < Forcepowerneed(estimateBlockCount(), false)) {

				if (getActive() != false) {
					setActive(false);
					onDeactivateProjector();
					destroyField();
					worldObj.markBlockNeedsUpdate(xCoord, yCoord, zCoord);
				}
			}

			if (getActive() && getWrenchDropRate() != -1.0F) {
				setWrenchRate(-1.0F);
			}
			if (!getActive() && getWrenchDropRate() != 1.0F) {
				setWrenchRate(1.0F);
			}
			
			onEveryTick();

			if (getActive()) {
				FieldGenerate(false);
			}

			if (this.getTicker() == 10) {
				checkupgrades();
				addfreqcard();
				onFieldTick();
				this.setTicker((short) 0);
			}
			this.setTicker((short) (this.getTicker() + 1));
		}
	}
	
	protected final void destroyField() {
		if(fieldBlocks == null)
			return;
		
		CoordinateList.CoordIterator it = fieldBlocks.iterate();
		while(it.hasNext()) {
			it.next();
			
			FFBlock ffblock = FFWorld.get(worldObj).get(it.x, it.y, it.z);
			if(ffblock != null)
				ffblock.removeEntry(getProjektor_ID());
		}
	}

	public boolean isCreate() {
		return create;
	}

	public void setCreate(boolean create) {
		this.create = create;
	}

	public short getTicker() {
		return ticker;
	}

	public void setTicker(short ticker) {
		this.ticker = ticker;
	}

	public int getTextur() {
		return textur;
	}

	public void setTextur(int textur) {
		this.textur = textur;
		baseUpdateCount++;
	}

	public short getffmeta() {
		return ffmeta;
	}

	public void setffmeta(short ffmeta) {
		this.ffmeta = ffmeta;
	}

	public int getMaxlinkPower() {
		return maxlinkPower;
	}

	public void setMaxlinkPower(int maxlinkPower) {
		this.maxlinkPower = maxlinkPower;
		baseUpdateCount++;
	}

	public boolean isLinkGenerator() {
		return linkGenerator;
	}

	public void setLinkGenerator(boolean linkGenerator) {
		this.linkGenerator = linkGenerator;
		baseUpdateCount++;
	}

	public int getLinkPower() {
		return linkPower;
	}

	public void setLinkPower(int linkPower) {
		this.linkPower = linkPower;
		baseUpdateCount++;
	}

	public int getLinkGenerator_ID() {
		return linkGenerator_ID;
	}

	public void setLinkGenerator_ID(int linkGenerator_ID) {
		this.linkGenerator_ID = linkGenerator_ID;
		baseUpdateCount++;
	}

	public boolean isCamouflage() {
		return camouflage;
	}

	public void setCamouflage(boolean camouflage) {
		this.camouflage = camouflage;
	}

	public boolean isZapper() {
		return zapper;
	}

	public void setZapper(boolean zapper) {
		this.zapper = zapper;
	}

	public boolean isSubwater() {
		return Subwater;
	}

	public void setSubwater(boolean subwater) {
		Subwater = subwater;
	}

	public boolean isDome() {
		return Dome;
	}

	public void setDome(boolean dome) {
		Dome = dome;
	}

	public boolean isDropper() {
		return dropper;
	}

	public void setDropper(boolean dropper) {
		this.dropper = dropper;
	}

	public boolean isHardner() {
		return hardner;
	}

	public void setHardner(boolean hardner) {
		this.hardner = hardner;
	}

	public void readFromNBT(NBTTagCompound nbttagcompound) {

		super.readFromNBT(nbttagcompound);
		Projektor_ID = nbttagcompound.getInteger("Projektor_ID");
		ffmeta = nbttagcompound.getShort("ffmeta");
		textur = nbttagcompound.getInteger("textur");

		NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
		ProjektorItemStacks = new ItemStack[getSizeInventory()];
		for (int i = 0; i < nbttaglist.tagCount(); i++) {
			NBTTagCompound nbttagcompound1 = (NBTTagCompound) nbttaglist.tagAt(i);
			byte byte0 = nbttagcompound1.getByte("Slot");
			if (byte0 >= 0 && byte0 < ProjektorItemStacks.length) {
				ProjektorItemStacks[byte0] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
			}
		}

	}

	public void writeToNBT(NBTTagCompound nbttagcompound) {

		super.writeToNBT(nbttagcompound);
		nbttagcompound.setInteger("Projektor_ID", Projektor_ID);
		nbttagcompound.setShort("ffmeta", ffmeta);
		nbttagcompound.setInteger("textur", textur);

		NBTTagList nbttaglist = new NBTTagList();
		for (int i = 0; i < ProjektorItemStacks.length; i++) {
			if (ProjektorItemStacks[i] != null) {
				NBTTagCompound nbttagcompound1 = new NBTTagCompound();
				nbttagcompound1.setByte("Slot", (byte) i);
				ProjektorItemStacks[i].writeToNBT(nbttagcompound1);
				nbttaglist.appendTag(nbttagcompound1);
			}
		}

		nbttagcompound.setTag("Items", nbttaglist);
	}

	public int getProjektor_ID() {
		return Projektor_ID;
	}
	
	private CoordinateList.CoordIterator refreshIterator;

	public void FieldGenerate(boolean init) {
		
		if(fieldBlocks == null) {
			createField();
		}

		int blockcounter = 0;
		int maxnbockcounter = 400;

		if (init || energy_ticker == 20) {
			CoordinateList.CoordIterator it = fieldBlocks.iterate();
			while(it.hasNext()) {
				it.next();
				
				FFBlock ffblock = FFWorld.get(worldObj).get(it.x, it.y, it.z);
				if(ffblock != null)
					ffblock.useEnergyFor(getProjektor_ID());
			}

			energy_ticker = 0;
		}
		else
		{
			energy_ticker++;
			if(mod_ModularForceFieldSystem.slowRefresh)
				return; 
		}
		
		int left = mod_ModularForceFieldSystem.refreshSpeed;
		if(left == 0)
			left = Integer.MAX_VALUE;
		
		CoordinateList.CoordIterator it = refreshIterator;
		
		FFWorld ffworld = FFWorld.get(worldObj);
		
		while(it.hasNext() && (left > 0)) {
			it.next();
			
			left--;
			
			FFBlock ffblock = ffworld.get(it.x, it.y, it.z);
			if(ffblock != null)
				ffblock.refresh();
		}
		
		if(!it.hasNext())
			refreshIterator = refreshBlocks.iterate();
	}

	public int Forcepowerneed(int blocks, boolean init) {
		int forcepower;
		forcepower = blocks * mod_ModularForceFieldSystem.forcefieldblockcost;
		if (init) {
			forcepower = (forcepower * mod_ModularForceFieldSystem.forcefieldblockcreatemodifier) + (forcepower * 5);
		}
		return forcepower;
	}

	// card function

	public void addfreqcard() {

		if (getStackInSlot(0) != null) {
			if (getStackInSlot(0).getItem() == mod_ModularForceFieldSystem.MFFSitemfc) {

				if (linkGenerator_ID != Functions.getTAGfromItemstack(getStackInSlot(0)).getInteger("Generator_ID")) {
					linkGenerator_ID = Functions.getTAGfromItemstack(getStackInSlot(0)).getInteger("Generator_ID");
				}

			}
		} else {
			linkGenerator_ID = 0;
		}

	}

	public ItemStack decrStackSize(int i, int j) {
		if (ProjektorItemStacks[i] != null) {
			if (ProjektorItemStacks[i].stackSize <= j) {
				ItemStack itemstack = ProjektorItemStacks[i];
				ProjektorItemStacks[i] = null;
				return itemstack;
			}
			ItemStack itemstack1 = ProjektorItemStacks[i].splitStack(j);
			if (ProjektorItemStacks[i].stackSize == 0) {
				ProjektorItemStacks[i] = null;
			}
			return itemstack1;
		} else {
			return null;
		}
	}

	public void setInventorySlotContents(int i, ItemStack itemstack) {
		ProjektorItemStacks[i] = itemstack;
		if (itemstack != null && itemstack.stackSize > getInventoryStackLimit()) {
			itemstack.stackSize = getInventoryStackLimit();
		}
	}

	public boolean canInteractWith(EntityPlayer entityplayer) {
		if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this) {
			return false;
		} else {
			return entityplayer.getDistanceSq((double) xCoord + 0.5D, (double) yCoord + 0.5D, (double) zCoord + 0.5D) <= 64D;
		}
	}

	public ItemStack getStackInSlot(int i) {
		return ProjektorItemStacks[i];
	}

	public String getInvName() {

		return "Projektor";
	}

	public int getInventoryStackLimit() {
		return 1;
	}

	public int getSizeInventory() {
		return ProjektorItemStacks.length;
	}

	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this) {
			return false;
		} else {
			return entityplayer.getDistance((double) xCoord + 0.5D, (double) yCoord + 0.5D, (double) zCoord + 0.5D) <= 64D;
		}
	}

	@Override
	public void openChest() {

	}

	@Override
	public void closeChest() {

	}

}
