package mffs;

import immibis.core.NonSharedProxy;

import java.util.*;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import net.minecraft.src.Chunk;
import net.minecraft.src.ModLoader;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.World;
import net.minecraft.src.forge.DimensionManager;
import net.minecraft.src.forge.ISaveEventHandler;
import net.minecraft.src.forge.MinecraftForge;

public class FFWorld {
	private static void removeOldWorlds() {
		Set<World> curWorlds = new HashSet<World>();
		for(World w : DimensionManager.getWorlds())
			curWorlds.add(w);
		
		// Forge bug workaround
		if(NonSharedProxy.CLIENT)
			curWorlds.add(mod_ModularForceFieldSystem.getClientWorld());
		
		for(World w : new ArrayList<World>(worlds.keySet()))
			if(!curWorlds.contains(w))
				worlds.remove(w);
	}
	private static Map<World, FFWorld> worlds = new HashMap<World, FFWorld>();
	
	public static FFWorld get(World w) {
		if(w == null)
			return null;
		FFWorld ffw = worlds.get(w);
		if(ffw == null)
			worlds.put(w, ffw = new FFWorld(w));
		return ffw;
	}
	
	private World w;
	private FFWorld(World w) {
		this.w = w;
	}
	
	private Map<String, FFBlock> blocks = new HashMap<String, FFBlock>();
	private StringBuilder hasher = new StringBuilder();
	private CoordinateList refreshQueue = null;
	
	public FFBlock addOrGet(int x, int y, int z) {
		hasher.setLength(0);
		hasher.append(x).append("/").append(y).append("/").append(z);
		String hash = hasher.toString();
		
		FFBlock b = blocks.get(hash);
		if(b == null)
			blocks.put(hash, b = new FFBlock(x, y, z, w));
		
		return b;
	}
	
	public FFBlock get(int x, int y, int z) {
		hasher.setLength(0);
		hasher.append(x).append("/").append(y).append("/").append(z);
		return blocks.get(hasher.toString());
	}

	public void remove(int x, int y, int z) {
		hasher.setLength(0);
		hasher.append(x).append("/").append(y).append("/").append(z);
		blocks.remove(hasher.toString());
	}

	public void queueRefresh(int i, int j, int k) {
		if(refreshQueue == null)
			refreshQueue = new CoordinateList(8);
		refreshQueue.add(i, j, k, 0);
	}
	
	public void tick() {
		if(refreshQueue != null) {
			CoordinateList.CoordIterator it = refreshQueue.iterate();
			while(it.hasNext()) {
				it.next();
				FFBlock ffb = get(it.x, it.y, it.z);
				if(ffb != null) {
					ffb.refresh();
					ffb.refreshCamo();
				}
			}
			
			if(refreshQueue.getAllocatedSize() > 100)
				refreshQueue = null;
			else
				refreshQueue.clear();
		}
	}
	
	public static void tickAll() {
		removeOldWorlds();
		for(FFWorld w : worlds.values())
			w.tick();
	}
}
