package net.minecraft.src;

/* $if client$ */
import net.minecraft.client.Minecraft;
/* $else$
import net.minecraft.server.MinecraftServer;
$endif$ */
import net.minecraft.src.forge.*;
import immibis.core.*;
import immibis.tubestuff.*;

public class mod_TubeStuff extends CompatibleBaseMod implements IGuiHandler {
	public static mod_TubeStuff instance;
	public static BlockTubestuff block;
	public static Item itemUseless;
	
	private static EntityPlayerFakeTS fakePlayer;
	
	public static final int GUI_BUFFER = 0;
	public static final int GUI_TABLE = 1;
	public static final int GUI_CHEST = 2;
	public static final int GUI_LOGICCRAFTER = 3;
	public static final int GUI_RETRIEVULATOR = 4;
	public static final int GUI_DUPLICATOR = 5;
	
	public static EntityPlayerFakeTS fakePlayer(World world) {
		if(fakePlayer == null)
			fakePlayer = new EntityPlayerFakeTS(world);
		return fakePlayer;
	}
	
	public mod_TubeStuff() {
		instance = this;
	}
	
	public String getPriorities() {
		return "after:mod_ImmibisCore";
	}

	@Override
	public String getVersion() {
		return ModInfoReader.getModInfoField("/immibis/mod_TubeStuff.info.txt", "version");
	}
	
	@Override
	/* $if client$ */
	public boolean onTickInGame(float f, Minecraft mc) {
	/* $else$
	public boolean onTickInGame(MinecraftServer mc) {
	$endif$ */
		SharedProxy.FirstTick();
		return false;
	}

	@Override
	public void load() {
		BlockTubestuff.model = NonSharedProxy.getUniqueBlockModelID(this, true);
		
		ModLoader.setInGameHook(this, true, true);
		MinecraftForge.setGuiHandler(this, this);
		
		CoreProxy.RegisterBlockID("tubestuff", new IBlockIDCallback() {
			@Override
			public void registerBlock(int id) {
				block = new BlockTubestuff(id);
				ModLoader.registerBlock(block, ItemTubestuff.class);
				ModLoader.registerTileEntity(TileBuffer.class, "TubeStuff buffer");
				ModLoader.registerTileEntity(TileCraftingTable.class, "TubeStuff crafting table");
				ModLoader.registerTileEntity(TileLogicCrafter.class, "TubeStuff logic crafter");
				ModLoader.registerTileEntity(TileRetrievulator.class, "TubeStuff retrievulator");
				ModLoader.registerTileEntity(TileIncinerator.class, "TubeStuff incinerator");
				ModLoader.registerTileEntity(TileDuplicator.class, "TubeStuff duplicator");
				/* $if client$ */
				ModLoader.registerTileEntity(TileInfiniteChest.class, "TubeStuff infinite chest", new RenderTileInfiniteChest());
				/* $else$
				ModLoader.registerTileEntity(TileInfiniteChest.class, "TubeStuff infinite chest");
				$endif$ */
			}
		});
		
		itemUseless = (new Item(Config.getItemID("tubestuff.uselessItem", 7614)-256));
		itemUseless.setTextureFile("/immibis/tubestuff/blocks.png");
		itemUseless.setItemName("tubestuff.uselessItem");
		itemUseless.setIconIndex(5);
		itemUseless.setMaxStackSize(1);
		ModLoader.addName(itemUseless, "Retriever jammer");
	}
	
	/* $if client$ */
	@Override
	public void renderInvBlock(RenderBlocks rb, Block block, int meta, int model) {
		//if(meta != 2) {
			BlockTubestuff.model = 0;
			rb.renderBlockAsItem(block, meta, 1.0f);
			BlockTubestuff.model = model;
		//}
	}
	
	@Override
	public boolean renderWorldBlock(RenderBlocks rb, IBlockAccess w, int x, int y, int z, Block block, int model) {
		int meta = w.getBlockMetadata(x, y, z);
		if(meta != 2 || !SharedProxy.enableBHCAnim()) {
			BlockTubestuff.model = 0;
			rb.renderStandardBlock(block, x, y, z);
			BlockTubestuff.model = model;
		}
		return true;
	}
	/* $endif$ */

	@Override
	public Object getGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
		TileEntity tile = world.getBlockTileEntity(x, y, z);
		switch(ID) {
		/* $if client$ */
		case GUI_BUFFER:
			return new GuiChest(player.inventory, (TileBuffer)tile);
		case GUI_TABLE:
			return new GuiCraftingTable(player, (TileCraftingTable)tile);
		case GUI_CHEST:
			return new GuiInfiniteChest(player, (TileInfiniteChest)tile);
		case GUI_LOGICCRAFTER:
			return new GuiLogicCrafter(player, (TileLogicCrafter)tile);
		case GUI_DUPLICATOR:
			return new GuiOneSlot(new ContainerOneSlot(player, ((TileDuplicator)tile).getGuiInventory()), "Duplicator");
		case GUI_RETRIEVULATOR:
			return new GuiRetrievulator(player, (TileRetrievulator)tile);
		/* $else
		case GUI_BUFFER:
			return new ContainerChest(player.inventory, (TileBuffer)tile);
		case GUI_TABLE:
			return new ContainerCraftingTable(player, (TileCraftingTable)tile);
		case GUI_CHEST:
			return new ContainerInfiniteChest(player, (TileInfiniteChest)tile);
		case GUI_LOGICCRAFTER:
			return new ContainerLogicCrafter(player, (TileLogicCrafter)tile);
		case GUI_DUPLICATOR:
			return new ContainerOneSlot(player, ((TileDuplicator)tile).getGuiInventory());
		case GUI_RETRIEVULATOR:
			return new ContainerRetrievulator(player, (TileRetrievulator)tile);
		$endif$ */
		}
		return null;
	}
	
	public static final boolean areItemsEqual(ItemStack recipe, ItemStack input)
	{
		return input.itemID == recipe.itemID && (!input.getHasSubtypes() || input.getItemDamage() == recipe.getItemDamage());
	}
}
