/*
 * Decompiled with CFR 0.152.
 */
package net.thecondemned.LumySkinPatch;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.logging.Level;

public class mod_LumySkinPatch
extends BaseMod {
    public String getVersion() {
        return "1.0.13";
    }

    public void load() {
        InputStream stream = Loader.class.getClassLoader().getResourceAsStream("fmlversion.properties");
        Properties properties = new Properties();
        String mcVersion = "";
        if (stream != null) {
            try {
                properties.load(stream);
                mcVersion = properties.getProperty("fmlbuild.mcclientversion", "none");
            }
            catch (IOException ex) {
                FMLCommonHandler.instance().getFMLLogger().log(Level.SEVERE, "[LumySkinPatch] Could not get FML version information - corrupted installation detected!", ex);
                throw new LoaderException((Throwable)ex);
            }
        }
        if (mcVersion.equals("1.2.5")) {
            this.patchClass("ahw", mcVersion);
        }
        if (mcVersion.equals("1.2.5")) {
            this.patchClass("mx", mcVersion);
        }
    }

    private void patchClass(String name, String mcVersion) {
        try {
            int nRead;
            String path = "class/" + mcVersion + "/" + name.replace(".", "/") + ".class";
            FMLCommonHandler.instance().getFMLLogger().info("[LumySkinPatch] Patching " + name + " to fix skin issue on Minecraft " + mcVersion + " ...");
            ClassLoader classloader = Thread.currentThread().getContextClassLoader();
            InputStream is = classloader.getResourceAsStream(path);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            byte[] byte_class = buffer.toByteArray();
            if (byte_class != null) {
                this.loadClass(name, byte_class);
                FMLCommonHandler.instance().getFMLLogger().info("[LumySkinPatch] " + name + " patched!");
            } else {
                FMLCommonHandler.instance().getFMLLogger().info("[LumySkinPatch] " + name + " NOT patched!");
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("[LumySkinPatch] Error on patching " + name, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClass(String className, byte[] b) {
        Class clazz = null;
        try {
            ClassLoader loader = ModClassLoader.class.getClassLoader();
            Class<?> cls = Class.forName("java.lang.ClassLoader");
            Method method = cls.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            try {
                Object[] args = new Object[]{className, b, new Integer(0), new Integer(b.length)};
                clazz = (Class)method.invoke((Object)loader, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                method.setAccessible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clazz;
    }
}

