/*
 * Decompiled with CFR 0.152.
 */
package mcyu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mcyu.MCYUAnalysisThread;

public class MCYUWindow
extends JFrame {
    private MCYUAnalysisThread analysis = null;
    private String override = null;
    private JTextArea log;
    private JButton ctc;
    private String results = "";

    MCYUWindow() {
        this.setDefaultCloseOperation(3);
        this.setSize(640, 480);
        this.setLocationRelativeTo(null);
        this.setTitle("MCYU r2");
        this.setLayout(new BorderLayout(4, 4));
        this.log = new JTextArea("");
        this.log.setFont(new Font("Courier New", 0, 12));
        this.log.setEditable(false);
        JScrollPane slog = new JScrollPane(this.log);
        slog.setHorizontalScrollBarPolicy(31);
        this.ctc = new JButton("Copy to clipboard");
        this.ctc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(new StringSelection(MCYUWindow.this.results), null);
            }
        });
        this.ctc.setEnabled(false);
        this.add((Component)slog, "Center");
        this.add((Component)this.ctc, "Last");
    }

    public void display() {
        this.setVisible(true);
    }

    public void performAnalysisThreaded() {
        if (this.analysis != null) {
            return;
        }
        this.log.setText("Analysis in progress. Please wait...");
        this.analysis = new MCYUAnalysisThread();
        this.analysis.setDaemon(true);
        this.analysis.setWindow(this);
        this.analysis.setData(this.override);
        this.analysis.start();
    }

    protected void onAnalysisDone(String result) {
        this.log.setText(result);
        this.results = result;
        this.analysis = null;
        this.ctc.setEnabled(true);
        this.checkLog();
    }

    public void checkLog() {
        if (this.results.contains("META-INF is not empty")) {
            JOptionPane.showMessageDialog(this, "META-INF is not empty.");
        }
    }

    public void setOverride(String overrideIn) {
        this.override = overrideIn;
    }
}

