/*
 * Decompiled with CFR 0.152.
 */
package ic2.platform;

import forge.Configuration;
import forge.Property;
import ic2.common.AudioPosition;
import ic2.common.PositionSpec;
import ic2.platform.AudioSource;
import ic2.platform.Platform;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;

public final class AudioManager {
    public static float defaultVolume = 1.2f;
    public static float fadingDistance = 16.0f;
    private static boolean enabled = true;
    private static int maxSourceCount = 32;
    private static int streamingSourceCount = 4;
    private static boolean lateInitDone = false;
    private static SoundSystem soundSystem = null;
    private static float masterVolume = 0.5f;
    private static int ticker = 0;
    private static int nextId = 0;
    private static Map objectToAudioSourceMap = new HashMap();

    public static void initialize(Configuration config) {
        if (config != null) {
            Property prop = config.getOrCreateBooleanProperty("soundsEnabled", "general", enabled);
            prop.comment = "Enable sounds";
            enabled = Boolean.parseBoolean(prop.value);
            prop = config.getOrCreateIntProperty("soundSourceLimit", "general", maxSourceCount);
            prop.comment = "Maximum number of audio sources, only change if you know what you're doing";
            maxSourceCount = Integer.parseInt(prop.value);
            config.save();
            if (maxSourceCount <= 6) {
                enabled = false;
            }
        }
        if (!enabled) {
            return;
        }
        if (maxSourceCount < 6) {
            enabled = false;
            return;
        }
        System.out.println("[IC2] Using " + maxSourceCount + " audio sources.");
        SoundSystemConfig.setNumberStreamingChannels((int)streamingSourceCount);
        SoundSystemConfig.setNumberNormalChannels((int)(maxSourceCount - streamingSourceCount));
    }

    public static void onTick() {
        if (!enabled || soundSystem == null) {
            return;
        }
        lv.a((String)"UpdateMasterVolume");
        float configSoundVolume = ModLoader.getMinecraftInstance().A.b;
        if (configSoundVolume != masterVolume) {
            masterVolume = configSoundVolume;
        }
        lv.c((String)"UpdateSourceVolume");
        yw player = Platform.getPlayerInstance();
        PriorityQueue<AudioSource> validAudioSources = new PriorityQueue<AudioSource>();
        for (List audioSourceList : objectToAudioSourceMap.values()) {
            for (AudioSource audioSource : audioSourceList) {
                audioSource.updateVolume(player);
                if (!(audioSource.getRealVolume() > 0.0f)) continue;
                validAudioSources.add(audioSource);
            }
        }
        lv.c((String)"Culling");
        int i = 0;
        while (!validAudioSources.isEmpty()) {
            if (i < maxSourceCount) {
                ((AudioSource)validAudioSources.poll()).activate();
            } else {
                ((AudioSource)validAudioSources.poll()).cull();
            }
            ++i;
        }
        lv.b();
    }

    public static AudioSource createSource(Object obj, String initialSoundFile) {
        return AudioManager.createSource(obj, PositionSpec.Center, initialSoundFile, false, false, defaultVolume);
    }

    public static AudioSource createSource(Object obj, PositionSpec positionSpec, String initialSoundFile, boolean loop, boolean priorized, float volume) {
        if (!enabled) {
            return null;
        }
        if (soundSystem == null) {
            AudioManager.getSoundSystem();
        }
        if (soundSystem == null) {
            return null;
        }
        String sourceName = AudioManager.getSourceName(nextId);
        ++nextId;
        AudioSource audioSource = new AudioSource(soundSystem, sourceName, obj, positionSpec, initialSoundFile, loop, priorized, volume);
        if (!objectToAudioSourceMap.containsKey(obj)) {
            objectToAudioSourceMap.put(obj, new LinkedList());
        }
        ((List)objectToAudioSourceMap.get(obj)).add(audioSource);
        return audioSource;
    }

    public static void removeSources(Object obj) {
        if (soundSystem == null) {
            return;
        }
        if (!objectToAudioSourceMap.containsKey(obj)) {
            return;
        }
        for (AudioSource audioSource : (List)objectToAudioSourceMap.get(obj)) {
            audioSource.remove();
        }
        objectToAudioSourceMap.remove(obj);
    }

    public static void playOnce(Object obj, String soundFile) {
        AudioManager.playOnce(obj, PositionSpec.Center, soundFile, false, defaultVolume);
    }

    public static void playOnce(Object obj, PositionSpec positionSpec, String soundFile, boolean priorized, float volume) {
        if (!enabled) {
            return;
        }
        if (soundSystem == null) {
            AudioManager.getSoundSystem();
        }
        if (soundSystem == null) {
            return;
        }
        AudioPosition position = AudioPosition.getFrom(obj, positionSpec);
        URL url = AudioSource.class.getClassLoader().getResource("ic2/sounds/" + soundFile);
        if (url == null) {
            System.out.println("[IC2]  Invalid sound file: " + soundFile);
            return;
        }
        String sourceName = soundSystem.quickPlay(priorized, url, soundFile, false, position.x, position.y, position.z, 2, fadingDistance * Math.max(volume, 1.0f));
        soundSystem.setVolume(sourceName, masterVolume * Math.min(volume, 1.0f));
    }

    public static float getMasterVolume() {
        return masterVolume;
    }

    private static boolean testSourceCount(int n) {
        IntBuffer sourceBuffer = BufferUtils.createIntBuffer((int)n);
        try {
            AL10.alGenSources((IntBuffer)sourceBuffer);
            if (AL10.alGetError() == 0) {
                AL10.alDeleteSources((IntBuffer)sourceBuffer);
                return true;
            }
        }
        catch (Exception e) {
            AL10.alGetError();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        return false;
    }

    private static void getSoundSystem() {
        for (Field field : sd.class.getDeclaredFields()) {
            if (field.getType() != SoundSystem.class) continue;
            field.setAccessible(true);
            try {
                Object obj = field.get(null);
                if (!(obj instanceof SoundSystem)) break;
                soundSystem = (SoundSystem)obj;
            }
            catch (Exception e) {
                e.printStackTrace();
                soundSystem = null;
            }
            break;
        }
    }

    private static String getSourceName(int id) {
        return "asm_snd" + id;
    }
}

