/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import ic2.api.IElectricItem;
import ic2.common.ItemIC2;
import ic2.common.StackUtil;
import ic2.platform.Platform;
import java.util.ArrayList;

public abstract class ElectricItem
extends ItemIC2
implements IElectricItem {
    public int maxCharge;
    public int transferLimit = 100;
    public int tier = 1;

    public static int charge(aan itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (!(itemStack.a() instanceof IElectricItem) || amount < 0 || itemStack.a > 1) {
            return 0;
        }
        IElectricItem item = (IElectricItem)itemStack.a();
        if (item.getTier() > tier) {
            return 0;
        }
        if (amount > item.getTransferLimit() && !ignoreTransferLimit) {
            amount = item.getTransferLimit();
        }
        ady nbtData = StackUtil.getOrCreateNbtData(itemStack);
        int charge = nbtData.f("charge");
        if (amount > item.getMaxCharge() - charge) {
            amount = item.getMaxCharge() - charge;
        }
        charge += amount;
        if (!simulate) {
            nbtData.a("charge", charge);
            int n = itemStack.c = charge > 0 ? item.getChargedItemId() : item.getEmptyItemId();
            if (itemStack.a() instanceof IElectricItem) {
                item = (IElectricItem)itemStack.a();
                if (itemStack.j() > 2) {
                    itemStack.b(1 + (item.getMaxCharge() - charge) * (itemStack.j() - 2) / item.getMaxCharge());
                } else {
                    itemStack.b(0);
                }
            } else {
                itemStack.b(0);
            }
        }
        return amount;
    }

    public static int discharge(aan itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        ady nbtData;
        int charge;
        if (!(itemStack.a() instanceof IElectricItem) || amount < 0 || itemStack.a > 1) {
            return 0;
        }
        IElectricItem item = (IElectricItem)itemStack.a();
        if (item.getTier() > tier) {
            return 0;
        }
        if (amount > item.getTransferLimit() && !ignoreTransferLimit) {
            amount = item.getTransferLimit();
        }
        if (amount > (charge = (nbtData = StackUtil.getOrCreateNbtData(itemStack)).f("charge"))) {
            amount = charge;
        }
        charge -= amount;
        if (!simulate) {
            nbtData.a("charge", charge);
            int n = itemStack.c = charge > 0 ? item.getChargedItemId() : item.getEmptyItemId();
            if (itemStack.a() instanceof IElectricItem) {
                item = (IElectricItem)itemStack.a();
                if (itemStack.j() > 2) {
                    itemStack.b(1 + (item.getMaxCharge() - charge) * (itemStack.j() - 2) / item.getMaxCharge());
                } else {
                    itemStack.b(0);
                }
            } else {
                itemStack.b(0);
            }
        }
        return amount;
    }

    public static boolean canUse(aan itemStack, int amount) {
        ady nbtData = StackUtil.getOrCreateNbtData(itemStack);
        return nbtData.f("charge") >= amount;
    }

    public static boolean use(aan itemStack, int amount, yw player) {
        if (Platform.isSimulating() && itemStack.a() instanceof IElectricItem) {
            ElectricItem.chargeFromArmor(itemStack, player);
            int transfer = ElectricItem.discharge(itemStack, amount, Integer.MAX_VALUE, true, true);
            if (transfer == amount) {
                ElectricItem.discharge(itemStack, amount, Integer.MAX_VALUE, true, false);
                ElectricItem.chargeFromArmor(itemStack, player);
                return true;
            }
        }
        return false;
    }

    public static void chargeFromArmor(aan itemStack, yw player) {
        if (!Platform.isSimulating() || player == null || !(itemStack.a() instanceof IElectricItem)) {
            return;
        }
        boolean inventoryChanged = false;
        for (int i = 0; i < 4; ++i) {
            IElectricItem armorItem;
            aan armorItemStack = player.ap.b[i];
            if (armorItemStack == null || !(armorItemStack.a() instanceof IElectricItem) || !(armorItem = (IElectricItem)armorItemStack.a()).canProvideEnergy() || armorItem.getTier() < ((IElectricItem)itemStack.a()).getTier()) continue;
            int transfer = ElectricItem.charge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
            if ((transfer = ElectricItem.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, false)) <= 0) continue;
            ElectricItem.charge(itemStack, transfer, Integer.MAX_VALUE, true, false);
            inventoryChanged = true;
        }
        if (inventoryChanged) {
            player.ap.j();
        }
    }

    public ElectricItem(int id, int index) {
        super(id, index);
        this.g(27);
        this.f(1);
    }

    @Override
    public boolean canProvideEnergy() {
        return false;
    }

    @Override
    public int getChargedItemId() {
        return this.bQ;
    }

    @Override
    public int getEmptyItemId() {
        return this.bQ;
    }

    @Override
    public int getMaxCharge() {
        return this.maxCharge;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public int getTransferLimit() {
        return this.transferLimit;
    }

    @Override
    public void addCreativeItems(ArrayList itemList) {
        aan charged = new aan((yr)this, 1);
        ElectricItem.charge(charged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        itemList.add(charged);
        itemList.add(new aan((yr)this, 1, this.h()));
    }
}

