/*
 * Decompiled with CFR 0.152.
 */
package ic2.common;

import forge.DimensionManager;
import ic2.platform.Platform;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;

public class DataEncoder {
    public static Object decode(DataInputStream is) throws IOException {
        byte type = is.readByte();
        switch (type) {
            case 0: {
                return is.readInt();
            }
            case 1: {
                int length = is.readShort();
                int[] data = new int[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readInt();
                }
                return data;
            }
            case 2: {
                return is.readShort();
            }
            case 3: {
                int length = is.readShort();
                short[] data = new short[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readShort();
                }
                return data;
            }
            case 4: {
                return is.readByte();
            }
            case 5: {
                int length = is.readShort();
                byte[] data = new byte[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readByte();
                }
                return data;
            }
            case 6: {
                return is.readLong();
            }
            case 7: {
                int length = is.readShort();
                long[] data = new long[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readLong();
                }
                return data;
            }
            case 8: {
                return is.readBoolean();
            }
            case 9: {
                int length = is.readShort();
                boolean[] data = new boolean[length];
                byte b = 0;
                for (int i = 0; i < length; ++i) {
                    if (i % 8 == 0) {
                        b = is.readByte();
                    }
                    data[i] = (b & 1 << i % 8) != 0;
                }
                return data;
            }
            case 10: {
                int length = is.readShort();
                char[] data = new char[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = is.readChar();
                }
                return new String(data);
            }
            case 11: {
                int length = is.readShort();
                String[] data = new String[length];
                for (int i = 0; i < length; ++i) {
                    int slength = is.readShort();
                    char[] sdata = new char[slength];
                    for (int j = 0; j < slength; ++j) {
                        sdata[j] = is.readChar();
                    }
                    data[i] = new String(sdata);
                }
                return data;
            }
            case 12: {
                short id = is.readShort();
                if (id == 0) {
                    return null;
                }
                byte stackSize = is.readByte();
                short meta = is.readShort();
                aan stack = new aan((int)id, (int)stackSize, (int)meta);
                if (yr.e[id].i() || Platform.unknown1(yr.e[id])) {
                    stack.d(at.a((DataInput)is));
                }
                return stack;
            }
            case 13: {
                return gh.b((DataInput)is);
            }
            case 14: {
                byte kind = is.readByte();
                int id = is.readInt();
                switch (kind) {
                    case 0: {
                        return pb.m[id];
                    }
                    case 1: {
                        return yr.e[id];
                    }
                    case 2: {
                        return dp.e.get(id);
                    }
                    case 3: {
                        return aad.a[id];
                    }
                    case 4: {
                        return jt.a[id];
                    }
                }
            }
            case 15: {
                byte kind = is.readByte();
                int x = is.readInt();
                int y = 0;
                if (kind == 1) {
                    y = is.readInt();
                }
                int z = is.readInt();
                switch (kind) {
                    case 0: {
                        return new sj(x, z);
                    }
                    case 1: {
                        return new uh(x, y, z);
                    }
                }
            }
            case 16: {
                int dimension = is.readInt();
                int x = is.readInt();
                int y = is.readInt();
                int z = is.readInt();
                return DimensionManager.getWorld((int)dimension).b(x, y, z);
            }
            case 17: {
                int dimension = is.readInt();
                return DimensionManager.getWorld((int)dimension);
            }
            case 127: {
                return null;
            }
        }
        Platform.displayError("An unknown data type was received over multiplayer to be decoded.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: type ID " + type + ")");
        return null;
    }

    public static void encode(DataOutputStream os, Object o) throws IOException {
        if (o instanceof Integer) {
            os.writeByte(0);
            os.writeInt((Integer)o);
        } else if (o instanceof int[]) {
            os.writeByte(1);
            int[] oa = (int[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeInt(oa[i]);
            }
        } else if (o instanceof Short) {
            os.writeByte(2);
            os.writeShort(((Short)o).shortValue());
        } else if (o instanceof short[]) {
            os.writeByte(3);
            short[] oa = (short[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeShort(oa[i]);
            }
        } else if (o instanceof Byte) {
            os.writeByte(4);
            os.writeByte(((Byte)o).byteValue());
        } else if (o instanceof byte[]) {
            os.writeByte(5);
            byte[] oa = (byte[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeByte(oa[i]);
            }
        } else if (o instanceof Long) {
            os.writeByte(6);
            os.writeLong((Long)o);
        } else if (o instanceof long[]) {
            os.writeByte(7);
            long[] oa = (long[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeLong(oa[i]);
            }
        } else if (o instanceof Boolean) {
            os.writeByte(8);
            os.writeBoolean((Boolean)o);
        } else if (o instanceof boolean[]) {
            os.writeByte(9);
            boolean[] oa = (boolean[])o;
            os.writeShort(oa.length);
            int b = 0;
            for (int i = 0; i < oa.length; ++i) {
                if (i % 8 == 0 && i > 0) {
                    os.writeByte(b);
                    b = 0;
                }
                b = (byte)(b | (oa[i] ? 1 : 0) << i % 8);
            }
            os.writeByte(b);
        } else if (o instanceof String) {
            os.writeByte(10);
            String oa = (String)o;
            os.writeShort(oa.length());
            os.writeChars(oa);
        } else if (o instanceof String[]) {
            os.writeByte(11);
            String[] oa = (String[])o;
            os.writeShort(oa.length);
            for (int i = 0; i < oa.length; ++i) {
                os.writeShort(oa[i].length());
                os.writeChars(oa[i]);
            }
        } else if (o instanceof aan) {
            ady compound;
            os.writeByte(12);
            aan oa = (aan)o;
            os.writeShort(oa.c);
            if (oa.c == 0) {
                return;
            }
            os.writeByte(oa.a);
            os.writeShort(oa.i());
            if ((yr.e[oa.c].i() || Platform.unknown1(yr.e[oa.c])) && (compound = oa.o()) != null) {
                at.a((ady)compound, (DataOutput)os);
            }
        } else if (o instanceof gh) {
            os.writeByte(13);
            gh.a((gh)((gh)o), (DataOutput)os);
        } else if (o instanceof pb) {
            os.writeByte(14);
            os.writeByte(0);
            os.writeInt(((pb)o).bO);
        } else if (o instanceof yr) {
            os.writeByte(14);
            os.writeByte(1);
            os.writeInt(((yr)o).bQ);
        } else if (o instanceof aeb) {
            os.writeByte(14);
            os.writeByte(2);
            os.writeInt(((aeb)o).e);
        } else if (o instanceof aad) {
            os.writeByte(14);
            os.writeByte(3);
            os.writeInt(((aad)o).H);
        } else if (o instanceof jt) {
            os.writeByte(14);
            os.writeByte(4);
            os.writeInt(((jt)o).w);
        } else if (o instanceof uh) {
            os.writeByte(15);
            os.writeByte(0);
            uh oa = (uh)o;
            os.writeInt(oa.a);
            os.writeInt(oa.b);
            os.writeInt(oa.c);
        } else if (o instanceof sj) {
            os.writeByte(15);
            os.writeByte(1);
            sj oa = (sj)o;
            os.writeInt(oa.a);
            os.writeInt(oa.b() - 8 >> 4);
        } else if (o instanceof kw) {
            os.writeByte(16);
            kw oa = (kw)o;
            os.writeInt(oa.i.t.g);
            os.writeInt(oa.j);
            os.writeInt(oa.k);
            os.writeInt(oa.l);
        } else if (o instanceof xd) {
            os.writeByte(17);
            os.writeInt(((xd)o).t.g);
        } else if (o == null) {
            os.writeByte(127);
        } else {
            Platform.displayError("An unknown data type was attempted to be encoded for sending through\nmultiplayer.\nThis could happen due to a bug.\n\n(Technical information: " + o.getClass().getName() + ")");
        }
    }
}

