/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.legacywrapper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.ClosedByInterruptException;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import net.technicpack.legacywrapper.StartupParameters;

public class MinecraftClassLoader
extends URLClassLoader {
    Map<String, byte[]> pngResource = new HashMap<String, byte[]>();
    Map<String, List<URL>> resources = new HashMap<String, List<URL>>();
    private HashMap<String, Class<?>> loadedClasses = new HashMap(10000);
    private HashSet<String> preloaded = new HashSet();
    private HashMap<String, File> classLocations = new HashMap(10000);
    private String assetsDirectory;

    public MinecraftClassLoader(ClassLoader parent, File modpackJar, File[] libraries, StartupParameters startupParams) {
        super(new URL[0], parent);
        this.assetsDirectory = startupParams.getAssetsDirectory();
        for (File f : libraries) {
            try {
                this.addURL(f.toURI().toURL());
                this.index(f);
            }
            catch (ClosedByInterruptException e) {
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.addURL(modpackJar.toURI().toURL());
            this.index(modpackJar);
        }
        catch (ClosedByInterruptException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void index(File file) throws IOException {
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Enumeration<JarEntry> i = jar.entries();
            while (i.hasMoreElements()) {
                JarEntry entry = i.nextElement();
                if (!entry.getName().endsWith(".class")) continue;
                String name = entry.getName();
                name = name.replace("/", ".").substring(0, name.length() - 6);
                this.classLocations.put(name, file);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public int preloadClasses(int amount) {
        Iterator<Map.Entry<String, File>> i = this.classLocations.entrySet().iterator();
        int preloaded = 0;
        while (i.hasNext() && preloaded < amount && !Thread.currentThread().isInterrupted()) {
            Map.Entry<String, File> entry = i.next();
            String className = entry.getKey();
            if (!this.preloaded.contains(className)) {
                try {
                    this.loadClass(className);
                    ++preloaded;
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            this.preloaded.add(className);
        }
        return preloaded;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> result = null;
        result = this.loadedClasses.get(name);
        if (result != null) {
            return result;
        }
        File f = this.classLocations.get(name);
        if (f != null && (result = this.findClassInjar(name, f)) != null) {
            return result;
        }
        return super.findClass(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> findClassInjar(String name, File file) throws ClassNotFoundException {
        Class<?> result = null;
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry(name.replace(".", "/") + ".class");
            if (entry != null) {
                InputStream is = jar.getInputStream(entry);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                int next = is.read();
                while (-1 != next) {
                    byteStream.write(next);
                    next = is.read();
                }
                byte[] classByte = byteStream.toByteArray();
                result = this.defineClass(name, classByte, 0, classByte.length, new CodeSource(file.toURI().toURL(), (CodeSigner[])null));
                this.loadedClasses.put(name, result);
                Class<?> clazz = result;
                return clazz;
            }
        }
        catch (FileNotFoundException e) {
            if (!Thread.currentThread().isInterrupted()) {
                e.printStackTrace();
            }
        }
        catch (ZipException zipEx) {
            System.out.println("Failed to open " + name + " from " + file.getPath());
            zipEx.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException ignore) {}
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String resource) {
        URL result = this.getResource(resource);
        if (result != null) {
            try {
                return result.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getResourceAsStream(resource);
    }

    @Override
    public URL getResource(String resource) {
        try {
            Enumeration<URL> results = this.getResources(resource);
            if (results.hasMoreElements()) {
                return results.nextElement();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return super.getResource(resource);
    }

    @Override
    public Enumeration<URL> getResources(String resource) throws IOException {
        if (resource != null) {
            if (this.resources.containsKey(resource)) {
                return new IteratorEnumerator(this.resources.get(resource).iterator());
            }
            Enumeration<URL> result = null;
            String canonAssetsPath = new File(this.assetsDirectory).getCanonicalPath();
            if (resource.startsWith("res/")) {
                result = this.getEnumeration(canonAssetsPath + resource.substring(3), resource);
            } else if (resource.startsWith("/res/")) {
                result = this.getEnumeration(canonAssetsPath + resource.substring(4), resource);
            }
            if (result != null) {
                return result;
            }
        }
        return super.getResources(resource);
    }

    private Enumeration<URL> getEnumeration(String resource, String key) throws MalformedURLException {
        ArrayList<URL> list = new ArrayList<URL>(1);
        File file = new File(resource);
        if (file.exists()) {
            try {
                list.add(file.getCanonicalFile().toURI().toURL());
            }
            catch (IOException e) {
                list.add(file.toURI().toURL());
            }
            this.resources.put(key, list);
            return new IteratorEnumerator(list.iterator());
        }
        return null;
    }

    private class IteratorEnumerator
    implements Enumeration<URL> {
        final Iterator<URL> iterator;

        protected IteratorEnumerator(Iterator<URL> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public URL nextElement() {
            return this.iterator.next();
        }
    }
}

