/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.legacywrapper;

import java.applet.Applet;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.minecraft.Launcher;
import net.technicpack.legacywrapper.MinecraftLauncher;
import net.technicpack.legacywrapper.StartupParameters;
import net.technicpack.legacywrapper.exception.CorruptedMinecraftJarException;
import net.technicpack.legacywrapper.exception.MinecraftVerifyException;

public class Frame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private Launcher minecraft;
    public static final int RETRYING_LAUNCH = -1;
    public static final int ERROR_IN_LAUNCH = 0;
    public static final int SUCCESSFUL_LAUNCH = 1;
    private int width;
    private int height;
    private boolean shouldRun = true;
    private StartupParameters startupParams;

    public Frame(StartupParameters params) {
        super(params.getTitle());
        this.startupParams = params;
        this.setDefaultCloseOperation(3);
        this.width = params.getWidth();
        this.height = params.getHeight();
        if (this.width != -1 && this.height != -1) {
            this.setResizable(false);
        } else {
            this.setResizable(true);
            this.width = 900;
            this.height = 540;
        }
        this.setSize(this.width, this.height);
        if (params.getIconPath() != null) {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(params.getIconPath()));
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        this.setLocation((screenWidth >> 1) - (this.width >> 1), (screenHeight >> 1) - (this.height >> 1));
        this.addWindowListener(this);
    }

    public void setShouldRun(boolean shouldRun) {
        this.shouldRun = shouldRun;
    }

    public void runGame(String user, String session) {
        this.shouldRun = true;
        Applet applet = null;
        try {
            applet = MinecraftLauncher.getMinecraftApplet(this.startupParams);
        }
        catch (CorruptedMinecraftJarException corruption) {
            corruption.printStackTrace();
        }
        catch (MinecraftVerifyException verify) {
            verify.printStackTrace();
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (applet == null) {
            String message = "Failed to launch mod pack!";
            this.setVisible(false);
            JOptionPane.showMessageDialog(this.getParent(), message);
            this.dispose();
            return;
        }
        this.minecraft = new Launcher(applet);
        this.minecraft.addParameter("username", user);
        this.minecraft.addParameter("sessionid", session);
        applet.setStub(this.minecraft);
        this.add(this.minecraft);
        this.validate();
        this.setVisible(true);
        this.minecraft.init();
        this.minecraft.setSize(this.getWidth(), this.getHeight());
        this.minecraft.start();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.minecraft != null) {
            this.minecraft.stop();
            this.minecraft.destroy();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.println("Exiting mod pack");
        this.dispose();
        System.exit(0);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

