/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class Launcher
extends Applet
implements AppletStub {
    private static final long serialVersionUID = -4815977474500388254L;
    private Applet minecraftApplet;
    private URL minecraftDocumentBase;
    private Map<String, String> customParameters = new HashMap<String, String>();
    private boolean active = false;

    public Launcher() throws HeadlessException {
        this.setLayout(new GridBagLayout());
    }

    public Launcher(Applet minecraftApplet) throws HeadlessException {
        this();
        this.minecraftApplet = minecraftApplet;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)minecraftApplet, gridBagConstraints);
    }

    public Applet getMinecraftApplet() {
        return this.minecraftApplet;
    }

    public void setMinecraftApplet(Applet minecraftApplet) {
        if (this.minecraftApplet != null) {
            this.remove(minecraftApplet);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)minecraftApplet, gridBagConstraints);
        this.minecraftApplet = minecraftApplet;
    }

    public void addParameter(String name, String value) {
        this.customParameters.put(name, value);
    }

    @Override
    public String getParameter(String name) {
        String custom = this.customParameters.get(name);
        if (custom != null) {
            return custom;
        }
        try {
            return super.getParameter(name);
        }
        catch (Exception e) {
            this.customParameters.put(name, null);
            return null;
        }
    }

    public void replace(Applet applet) {
        this.minecraftApplet = applet;
        applet.setStub(this);
        applet.setSize(this.getWidth(), this.getHeight());
        this.setLayout(new BorderLayout());
        this.add((Component)applet, "Center");
        applet.init();
        this.active = true;
        applet.start();
        this.validate();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void appletResize(int width, int height) {
        this.minecraftApplet.resize(width, height);
    }

    @Override
    public void init() {
        if (this.minecraftApplet != null) {
            this.minecraftApplet.init();
        }
    }

    @Override
    public void start() {
        if (this.minecraftApplet != null) {
            this.minecraftApplet.start();
            this.active = true;
        }
    }

    @Override
    public void stop() {
        if (this.minecraftApplet != null) {
            this.minecraftApplet.stop();
            this.active = false;
        }
    }

    @Override
    public URL getCodeBase() {
        return this.minecraftApplet.getCodeBase();
    }

    @Override
    public URL getDocumentBase() {
        if (this.minecraftDocumentBase == null) {
            try {
                this.minecraftDocumentBase = new URL("http://www.minecraft.net/game");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.minecraftDocumentBase;
    }

    @Override
    public void resize(int width, int height) {
        this.minecraftApplet.resize(width, height);
    }

    @Override
    public void resize(Dimension d) {
        this.minecraftApplet.resize(d);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.minecraftApplet.setVisible(b);
    }
}

