/*
 * Decompiled with CFR 0.152.
 */
package forge.packets;

import forge.packets.ForgePacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

public class PacketModList
extends ForgePacket {
    private boolean isServer = false;
    public String[] Mods;
    public Hashtable<Integer, String> ModIDs = new Hashtable();
    public int Length = -1;
    public boolean has4096 = false;

    public PacketModList(boolean server) {
        this.isServer = server;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        if (!this.isServer) {
            data.writeInt(this.Mods.length);
            for (String mod : this.Mods) {
                data.writeUTF(mod);
            }
        } else {
            data.writeInt(this.ModIDs.size());
            for (Map.Entry<Integer, String> entry : this.ModIDs.entrySet()) {
                data.writeInt(entry.getKey());
                data.writeUTF(entry.getValue());
            }
        }
        data.writeBoolean(true);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        if (this.isServer) {
            this.Length = data.readInt();
            if (this.Length >= 0) {
                this.Mods = new String[this.Length];
                for (int x = 0; x < this.Length; ++x) {
                    this.Mods[x] = data.readUTF();
                }
            }
        } else {
            this.Length = data.readInt();
            for (int x = 0; x < this.Length; ++x) {
                this.ModIDs.put(data.readInt(), data.readUTF());
            }
        }
        try {
            this.has4096 = data.readBoolean();
        }
        catch (EOFException e) {
            this.has4096 = false;
        }
    }

    @Override
    public int getID() {
        return 2;
    }

    @Override
    public String toString(boolean full) {
        if (full) {
            StringBuilder ret = new StringBuilder();
            ret.append(this.toString()).append('\n');
            if (this.Mods != null) {
                for (String mod : this.Mods) {
                    ret.append("    " + mod + '\n');
                }
            } else if (this.ModIDs.size() != 0) {
                for (Map.Entry<Integer, String> mod : this.ModIDs.entrySet()) {
                    ret.append(String.format("    %03d ", mod.getKey()) + mod.getValue() + '\n');
                }
            }
            return ret.toString();
        }
        return this.toString();
    }
}

