/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.ForgeHooks;
import forge.ForgeHooksClient;
import forge.IHighlightHandler;
import forge.IItemRenderer;
import forge.IRenderContextHandler;
import forge.IRenderWorldLastHandler;
import forge.ISoundHandler;
import forge.ITextureLoadHandler;
import forge.MinecraftForge;
import forge.PacketHandlerClient;
import org.lwjgl.opengl.Display;

public class MinecraftForgeClient {
    private static IItemRenderer[] customItemRenderers = new IItemRenderer[yr.e.length];
    private static boolean hasInit = false;

    public static void registerHighlightHandler(IHighlightHandler handler) {
        ForgeHooksClient.highlightHandlers.add(handler);
    }

    public static void registerRenderContextHandler(String texture, int subid, IRenderContextHandler handler) {
        ForgeHooksClient.registerRenderContextHandler(texture, subid, handler);
    }

    public static void registerTextureLoadHandler(ITextureLoadHandler handler) {
        ForgeHooksClient.textureLoadHandlers.add(handler);
    }

    public static void registerRenderLastHandler(IRenderWorldLastHandler handler) {
        ForgeHooksClient.renderWorldLastHandlers.add(handler);
    }

    public static void registerSoundHandler(ISoundHandler handler) {
        block3: {
            ForgeHooksClient.soundHandlers.add(handler);
            MinecraftForgeClient.checkMinecraftVersion("Minecraft Minecraft 1.2.5", "Interface check in registerSoundHandler, remove it Mods should be updated");
            try {
                if (handler.getClass().getDeclaredMethod("onPlaySoundAtEntity", nn.class, String.class, Float.TYPE, Float.TYPE) != null) {
                    ForgeHooksClient.soundHandlers2.add(handler);
                }
            }
            catch (Exception e) {
                if (!xd.class.getName().contains("World")) break block3;
                e.printStackTrace();
            }
        }
    }

    public static void bindTexture(String texture, int subid) {
        ForgeHooksClient.bindTexture(texture, subid);
    }

    public static void bindTexture(String texture) {
        ForgeHooksClient.bindTexture(texture, 0);
    }

    public static void unbindTexture() {
        ForgeHooksClient.unbindTexture();
    }

    public static void preloadTexture(String texture) {
        ModLoader.getMinecraftInstance().p.b(texture);
    }

    public static void renderBlock(vl render, pb block, int X, int Y, int Z) {
        ForgeHooksClient.beforeBlockRender(block, render);
        render.b(block, X, Y, Z);
        ForgeHooksClient.afterBlockRender(block, render);
    }

    public static int getRenderPass() {
        return ForgeHooksClient.renderPass;
    }

    public static void registerItemRenderer(int itemID, IItemRenderer renderer) {
        MinecraftForgeClient.customItemRenderers[itemID] = renderer;
    }

    public static IItemRenderer getItemRenderer(aan item, IItemRenderer.ItemRenderType type) {
        IItemRenderer renderer = customItemRenderers[item.c];
        if (renderer != null && renderer.handleRenderType(item, type)) {
            return customItemRenderers[item.c];
        }
        return null;
    }

    public static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        ForgeHooks.setPacketHandler(new PacketHandlerClient());
    }

    public static void checkMinecraftVersion(String version, String message) {
        if (!Display.getTitle().equals(version)) {
            MinecraftForge.killMinecraft("Minecraft Forge", message.replaceAll("%version%", Display.getTitle()));
        }
    }

    static {
        MinecraftForgeClient.init();
    }
}

