/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.ForgeHooks;
import forge.IHighlightHandler;
import forge.IItemRenderer;
import forge.IMultipassRender;
import forge.IRenderContextHandler;
import forge.IRenderWorldLastHandler;
import forge.ISoundHandler;
import forge.ITextureLoadHandler;
import forge.ITextureProvider;
import forge.MessageManager;
import forge.MinecraftForgeClient;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class ForgeHooksClient {
    private static Field textureID = null;
    private static boolean textureIDChecked = false;
    public static boolean enable4096 = false;
    public static LinkedList<IHighlightHandler> highlightHandlers = new LinkedList();
    public static LinkedList<IRenderWorldLastHandler> renderWorldLastHandlers = new LinkedList();
    public static LinkedList<ITextureLoadHandler> textureLoadHandlers = new LinkedList();
    public static HashMap<TesKey, adz> tessellators = new HashMap();
    public static HashMap<String, Integer> textures = new HashMap();
    public static boolean inWorld = false;
    public static TreeSet<TesKey> renderTextures = new TreeSet();
    public static adz defaultTessellator = null;
    public static HashMap<TesKey, IRenderContextHandler> renderHandlers = new HashMap();
    public static IRenderContextHandler unbindContext = null;
    static int renderPass = -1;
    public static LinkedList<ISoundHandler> soundHandlers = new LinkedList();
    public static LinkedList<ISoundHandler> soundHandlers2 = new LinkedList();

    public static boolean onBlockHighlight(l render, yw player, pl target, int i2, aan itemstack, float partialTicks) {
        for (IHighlightHandler handler : highlightHandlers) {
            if (!handler.onBlockHighlight(render, player, target, i2, itemstack, partialTicks)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderWorldLast(l render, float partialTicks) {
        for (IRenderWorldLastHandler handler : renderWorldLastHandlers) {
            handler.onRenderWorldLast(render, partialTicks);
        }
    }

    public static void onTextureLoad(String textureName, int textureID) {
        for (ITextureLoadHandler handler : textureLoadHandlers) {
            handler.onTextureLoad(textureName, textureID);
        }
    }

    public static boolean canRenderInPass(pb block, int pass) {
        if (block instanceof IMultipassRender) {
            return ((IMultipassRender)((Object)block)).canRenderInPass(pass);
        }
        return pass == block.c();
    }

    protected static void registerRenderContextHandler(String texture, int subID, IRenderContextHandler handler) {
        Integer texID = textures.get(texture);
        if (texID == null) {
            texID = ModLoader.getMinecraftInstance().p.b(texture);
            textures.put(texture, texID);
        }
        renderHandlers.put(new TesKey(texID, subID), handler);
    }

    protected static void bindTessellator(int texture, int subID) {
        TesKey key = new TesKey(texture, subID);
        adz tess = tessellators.get(key);
        if (tess == null) {
            tess = new adz();
            if (!textureIDChecked && textureID == null) {
                textureIDChecked = true;
                try {
                    textureID = adz.class.getField("textureID");
                }
                catch (NoSuchFieldException ex) {
                    // empty catch block
                }
            }
            if (textureID != null) {
                tess.textureID = texture;
            }
            tessellators.put(key, tess);
        }
        if (inWorld && !renderTextures.contains(key)) {
            renderTextures.add(key);
            tess.b();
            tess.b(ForgeHooksClient.defaultTessellator.v, ForgeHooksClient.defaultTessellator.w, ForgeHooksClient.defaultTessellator.x);
        }
        adz.a = tess;
    }

    protected static void bindTexture(String texture, int subID) {
        Integer texID = textures.get(texture);
        if (texID == null) {
            texID = ModLoader.getMinecraftInstance().p.b(texture);
            textures.put(texture, texID);
        }
        if (!inWorld) {
            if (unbindContext != null) {
                unbindContext.afterRenderContext();
                unbindContext = null;
            }
            if (adz.a.z) {
                int mode = adz.a.u;
                adz.a.a();
                adz.a.a(mode);
            }
            GL11.glBindTexture((int)3553, (int)texID);
            unbindContext = renderHandlers.get(new TesKey(texID, subID));
            if (unbindContext != null) {
                unbindContext.beforeRenderContext();
            }
            return;
        }
        ForgeHooksClient.bindTessellator(texID, subID);
    }

    protected static void unbindTexture() {
        if (!inWorld) {
            if (adz.a.z) {
                int mode = adz.a.u;
                adz.a.a();
                if (unbindContext != null) {
                    unbindContext.afterRenderContext();
                    unbindContext = null;
                }
                adz.a.a(mode);
            }
            GL11.glBindTexture((int)3553, (int)ModLoader.getMinecraftInstance().p.b("/terrain.png"));
            return;
        }
        adz.a = defaultTessellator;
    }

    public static void beforeRenderPass(int pass) {
        renderPass = pass;
        defaultTessellator = adz.a;
        adz.renderingWorldRenderer = true;
        GL11.glBindTexture((int)3553, (int)ModLoader.getMinecraftInstance().p.b("/terrain.png"));
        renderTextures.clear();
        inWorld = true;
    }

    public static void afterRenderPass(int pass) {
        renderPass = -1;
        inWorld = false;
        for (TesKey info : renderTextures) {
            IRenderContextHandler handler = renderHandlers.get(info);
            GL11.glBindTexture((int)3553, (int)info.tex);
            adz tess = tessellators.get(info);
            if (handler == null) {
                tess.a();
                continue;
            }
            adz.a = tess;
            handler.beforeRenderContext();
            tess.a();
            handler.afterRenderContext();
        }
        GL11.glBindTexture((int)3553, (int)ModLoader.getMinecraftInstance().p.b("/terrain.png"));
        adz.renderingWorldRenderer = false;
        adz.a = defaultTessellator;
    }

    public static void beforeBlockRender(pb block, vl render) {
        if (!block.isDefaultTexture && render.d == -1) {
            ForgeHooksClient.bindTexture(block.getTextureFile(), 0);
        }
    }

    public static void afterBlockRender(pb block, vl render) {
        if (!block.isDefaultTexture && render.d == -1) {
            ForgeHooksClient.unbindTexture();
        }
    }

    public static void overrideTexture(Object obj) {
        if (obj instanceof ITextureProvider) {
            GL11.glBindTexture((int)3553, (int)ModLoader.getMinecraftInstance().p.b(((ITextureProvider)obj).getTextureFile()));
        }
    }

    public static String getTexture(String def, Object obj) {
        if (obj instanceof ITextureProvider) {
            return ((ITextureProvider)obj).getTextureFile();
        }
        return def;
    }

    public static void renderEquippedItem(IItemRenderer customRenderer, vl renderBlocks, acq entity, aan item) {
        if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.EQUIPPED, item, IItemRenderer.ItemRendererHelper.EQUIPPED_BLOCK)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            customRenderer.renderItem(IItemRenderer.ItemRenderType.EQUIPPED, item, renderBlocks, entity);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            GL11.glEnable((int)32826);
            GL11.glTranslatef((float)0.0f, (float)-0.3f, (float)0.0f);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.9375f, (float)-0.0625f, (float)0.0f);
            customRenderer.renderItem(IItemRenderer.ItemRenderType.EQUIPPED, item, renderBlocks, entity);
            GL11.glDisable((int)32826);
            GL11.glPopMatrix();
        }
    }

    public static boolean renderEntityItem(fq entity, aan item, float bobing, float rotation, Random random, aaw engine, vl renderBlocks) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer(item, IItemRenderer.ItemRenderType.ENTITY);
        if (customRenderer == null) {
            return false;
        }
        if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.ENTITY_ROTATION)) {
            GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (!customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.ENTITY_BOBBING)) {
            GL11.glTranslatef((float)0.0f, (float)(-bobing), (float)0.0f);
        }
        boolean is3D = customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.ENTITY, item, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        if (item.a() instanceof vd && (is3D || vl.a(pb.m[item.c].d()))) {
            engine.b(engine.b(item.a().getTextureFile()));
            int renderType = pb.m[item.c].d();
            float scale = renderType == 1 || renderType == 19 || renderType == 12 || renderType == 2 ? 0.5f : 0.25f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            int size = entity.a.a;
            int count = size > 20 ? 4 : (size > 5 ? 3 : (size > 1 ? 2 : 1));
            for (int j2 = 0; j2 < size; ++j2) {
                GL11.glPushMatrix();
                if (j2 > 0) {
                    GL11.glTranslatef((float)((random.nextFloat() * 2.0f - 1.0f) * 0.2f / 0.5f), (float)((random.nextFloat() * 2.0f - 1.0f) * 0.2f / 0.5f), (float)((random.nextFloat() * 2.0f - 1.0f) * 0.2f / 0.5f));
                }
                customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, item, renderBlocks, entity);
                GL11.glPopMatrix();
            }
        } else {
            engine.b(engine.b(item.a().getTextureFile()));
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            customRenderer.renderItem(IItemRenderer.ItemRenderType.ENTITY, item, renderBlocks, entity);
        }
        return true;
    }

    public static boolean renderInventoryItem(vl renderBlocks, aaw engine, aan item, boolean inColor, float zLevel, float x, float y) {
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer(item, IItemRenderer.ItemRenderType.INVENTORY);
        if (customRenderer == null) {
            return false;
        }
        engine.b(engine.b(yr.e[item.c].getTextureFile()));
        if (customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.INVENTORY, item, IItemRenderer.ItemRendererHelper.INVENTORY_BLOCK)) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(x - 2.0f), (float)(y + 3.0f), (float)(-3.0f + zLevel));
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            GL11.glTranslatef((float)1.0f, (float)0.5f, (float)1.0f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
            GL11.glRotatef((float)210.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (inColor) {
                int color = yr.e[item.c].b(item.i(), 0);
                float r2 = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)r2, (float)g, (float)b, (float)1.0f);
            }
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            renderBlocks.c = inColor;
            customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, item, renderBlocks);
            renderBlocks.c = true;
            GL11.glPopMatrix();
        } else {
            GL11.glDisable((int)2896);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)(-3.0f + zLevel));
            if (inColor) {
                int color = yr.e[item.c].b(item.i(), 0);
                float r3 = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)r3, (float)g, (float)b, (float)1.0f);
            }
            customRenderer.renderItem(IItemRenderer.ItemRenderType.INVENTORY, item, renderBlocks);
            GL11.glPopMatrix();
            GL11.glEnable((int)2896);
        }
        return true;
    }

    private static Class getClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            try {
                return Class.forName("net.minecraft.src." + name);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static void onSetupAudio(sd soundManager) {
        for (ISoundHandler handler : soundHandlers) {
            handler.onSetupAudio(soundManager);
        }
    }

    public static void onLoadSoundSettings(sd soundManager) {
        for (ISoundHandler handler : soundHandlers) {
            handler.onLoadSoundSettings(soundManager);
        }
    }

    public static ub onPlayBackgroundMusic(sd soundManager, ub entry) {
        for (ISoundHandler handler : soundHandlers) {
            entry = handler.onPlayBackgroundMusic(soundManager, entry);
            if (entry != null) continue;
            return null;
        }
        return entry;
    }

    public static ub onPlayStreaming(sd soundManager, ub entry, String soundName, float x, float y, float z2) {
        for (ISoundHandler handler : soundHandlers) {
            entry = handler.onPlayStreaming(soundManager, entry, soundName, x, y, z2);
            if (entry != null) continue;
            return null;
        }
        return entry;
    }

    public static ub onPlaySound(sd soundManager, ub entry, String soundName, float x, float y, float z2, float volume, float pitch) {
        for (ISoundHandler handler : soundHandlers) {
            entry = handler.onPlaySound(soundManager, entry, soundName, x, y, z2, volume, pitch);
            if (entry != null) continue;
            return null;
        }
        return entry;
    }

    public static ub onPlaySoundEffect(sd soundManager, ub entry, String soundName, float volume, float pitch) {
        for (ISoundHandler handler : soundHandlers) {
            entry = handler.onPlaySoundEffect(soundManager, entry, soundName, volume, pitch);
            if (entry != null) continue;
            return null;
        }
        return entry;
    }

    public static String onPlaySoundAtEntity(nn entity, String soundName, float volume, float pitch) {
        MinecraftForgeClient.checkMinecraftVersion("Minecraft Minecraft 1.2.5", "Interface check in onPlaySoundAtEntity, remove it Mods should be updated");
        for (ISoundHandler handler : soundHandlers2) {
            soundName = handler.onPlaySoundAtEntity(entity, soundName, volume, pitch);
            if (soundName != null) continue;
            return null;
        }
        return soundName;
    }

    public static void onLogin(aec login, adl net, lg netManager) {
        ForgeHooks.onLogin(netManager, login);
        String[] channels = MessageManager.getInstance().getRegisteredChannels(netManager);
        StringBuilder tmp = new StringBuilder();
        tmp.append("Forge");
        for (String channel : channels) {
            tmp.append("\u0000");
            tmp.append(channel);
        }
        ee pkt = new ee();
        pkt.a = "REGISTER";
        try {
            pkt.c = tmp.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        pkt.b = pkt.c.length;
        net.c((abs)pkt);
    }

    public static abs onSendLogin(aec pkt) {
        enable4096 = false;
        pkt.d = 68066119;
        pkt.e = 164;
        return pkt;
    }

    public static void onCustomPayload(ee pkt, lg net) {
        MessageManager inst = MessageManager.getInstance();
        if (pkt.a.equals("REGISTER")) {
            try {
                String channels = new String(pkt.c, "UTF8");
                for (String channel : channels.split("\u0000")) {
                    inst.addActiveChannel(net, channel);
                }
            }
            catch (UnsupportedEncodingException ex) {
                ModLoader.throwException("ForgeHooksClient.onCustomPayload", ex);
            }
        } else if (pkt.a.equals("UNREGISTER")) {
            try {
                String channels = new String(pkt.c, "UTF8");
                for (String channel : channels.split("\u0000")) {
                    inst.removeActiveChannel(net, channel);
                }
            }
            catch (UnsupportedEncodingException ex) {
                ModLoader.throwException("ForgeHooksClient.onCustomPayload", ex);
            }
        } else {
            inst.dispatchIncomingMessage(net, pkt.a, pkt.c);
        }
    }

    public static void onTextureLoadPre(String texture) {
        if (adz.renderingWorldRenderer) {
            String msg = String.format("Warning: Texture %s not preloaded, will cause render glitches!", texture);
            System.out.println(msg);
            if (adz.class.getPackage() != null && adz.class.getPackage().equals("net.minecraft.src")) {
                Minecraft mc2 = ModLoader.getMinecraftInstance();
                if (mc2.w != null) {
                    mc2.w.a(msg);
                }
            }
        }
    }

    private static class TesKey
    implements Comparable<TesKey> {
        public int tex;
        public int sub;

        public TesKey(int textureID, int subID) {
            this.tex = textureID;
            this.sub = subID;
        }

        @Override
        public int compareTo(TesKey key) {
            if (this.sub == key.sub) {
                return this.tex - key.tex;
            }
            return this.sub - key.sub;
        }

        public boolean equals(Object obj) {
            return this.compareTo((TesKey)obj) == 0;
        }

        public int hashCode() {
            int c1 = Integer.valueOf(this.tex).hashCode();
            int c2 = Integer.valueOf(this.sub).hashCode();
            return c1 + 31 * c2;
        }
    }
}

