/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.EntityTrackerInfo;
import forge.IArrowLooseHandler;
import forge.IArrowNockHandler;
import forge.IBonemealHandler;
import forge.IChatHandler;
import forge.IChunkLoadHandler;
import forge.IConnectionHandler;
import forge.ICraftingHandler;
import forge.IDestroyToolHandler;
import forge.IEntityInteractHandler;
import forge.IEntityLivingHandler;
import forge.IFuelHandler;
import forge.IGuiHandler;
import forge.IHoeHandler;
import forge.IMinecartHandler;
import forge.IPickupHandler;
import forge.ISaveEventHandler;
import forge.ISleepHandler;
import forge.ISpecialMobSpawnHandler;
import forge.MinecraftForge;
import forge.NetworkMod;
import forge.packets.PacketEntitySpawn;
import forge.packets.PacketHandlerBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class ForgeHooks {
    static LinkedList<ICraftingHandler> craftingHandlers = new LinkedList();
    static LinkedList<IDestroyToolHandler> destroyToolHandlers = new LinkedList();
    static LinkedList<IBonemealHandler> bonemealHandlers = new LinkedList();
    static LinkedList<IHoeHandler> hoeHandlers = new LinkedList();
    static LinkedList<ISleepHandler> sleepHandlers = new LinkedList();
    static LinkedList<IMinecartHandler> minecartHandlers = new LinkedList();
    static LinkedList<IConnectionHandler> connectionHandlers = new LinkedList();
    static LinkedList<IPickupHandler> pickupHandlers = new LinkedList();
    static LinkedList<IChunkLoadHandler> chunkLoadHandlers = new LinkedList();
    static LinkedList<IEntityInteractHandler> entityInteractHandlers = new LinkedList();
    static LinkedList<IChatHandler> chatHandlers = new LinkedList();
    static LinkedList<ISaveEventHandler> saveHandlers = new LinkedList();
    static LinkedList<IFuelHandler> fuelHandlers = new LinkedList();
    static LinkedList<ISpecialMobSpawnHandler> specialMobSpawnHandlers = new LinkedList();
    static LinkedList<IEntityLivingHandler> entityLivingHandlers = new LinkedList();
    static List<ProbableItem> plantGrassList;
    static int plantGrassWeight;
    static List<ProbableItem> seedGrassList;
    static int seedGrassWeight;
    public static HashMap<Class, EntityTrackerInfo> entityTrackerMap;
    public static Hashtable<Integer, NetworkMod> networkMods;
    public static Hashtable<BaseMod, IGuiHandler> guiHandlers;
    public static ArrayList<IArrowLooseHandler> arrowLooseHandlers;
    public static ArrayList<IArrowNockHandler> arrowNockHandlers;
    public static final int majorVersion = 3;
    public static final int minorVersion = 3;
    public static final int revisionVersion = 8;
    public static final int buildVersion = 164;
    static boolean toolInit;
    static HashMap toolClasses;
    static HashMap toolHarvestLevels;
    static HashSet toolEffectiveness;
    private static PacketHandlerBase forgePacketHandler;

    public static void onTakenFromCrafting(yw player, aan stack, io craftMatrix) {
        for (ICraftingHandler handler : craftingHandlers) {
            handler.onTakenFromCrafting(player, stack, craftMatrix);
        }
    }

    public static void onDestroyCurrentItem(yw player, aan orig) {
        for (IDestroyToolHandler handler : destroyToolHandlers) {
            handler.onDestroyCurrentItem(player, orig);
        }
    }

    public static boolean onUseBonemeal(xd world, int blockID, int x, int y, int z2) {
        for (IBonemealHandler handler : bonemealHandlers) {
            if (!handler.onUseBonemeal(world, blockID, x, y, z2)) continue;
            return true;
        }
        return false;
    }

    public static boolean onUseHoe(aan hoe, yw player, xd world, int x, int y, int z2) {
        for (IHoeHandler handler : hoeHandlers) {
            if (!handler.onUseHoe(hoe, player, world, x, y, z2)) continue;
            return true;
        }
        return false;
    }

    public static ci sleepInBedAt(yw player, int x, int y, int z2) {
        for (ISleepHandler handler : sleepHandlers) {
            ci status = handler.sleepInBedAt(player, x, y, z2);
            if (status == null) continue;
            return status;
        }
        return null;
    }

    public static void onMinecartUpdate(ama minecart, int x, int y, int z2) {
        for (IMinecartHandler handler : minecartHandlers) {
            handler.onMinecartUpdate(minecart, x, y, z2);
        }
    }

    public static void onMinecartEntityCollision(ama minecart, nn entity) {
        for (IMinecartHandler handler : minecartHandlers) {
            handler.onMinecartEntityCollision(minecart, entity);
        }
    }

    public static boolean onMinecartInteract(ama minecart, yw player) {
        boolean canceled = true;
        for (IMinecartHandler handler : minecartHandlers) {
            boolean tmp = handler.onMinecartInteract(minecart, player, canceled);
            canceled = canceled && tmp;
        }
        return canceled;
    }

    public static void onConnect(lg network) {
        for (IConnectionHandler handler : connectionHandlers) {
            handler.onConnect(network);
        }
    }

    public static void onLogin(lg network, aec login) {
        for (IConnectionHandler handler : connectionHandlers) {
            handler.onLogin(network, login);
        }
    }

    public static void onDisconnect(lg network, String message, Object[] args) {
        for (IConnectionHandler handler : connectionHandlers) {
            handler.onDisconnect(network, message, args);
        }
    }

    public static boolean onItemPickup(yw player, fq item) {
        boolean cont = true;
        for (IPickupHandler handler : pickupHandlers) {
            boolean bl = cont = cont && handler.onItemPickup(player, item);
            if (cont && item.a.a > 0) continue;
            return false;
        }
        return cont;
    }

    public static void addActiveChunks(xd world, Set<sj> chunkList) {
        for (IChunkLoadHandler loader : chunkLoadHandlers) {
            loader.addActiveChunks(world, chunkList);
        }
    }

    public static boolean canUnloadChunk(ack chunk) {
        for (IChunkLoadHandler loader : chunkLoadHandlers) {
            if (loader.canUnloadChunk(chunk)) continue;
            return false;
        }
        return true;
    }

    public static boolean canUpdateEntity(nn entity) {
        for (IChunkLoadHandler loader : chunkLoadHandlers) {
            if (!loader.canUpdateEntity(entity)) continue;
            return true;
        }
        return false;
    }

    public static boolean onEntityInteract(yw player, nn entity, boolean isAttack) {
        for (IEntityInteractHandler handler : entityInteractHandlers) {
            if (handler.onEntityInteract(player, entity, isAttack)) continue;
            return false;
        }
        return true;
    }

    public static String onServerChat(yw player, String message) {
        for (IChatHandler handler : chatHandlers) {
            message = handler.onServerChat(player, message);
            if (message != null) continue;
            return null;
        }
        return message;
    }

    public static boolean onChatCommand(yw player, boolean isOp, String command) {
        for (IChatHandler handler : chatHandlers) {
            if (!handler.onChatCommand(player, isOp, command)) continue;
            return true;
        }
        return false;
    }

    public static boolean onServerCommand(Object listener, String username, String command) {
        for (IChatHandler handler : chatHandlers) {
            if (!handler.onServerCommand(listener, username, command)) continue;
            return true;
        }
        return false;
    }

    public static String onServerCommandSay(Object listener, String username, String message) {
        for (IChatHandler handler : chatHandlers) {
            message = handler.onServerCommandSay(listener, username, message);
            if (message != null) continue;
            return null;
        }
        return message;
    }

    public static String onClientChatRecv(String message) {
        for (IChatHandler handler : chatHandlers) {
            message = handler.onClientChatRecv(message);
            if (message != null) continue;
            return null;
        }
        return message;
    }

    public static void onWorldLoad(xd world) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onWorldLoad(world);
        }
    }

    public static void onWorldSave(xd world) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onWorldSave(world);
        }
    }

    public static void onChunkLoad(xd world, ack chunk) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onChunkLoad(world, chunk);
        }
    }

    public static void onChunkUnload(xd world, ack chunk) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onChunkUnload(world, chunk);
        }
    }

    public static void onChunkLoadData(xd world, ack chunk, ady data) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onChunkLoadData(world, chunk, data);
        }
    }

    public static void onChunkSaveData(xd world, ack chunk, ady data) {
        for (ISaveEventHandler handler : saveHandlers) {
            handler.onChunkSaveData(world, chunk, data);
        }
    }

    public static int getItemBurnTime(aan stack) {
        for (IFuelHandler handler : fuelHandlers) {
            int ret = handler.getItemBurnTime(stack);
            if (ret <= 0) continue;
            return ret;
        }
        return 0;
    }

    public static boolean onEntitySpawnSpecial(acq entity, xd world, float x, float y, float z2) {
        for (ISpecialMobSpawnHandler handler : specialMobSpawnHandlers) {
            if (!handler.onSpecialEntitySpawn(entity, world, x, y, z2)) continue;
            return true;
        }
        return false;
    }

    public static boolean onEntityLivingSpawn(acq entity, xd world, float x, float y, float z2) {
        for (IEntityLivingHandler handler : entityLivingHandlers) {
            if (!handler.onEntityLivingSpawn(entity, world, x, y, z2)) continue;
            return true;
        }
        return false;
    }

    public static boolean onEntityLivingDeath(acq entity, md killer) {
        for (IEntityLivingHandler handler : entityLivingHandlers) {
            if (!handler.onEntityLivingDeath(entity, killer)) continue;
            return true;
        }
        return false;
    }

    public static boolean onEntityLivingUpdate(acq entity) {
        for (IEntityLivingHandler handler : entityLivingHandlers) {
            if (!handler.onEntityLivingUpdate(entity)) continue;
            return true;
        }
        return false;
    }

    public static void onEntityLivingJump(acq entity) {
        for (IEntityLivingHandler handler : entityLivingHandlers) {
            handler.onEntityLivingJump(entity);
        }
    }

    public static boolean onEntityLivingFall(acq entity, float distance) {
        for (IEntityLivingHandler handler : entityLivingHandlers) {
            if (!handler.onEntityLivingFall(entity, distance)) continue;
            return true;
        }
        return false;
    }

    public static boolean onEntityLivingAttacked(acq entity, md attack, int damage) {
        for (IEntityLivingHandler handler : entityLivingHandlers) {
            if (!handler.onEntityLivingAttacked(entity, attack, damage)) continue;
            return true;
        }
        return false;
    }

    public static void onEntityLivingSetAttackTarget(acq entity, acq target) {
        for (IEntityLivingHandler handler : entityLivingHandlers) {
            handler.onEntityLivingSetAttackTarget(entity, target);
        }
    }

    public static int onEntityLivingHurt(acq entity, md source, int damage) {
        for (IEntityLivingHandler handler : entityLivingHandlers) {
            damage = handler.onEntityLivingHurt(entity, source, damage);
            if (damage != 0) continue;
            return 0;
        }
        return damage;
    }

    public static void onEntityLivingDrops(acq entity, md source, ArrayList<fq> drops, int lootingLevel, boolean recentlyHit, int specialDropValue) {
        for (IEntityLivingHandler handler : entityLivingHandlers) {
            handler.onEntityLivingDrops(entity, source, drops, lootingLevel, recentlyHit, specialDropValue);
        }
    }

    static ProbableItem getRandomItem(List<ProbableItem> list, int prop) {
        int n2 = Collections.binarySearch(list, prop, new Comparator(){

            public int compare(Object o1, Object o2) {
                ProbableItem pi = (ProbableItem)o1;
                Integer i1 = (Integer)o2;
                if (i1 < pi.WeightStart) {
                    return 1;
                }
                if (i1 >= pi.WeightEnd) {
                    return -1;
                }
                return 0;
            }
        });
        if (n2 < 0) {
            return null;
        }
        return list.get(n2);
    }

    public static void plantGrassPlant(xd world, int x, int y, int z2) {
        int index = world.r.nextInt(plantGrassWeight);
        ProbableItem item = ForgeHooks.getRandomItem(plantGrassList, index);
        if (item == null || pb.m[item.ItemID] == null) {
            return;
        }
        if (mod_MinecraftForge.DISABLE_DARK_ROOMS && !pb.m[item.ItemID].g(world, x, y, z2)) {
            return;
        }
        world.d(x, y, z2, item.ItemID, item.Metadata);
    }

    public static void addPlantGrass(int item, int metadata, int probability) {
        plantGrassList.add(new ProbableItem(item, metadata, 1, plantGrassWeight, plantGrassWeight + probability));
        plantGrassWeight += probability;
    }

    public static aan getGrassSeed(xd world) {
        int index = world.r.nextInt(seedGrassWeight);
        ProbableItem item = ForgeHooks.getRandomItem(seedGrassList, index);
        if (item == null) {
            return null;
        }
        return new aan(item.ItemID, item.Quantity, item.Metadata);
    }

    public static void addGrassSeed(int item, int metadata, int quantity, int probability) {
        seedGrassList.add(new ProbableItem(item, metadata, quantity, seedGrassWeight, seedGrassWeight + probability));
        seedGrassWeight += probability;
    }

    public static boolean canHarvestBlock(pb block, yw player, int metadata) {
        if (block.cd.k()) {
            return true;
        }
        aan stack = player.ap.b();
        if (stack == null) {
            return player.b(block);
        }
        List info = (List)toolClasses.get(stack.c);
        if (info == null) {
            return player.b(block);
        }
        Object[] tmp = info.toArray();
        String toolClass = (String)tmp[0];
        int harvestLevel = (Integer)tmp[1];
        Integer blockHarvestLevel = (Integer)toolHarvestLevels.get(Arrays.asList(block.bO, metadata, toolClass));
        if (blockHarvestLevel == null) {
            return player.b(block);
        }
        return blockHarvestLevel <= harvestLevel;
    }

    public static float blockStrength(pb block, yw player, int metadata) {
        float hardness = block.getHardness(metadata);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(block, player, metadata)) {
            return 1.0f / hardness / 100.0f;
        }
        return player.getCurrentPlayerStrVsBlock(block, metadata) / hardness / 30.0f;
    }

    public static boolean isToolEffective(aan stack, pb block, int metadata) {
        List toolClass = (List)toolClasses.get(stack.c);
        if (toolClass == null) {
            return false;
        }
        return toolEffectiveness.contains(Arrays.asList(block.bO, metadata, (String)toolClass.get(0)));
    }

    static void initTools() {
        pb[] axeEff;
        pb[] spadeEff;
        pb[] pickeff;
        if (toolInit) {
            return;
        }
        toolInit = true;
        MinecraftForge.setToolClass(yr.t, "pickaxe", 0);
        MinecraftForge.setToolClass(yr.x, "pickaxe", 1);
        MinecraftForge.setToolClass(yr.g, "pickaxe", 2);
        MinecraftForge.setToolClass(yr.I, "pickaxe", 0);
        MinecraftForge.setToolClass(yr.B, "pickaxe", 3);
        MinecraftForge.setToolClass(yr.u, "axe", 0);
        MinecraftForge.setToolClass(yr.y, "axe", 1);
        MinecraftForge.setToolClass(yr.h, "axe", 2);
        MinecraftForge.setToolClass(yr.J, "axe", 0);
        MinecraftForge.setToolClass(yr.C, "axe", 3);
        MinecraftForge.setToolClass(yr.s, "shovel", 0);
        MinecraftForge.setToolClass(yr.w, "shovel", 1);
        MinecraftForge.setToolClass(yr.f, "shovel", 2);
        MinecraftForge.setToolClass(yr.H, "shovel", 0);
        MinecraftForge.setToolClass(yr.A, "shovel", 3);
        MinecraftForge.setBlockHarvestLevel(pb.ap, "pickaxe", 3);
        MinecraftForge.setBlockHarvestLevel(pb.aw, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(pb.ax, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(pb.G, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(pb.ah, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(pb.H, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(pb.ai, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(pb.N, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(pb.O, "pickaxe", 1);
        MinecraftForge.setBlockHarvestLevel(pb.aN, "pickaxe", 2);
        MinecraftForge.setBlockHarvestLevel(pb.aO, "pickaxe", 2);
        MinecraftForge.removeBlockEffectiveness(pb.aN, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(pb.ap, "pickaxe");
        MinecraftForge.removeBlockEffectiveness(pb.aO, "pickaxe");
        for (pb block : pickeff = new pb[]{pb.w, pb.aj, pb.ak, pb.t, pb.Q, pb.ao, pb.I, pb.aT, pb.bb, pb.N, pb.O}) {
            MinecraftForge.setBlockHarvestLevel(block, "pickaxe", 0);
        }
        for (pb block : spadeEff = new pb[]{pb.u, pb.v, pb.E, pb.F, pb.aS, pb.aU, pb.aW, pb.aA, pb.bc, pb.by}) {
            MinecraftForge.setBlockHarvestLevel(block, "shovel", 0);
        }
        for (pb block : axeEff = new pb[]{pb.x, pb.an, pb.J, pb.au, pb.aj, pb.ak, pb.ba, pb.bf}) {
            MinecraftForge.setBlockHarvestLevel(block, "axe", 0);
        }
    }

    public static abs getEntitySpawnPacket(nn entity) {
        EntityTrackerInfo info = MinecraftForge.getEntityTrackerInfo(entity, false);
        if (info == null) {
            return null;
        }
        PacketEntitySpawn pkt = new PacketEntitySpawn(entity, info.Mod, info.ID);
        return pkt.getPacket();
    }

    public static boolean onArrowLoose(aan itemstack, xd world, yw player, int heldTime) {
        for (IArrowLooseHandler handler : arrowLooseHandlers) {
            if (!handler.onArrowLoose(itemstack, world, player, heldTime)) continue;
            return true;
        }
        return false;
    }

    public static aan onArrowNock(aan itemstack, xd world, yw player) {
        for (IArrowNockHandler handler : arrowNockHandlers) {
            aan ret = handler.onArrowNock(itemstack, world, player);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static int getMajorVersion() {
        return 3;
    }

    public static int getMinorVersion() {
        return 3;
    }

    public static int getRevisionVersion() {
        return 8;
    }

    public static int getBuildVersion() {
        return 164;
    }

    public static void setPacketHandler(PacketHandlerBase handler) {
        if (forgePacketHandler != null) {
            throw new RuntimeException("Attempted to set Forge's Internal packet handler after it was already set");
        }
        forgePacketHandler = handler;
    }

    public static PacketHandlerBase getPacketHandler() {
        return forgePacketHandler;
    }

    public static boolean onItemDataPacket(lg net, ai pkt) {
        NetworkMod mod = MinecraftForge.getModByID(pkt.a);
        if (mod == null) {
            ModLoader.getLogger().log(Level.WARNING, String.format("Received Unknown MapData packet %d:%d", pkt.a, pkt.b));
            return false;
        }
        mod.onPacketData(net, pkt.b, pkt.c);
        return true;
    }

    static {
        entityTrackerMap = new HashMap();
        networkMods = new Hashtable();
        guiHandlers = new Hashtable();
        arrowLooseHandlers = new ArrayList();
        arrowNockHandlers = new ArrayList();
        plantGrassList = new ArrayList<ProbableItem>();
        plantGrassList.add(new ProbableItem(pb.ad.bO, 0, 1, 0, 20));
        plantGrassList.add(new ProbableItem(pb.ae.bO, 0, 1, 20, 30));
        plantGrassWeight = 30;
        seedGrassList = new ArrayList<ProbableItem>();
        seedGrassList.add(new ProbableItem(yr.S.bQ, 0, 1, 0, 10));
        seedGrassWeight = 10;
        System.out.printf("MinecraftForge v%d.%d.%d.%d Initialized\n", 3, 3, 8, 164);
        ModLoader.getLogger().info(String.format("MinecraftForge v%d.%d.%d.%d Initialized", 3, 3, 8, 164));
        toolInit = false;
        toolClasses = new HashMap();
        toolHarvestLevels = new HashMap();
        toolEffectiveness = new HashSet();
        forgePacketHandler = null;
    }

    static class ProbableItem {
        int WeightStart;
        int WeightEnd;
        int ItemID;
        int Metadata;
        int Quantity;

        public ProbableItem(int item, int metadata, int quantity, int start, int end) {
            this.WeightStart = start;
            this.WeightEnd = end;
            this.ItemID = item;
            this.Metadata = metadata;
            this.Quantity = quantity;
        }
    }
}

