/*
 * Decompiled with CFR 0.152.
 */
package forge;

import forge.ISpecialArmor;
import java.util.ArrayList;
import java.util.Arrays;

public class ArmorProperties
implements Comparable<ArmorProperties> {
    public int Priority = 0;
    public int AbsorbMax = Integer.MAX_VALUE;
    public double AbsorbRatio = 0.0;
    public int Slot = 0;
    private static final boolean DEBUG = false;

    public ArmorProperties(int priority, double ratio, int max) {
        this.Priority = priority;
        this.AbsorbRatio = ratio;
        this.AbsorbMax = max;
    }

    public static int ApplyArmor(acq entity, aan[] inventory, md source, double damage) {
        damage *= 25.0;
        ArrayList<ArmorProperties> dmgVals = new ArrayList<ArmorProperties>();
        for (int x = 0; x < inventory.length; ++x) {
            ISpecialArmor armor;
            aan stack = inventory[x];
            if (stack == null) continue;
            ArmorProperties prop = null;
            if (stack.a() instanceof ISpecialArmor) {
                armor = (ISpecialArmor)((Object)stack.a());
                prop = armor.getProperties(entity, stack, source, damage / 25.0, x).copy();
            } else if (stack.a() instanceof ql && !source.e()) {
                armor = (ql)stack.a();
                prop = new ArmorProperties(0, (double)((ql)armor).b / 25.0, armor.h() + 1 - stack.i());
            }
            if (prop == null) continue;
            prop.Slot = x;
            dmgVals.add(prop);
        }
        if (dmgVals.size() > 0) {
            ArmorProperties[] props = dmgVals.toArray(new ArmorProperties[0]);
            ArmorProperties.StandardizeList(props, damage);
            int level = props[0].Priority;
            double ratio = 0.0;
            for (ArmorProperties prop : props) {
                if (level != prop.Priority) {
                    damage -= damage * ratio;
                    ratio = 0.0;
                    level = prop.Priority;
                }
                ratio += prop.AbsorbRatio;
                double absorb = damage * prop.AbsorbRatio;
                if (!(absorb > 0.0)) continue;
                aan stack = inventory[prop.Slot];
                int itemDamage = (int)(absorb / 25.0 < 1.0 ? 1.0 : absorb / 25.0);
                if (stack.a() instanceof ISpecialArmor) {
                    ((ISpecialArmor)((Object)stack.a())).damageArmor(entity, stack, source, itemDamage, prop.Slot);
                } else {
                    stack.a(itemDamage, entity);
                }
                if (stack.a > 0) continue;
                if (entity instanceof yw) {
                    stack.a((yw)entity);
                }
                inventory[prop.Slot] = null;
            }
            damage -= damage * ratio;
        }
        entity.bz = (int)(damage += (double)entity.bz) % 25;
        return (int)(damage / 25.0);
    }

    private static void StandardizeList(ArmorProperties[] armor, double damage) {
        Arrays.sort(armor);
        int start = 0;
        double total = 0.0;
        int priority = armor[0].Priority;
        int pStart = 0;
        boolean pChange = false;
        boolean pFinished = false;
        for (int x = 0; x < armor.length; ++x) {
            int y;
            total += armor[x].AbsorbRatio;
            if (x != armor.length - 1 && armor[x].Priority == priority) continue;
            if (armor[x].Priority != priority) {
                total -= armor[x].AbsorbRatio;
                --x;
                pChange = true;
            }
            if (total > 1.0) {
                for (y = start; y <= x; ++y) {
                    double newRatio = armor[y].AbsorbRatio / total;
                    if (newRatio * damage > (double)armor[y].AbsorbMax) {
                        armor[y].AbsorbRatio = (double)armor[y].AbsorbMax / damage;
                        total = 0.0;
                        for (int z2 = pStart; z2 <= y; ++z2) {
                            total += armor[z2].AbsorbRatio;
                        }
                        start = y + 1;
                        x = y;
                        break;
                    }
                    armor[y].AbsorbRatio = newRatio;
                    pFinished = true;
                }
                if (!pChange || !pFinished) continue;
                damage -= damage * total;
                total = 0.0;
                start = x + 1;
                priority = armor[start].Priority;
                pStart = start;
                pChange = false;
                pFinished = false;
                if (!(damage <= 0.0)) continue;
                for (y = x + 1; y < armor.length; ++y) {
                    armor[y].AbsorbRatio = 0.0;
                }
            } else {
                for (y = start; y <= x; ++y) {
                    total -= armor[y].AbsorbRatio;
                    if (damage * armor[y].AbsorbRatio > (double)armor[y].AbsorbMax) {
                        armor[y].AbsorbRatio = (double)armor[y].AbsorbMax / damage;
                    }
                    total += armor[y].AbsorbRatio;
                }
                damage -= damage * total;
                total = 0.0;
                if (x == armor.length - 1) continue;
                start = x + 1;
                priority = armor[start].Priority;
                pStart = start;
                pChange = false;
                if (!(damage <= 0.0)) continue;
                for (y = x + 1; y < armor.length; ++y) {
                    armor[y].AbsorbRatio = 0.0;
                }
            }
            break;
        }
    }

    @Override
    public int compareTo(ArmorProperties o2) {
        if (o2.Priority != this.Priority) {
            return o2.Priority - this.Priority;
        }
        double left = this.AbsorbRatio == 0.0 ? 0.0 : (double)this.AbsorbMax * 100.0 / this.AbsorbRatio;
        double right = o2.AbsorbRatio == 0.0 ? 0.0 : (double)o2.AbsorbMax * 100.0 / o2.AbsorbRatio;
        return (int)(left - right);
    }

    public String toString() {
        return String.format("%d, %d, %f, %d", this.Priority, this.AbsorbMax, this.AbsorbRatio, this.AbsorbRatio == 0.0 ? 0 : (int)((double)this.AbsorbMax * 100.0 / this.AbsorbRatio));
    }

    public ArmorProperties copy() {
        return new ArmorProperties(this.Priority, this.AbsorbRatio, this.AbsorbMax);
    }
}

