/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.modloader;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.modloader.BaseMod;
import cpw.mods.fml.common.modloader.BaseModTicker;
import cpw.mods.fml.common.modloader.ModLoaderModContainer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ModLoaderHelper {
    private static Map<BaseMod, ModLoaderModContainer> notModCallbacks = new HashMap<BaseMod, ModLoaderModContainer>();

    public static void updateStandardTicks(BaseMod mod, boolean enable, boolean useClock) {
        ModLoaderModContainer mlmc = ModLoaderHelper.findOrBuildModContainer(mod);
        BaseModTicker ticker = mlmc.getGameTickHandler();
        EnumSet<TickType> ticks = ticker.ticks();
        if (enable && !useClock) {
            ticks.add(TickType.RENDER);
        } else {
            ticks.remove((Object)TickType.RENDER);
        }
        if (enable && (useClock || FMLCommonHandler.instance().getSide().isServer())) {
            ticks.add(TickType.GAME);
            ticks.add(TickType.WORLDLOAD);
        } else {
            ticks.remove((Object)TickType.GAME);
            ticks.remove((Object)TickType.WORLDLOAD);
        }
    }

    public static void updateGUITicks(BaseMod mod, boolean enable, boolean useClock) {
        ModLoaderModContainer mlmc = ModLoaderHelper.findOrBuildModContainer(mod);
        EnumSet<TickType> ticks = mlmc.getGUITickHandler().ticks();
        if (enable && !useClock) {
            ticks.add(TickType.RENDER);
            ticks.add(TickType.GUILOAD);
        } else {
            ticks.remove((Object)TickType.RENDER);
        }
        if (enable && useClock) {
            ticks.add(TickType.GAME);
            ticks.add(TickType.GUILOAD);
            ticks.add(TickType.WORLDLOAD);
        } else {
            ticks.remove((Object)TickType.GAME);
            ticks.remove((Object)TickType.GUILOAD);
            ticks.remove((Object)TickType.WORLDLOAD);
        }
    }

    private static ModLoaderModContainer findOrBuildModContainer(BaseMod mod) {
        ModLoaderModContainer mlmc = (ModLoaderModContainer)FMLCommonHandler.instance().findContainerFor(mod);
        if (mlmc == null && (mlmc = notModCallbacks.get(mod)) == null) {
            mlmc = new ModLoaderModContainer(mod);
            notModCallbacks.put(mod, mlmc);
        }
        return mlmc;
    }

    public static ModLoaderModContainer registerRenderHelper(BaseMod mod) {
        ModLoaderModContainer mlmc = ModLoaderHelper.findOrBuildModContainer(mod);
        return mlmc;
    }

    public static ModLoaderModContainer registerKeyHelper(BaseMod mod) {
        ModLoaderModContainer mlmc = ModLoaderHelper.findOrBuildModContainer(mod);
        return mlmc;
    }
}

