/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.client;

import cpw.mods.fml.client.BlockRenderInfo;
import cpw.mods.fml.client.FMLTextureFX;
import cpw.mods.fml.client.ITextureFX;
import cpw.mods.fml.client.KeyBindingHandler;
import cpw.mods.fml.client.OptifineModContainer;
import cpw.mods.fml.client.OverrideInfo;
import cpw.mods.fml.client.SpriteHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLModLoaderContainer;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.IKeyHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ProxyInjector;
import cpw.mods.fml.common.ReflectionHelper;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.modloader.ModLoaderHelper;
import cpw.mods.fml.common.modloader.ModLoaderModContainer;
import cpw.mods.fml.common.modloader.ModProperty;
import cpw.mods.fml.common.registry.FMLRegistry;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class FMLClientHandler
implements IFMLSidedHandler {
    private static final FMLClientHandler INSTANCE = new FMLClientHandler();
    private Minecraft client;
    private abn[] defaultOverworldBiomes;
    private int nextRenderId = 30;
    private h fallbackTexturePack;
    private adl networkClient;
    private ModContainer animationCallbackMod;
    private HashMap<String, ArrayList<OverrideInfo>> overrideInfo = new HashMap();
    private HashMap<Integer, BlockRenderInfo> blockModelIds = new HashMap();
    private HashMap<afu, ModContainer> keyBindings = new HashMap();
    private List<IKeyHandler> keyHandlers = new ArrayList<IKeyHandler>();
    private HashSet<OverrideInfo> animationSet = new HashSet();
    private List<tt> addedTextureFX = new ArrayList<tt>();
    private boolean firstTick;
    private OptifineModContainer optifineContainer;
    private boolean guiLoaded;
    private HashMap<Integer, Dimension> textureDims = new HashMap();
    private IdentityHashMap<tt, Integer> effectTextures = new IdentityHashMap();

    public void onPreLoad(Minecraft minecraft) {
        this.client = minecraft;
        ReflectionHelper.detectObfuscation(xd.class);
        FMLCommonHandler.instance().beginLoading(this);
        FMLRegistry.registerRegistry(new ClientRegistry());
        try {
            Class<?> optifineConfig = Class.forName("Config", false, Loader.instance().getModClassLoader());
            this.optifineContainer = new OptifineModContainer(optifineConfig);
        }
        catch (Exception e) {
            this.optifineContainer = null;
        }
        if (this.optifineContainer != null) {
            try {
                ModMetadata optifineMetadata = this.readMetadataFrom(Loader.instance().getModClassLoader().getResourceAsStream("optifinemod.info"), this.optifineContainer);
                this.optifineContainer.setMetadata(optifineMetadata);
            }
            catch (Exception exception) {
                // empty catch block
            }
            FMLCommonHandler.instance().getFMLLogger().info(String.format("Forge Mod Loader has detected optifine %s, enabling compatibility features", this.optifineContainer.getVersion()));
        }
        try {
            Loader.instance().loadMods();
        }
        catch (LoaderException le2) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le2);
            return;
        }
    }

    @Override
    public void haltGame(String message, Throwable t2) {
        this.client.b(new ja(message, t2));
    }

    public void onLoadComplete() {
        try {
            Loader.instance().initializeMods();
        }
        catch (LoaderException le2) {
            this.haltGame("There was a severe problem during mod loading that has caused the game to fail", le2);
            return;
        }
        for (ModContainer mod : Loader.getModList()) {
            mod.gatherRenderers(ahu.a.getRendererList());
            for (um r2 : ahu.a.getRendererList().values()) {
                r2.a(ahu.a);
            }
        }
        hu gs2 = this.client.A;
        afu[] modKeyBindings = this.harvestKeyBindings();
        afu[] allKeys = new afu[gs2.A.length + modKeyBindings.length];
        System.arraycopy(gs2.A, 0, allKeys, 0, gs2.A.length);
        System.arraycopy(modKeyBindings, 0, allKeys, gs2.A.length, modKeyBindings.length);
        gs2.A = allKeys;
        gs2.a();
        this.firstTick = true;
    }

    public afu[] harvestKeyBindings() {
        List<IKeyHandler> allKeys = FMLCommonHandler.instance().gatherKeyBindings();
        afu[] keys = new afu[allKeys.size()];
        int i2 = 0;
        for (IKeyHandler key : allKeys) {
            keys[i2++] = (afu)key.getKeyBinding();
            this.keyBindings.put((afu)key.getKeyBinding(), key.getOwningContainer());
        }
        this.keyHandlers = allKeys;
        return keys;
    }

    public void onPreWorldTick() {
        if (this.client.f != null) {
            FMLCommonHandler.instance().tickStart(EnumSet.of(TickType.WORLD), this.client.f, this.client.s, this.client.f);
            FMLCommonHandler.instance().tickStart(EnumSet.of(TickType.GAME, TickType.WORLDGUI), Float.valueOf(0.0f), this.client.s, this.client.f);
        }
    }

    public void onPostWorldTick() {
        if (this.client.f != null) {
            FMLCommonHandler.instance().tickEnd(EnumSet.of(TickType.WORLD), this.client.f, this.client.s, this.client.f);
            FMLCommonHandler.instance().tickEnd(EnumSet.of(TickType.GAME, TickType.WORLDGUI), Float.valueOf(0.0f), this.client.s, this.client.f);
        }
        for (IKeyHandler entry : this.keyHandlers) {
            entry.onEndTick();
        }
    }

    public void onWorldLoadTick() {
        if (this.client.f != null) {
            if (this.firstTick) {
                this.loadTextures(this.fallbackTexturePack);
                this.firstTick = false;
            }
            FMLCommonHandler.instance().tickStart(EnumSet.of(TickType.WORLDLOAD), new Object[0]);
        }
    }

    public void onRenderTickStart(float partialTickTime) {
        FMLCommonHandler.instance().tickStart(EnumSet.of(TickType.RENDER, TickType.GUI), Float.valueOf(partialTickTime), this.client.s);
    }

    public void onRenderTickEnd(float partialTickTime) {
        if (!this.guiLoaded) {
            FMLCommonHandler.instance().rescheduleTicks();
            FMLCommonHandler.instance().tickStart(EnumSet.of(TickType.GUILOAD), Float.valueOf(partialTickTime), this.client.s);
            this.guiLoaded = true;
        }
        FMLCommonHandler.instance().tickEnd(EnumSet.of(TickType.RENDER, TickType.GUI), Float.valueOf(partialTickTime), this.client.s);
    }

    public Minecraft getClient() {
        return this.client;
    }

    @Override
    public Logger getMinecraftLogger() {
        return null;
    }

    public void onChunkPopulate(ca chunkProvider, int chunkX, int chunkZ, xd world, ca generator) {
        FMLCommonHandler.instance().handleWorldGeneration(chunkX, chunkZ, world.v(), world, generator, chunkProvider);
    }

    @Override
    public boolean isModLoaderMod(Class<?> clazz) {
        return BaseMod.class.isAssignableFrom(clazz);
    }

    @Override
    public ModContainer loadBaseModMod(Class<?> clazz, File canonicalFile) {
        Class<?> bmClazz = clazz;
        return new ModLoaderModContainer(bmClazz, canonicalFile);
    }

    public void notifyItemPickup(fq entityItem, yw entityPlayer) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPickupNotification()) continue;
            mod.getPickupNotifier().notifyPickup(entityItem, entityPlayer);
        }
    }

    public boolean tryDispensingEntity(xd world, double x, double y, double z2, byte xVelocity, byte zVelocity, aan item) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsToDispense() || !mod.getDispenseHandler().dispense(x, y, z2, xVelocity, zVelocity, world, item)) continue;
            return true;
        }
        return false;
    }

    public static FMLClientHandler instance() {
        return INSTANCE;
    }

    public abn[] getDefaultOverworldBiomes() {
        if (this.defaultOverworldBiomes == null) {
            ArrayList<abn> biomes = new ArrayList<abn>(20);
            for (int i2 = 0; i2 < 23; ++i2) {
                if ("Sky".equals(abn.a[i2].y) || "Hell".equals(abn.a[i2].y)) continue;
                biomes.add(abn.a[i2]);
            }
            this.defaultOverworldBiomes = new abn[biomes.size()];
            biomes.toArray(this.defaultOverworldBiomes);
        }
        return this.defaultOverworldBiomes;
    }

    public void onItemCrafted(yw player, aan craftedItem, io craftingGrid) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsCraftingNotification()) continue;
            mod.getCraftingHandler().onCrafting(player, craftedItem, craftingGrid);
        }
    }

    public void onItemSmelted(yw player, aan smeltedItem) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsCraftingNotification()) continue;
            mod.getCraftingHandler().onSmelting(player, smeltedItem);
        }
    }

    public boolean handleChatPacket(afd chat) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsNetworkPackets() || !mod.getNetworkHandler().onChat(chat)) continue;
            return true;
        }
        return false;
    }

    public void handleServerLogin(aec loginPacket, adl handler, lg networkManager) {
        this.networkClient = handler;
        ee packet = new ee();
        packet.a = "REGISTER";
        packet.c = FMLCommonHandler.instance().getPacketRegistry();
        packet.b = packet.c.length;
        if (packet.b > 0) {
            networkManager.a((abs)packet);
        }
        for (ModContainer mod : Loader.getModList()) {
            mod.getNetworkHandler().onServerLogin((Object)handler);
        }
    }

    public void handlePacket250(ee packet) {
        if ("REGISTER".equals(packet.a) || "UNREGISTER".equals(packet.a)) {
            this.handleServerRegistration(packet);
            return;
        }
        ModContainer mod = FMLCommonHandler.instance().getModForChannel(packet.a);
        if (mod != null) {
            mod.getNetworkHandler().onPacket250Packet(packet);
        }
    }

    private void handleServerRegistration(ee packet) {
        if (packet.c == null) {
            return;
        }
        try {
            for (String channel : new String(packet.c, "UTF8").split("\u0000")) {
                if (FMLCommonHandler.instance().getModForChannel(channel) == null) continue;
                if ("REGISTER".equals(packet.a)) {
                    FMLCommonHandler.instance().activateChannel(this.client.h, channel);
                    continue;
                }
                FMLCommonHandler.instance().deactivateChannel(this.client.h, channel);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getMinecraftLogger().warning("Received invalid registration packet");
        }
    }

    @Override
    public File getMinecraftRootDirectory() {
        return this.client.F;
    }

    public void announceLogout(yw player) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPlayerTracking()) continue;
            mod.getPlayerTracker().onPlayerLogout(player);
        }
    }

    public void announceDimensionChange(yw player) {
        for (ModContainer mod : Loader.getModList()) {
            if (!mod.wantsPlayerTracking()) continue;
            mod.getPlayerTracker().onPlayerChangedDimension(player);
        }
    }

    public void addBiomeToDefaultWorldGenerator(abn biome) {
        vx.b.addNewBiome(biome);
    }

    @Override
    public Object getMinecraftInstance() {
        return this.client;
    }

    @Override
    public String getCurrentLanguage() {
        return adn.a().c();
    }

    @Override
    public Properties getCurrentLanguageTable() {
        return adn.a().getTranslationTable();
    }

    public int addNewArmourRendererPrefix(String armor) {
        return we.addNewArmourPrefix(armor);
    }

    public void addNewTextureOverride(String textureToOverride, String overridingTexturePath, int location) {
        if (!this.overrideInfo.containsKey(textureToOverride)) {
            this.overrideInfo.put(textureToOverride, new ArrayList());
        }
        ArrayList<OverrideInfo> list = this.overrideInfo.get(textureToOverride);
        OverrideInfo info = new OverrideInfo();
        info.index = location;
        info.override = overridingTexturePath;
        info.texture = textureToOverride;
        list.add(info);
        FMLCommonHandler.instance().getFMLLogger().log(Level.FINE, String.format("Overriding %s @ %d with %s. %d slots remaining", textureToOverride, location, overridingTexturePath, SpriteHelper.freeSlotCount(textureToOverride)));
    }

    public int obtainBlockModelIdFor(BaseMod mod, boolean inventoryRenderer) {
        ModLoaderModContainer mlmc = ModLoaderHelper.registerRenderHelper(mod);
        int renderId = this.nextRenderId++;
        BlockRenderInfo bri = new BlockRenderInfo(renderId, inventoryRenderer, mlmc);
        this.blockModelIds.put(renderId, bri);
        return renderId;
    }

    public BufferedImage loadImageFromTexturePack(aaw renderEngine, String path) throws IOException {
        InputStream image = this.client.E.a.a(path);
        if (image == null) {
            throw new RuntimeException(String.format("The requested image path %s is not found", path));
        }
        BufferedImage result = ImageIO.read(image);
        if (result == null) {
            throw new RuntimeException(String.format("The requested image path %s appears to be corrupted", path));
        }
        return result;
    }

    public void displayGuiScreen(yw player, vp gui) {
        if (this.client.i == player && gui != null) {
            this.client.a(gui);
        }
    }

    public void registerKeyHandler(BaseMod mod, afu keyHandler, boolean allowRepeat) {
        ModLoaderModContainer mlmc = ModLoaderHelper.registerKeyHelper(mod);
        mlmc.addKeyHandler(new KeyBindingHandler(keyHandler, allowRepeat, mlmc));
    }

    public boolean renderWorldBlock(vl renderer, ali world, int x, int y, int z2, pb block, int modelId) {
        if (!this.blockModelIds.containsKey(modelId)) {
            return false;
        }
        BlockRenderInfo bri = this.blockModelIds.get(modelId);
        return bri.renderWorldBlock(world, x, y, z2, block, modelId, renderer);
    }

    public void renderInventoryBlock(vl renderer, pb block, int metadata, int modelID) {
        if (!this.blockModelIds.containsKey(modelID)) {
            return;
        }
        BlockRenderInfo bri = this.blockModelIds.get(modelID);
        bri.renderInventoryBlock(block, metadata, modelID, renderer);
    }

    public boolean renderItemAsFull3DBlock(int modelId) {
        BlockRenderInfo bri = this.blockModelIds.get(modelId);
        if (bri != null) {
            return bri.shouldRender3DInInventory();
        }
        return false;
    }

    public void registerTextureOverrides(aaw renderer) {
        for (ModContainer mod : Loader.getModList()) {
            this.registerAnimatedTexturesFor(mod);
        }
        for (OverrideInfo animationOverride : this.animationSet) {
            renderer.a(animationOverride.textureFX);
            this.addedTextureFX.add(animationOverride.textureFX);
            FMLCommonHandler.instance().getFMLLogger().finer(String.format("Registered texture override %d (%d) on %s (%d)", animationOverride.index, animationOverride.textureFX.g, animationOverride.textureFX.getClass().getSimpleName(), animationOverride.textureFX.k));
        }
        for (String fileToOverride : this.overrideInfo.keySet()) {
            for (OverrideInfo override : this.overrideInfo.get(fileToOverride)) {
                try {
                    BufferedImage image = this.loadImageFromTexturePack(renderer, override.override);
                    ModTextureStatic mts = new ModTextureStatic(override.index, 1, override.texture, image);
                    renderer.a(mts);
                    this.addedTextureFX.add(mts);
                    FMLCommonHandler.instance().getFMLLogger().finer(String.format("Registered texture override %d (%d) on %s (%d)", override.index, mts.g, override.texture, mts.k));
                }
                catch (IOException e) {
                    FMLCommonHandler.instance().getFMLLogger().throwing("FMLClientHandler", "registerTextureOverrides", e);
                }
            }
        }
    }

    private void registerAnimatedTexturesFor(ModContainer mod) {
        this.animationCallbackMod = mod;
        mod.requestAnimations();
        this.animationCallbackMod = null;
    }

    @Override
    public String getObjectName(Object instance) {
        String objectName;
        if (instance instanceof yr) {
            objectName = ((yr)instance).e();
        } else if (instance instanceof pb) {
            objectName = ((pb)instance).s();
        } else if (instance instanceof aan) {
            objectName = yr.e[((aan)instance).c].a((aan)instance);
        } else {
            throw new IllegalArgumentException(String.format("Illegal object for naming %s", instance));
        }
        objectName = objectName + ".name";
        return objectName;
    }

    @Override
    public ModMetadata readMetadataFrom(InputStream input, ModContainer mod) throws Exception {
        ModMetadata meta;
        block6: {
            ly root = new fw().a((Reader)new InputStreamReader(input));
            List lst = root.b(new Object[0]);
            fd modinfo = null;
            for (fd tmodinfo : lst) {
                if (!mod.getName().equals(tmodinfo.a(new Object[]{"modid"}))) continue;
                modinfo = tmodinfo;
                break;
            }
            if (modinfo == null) {
                FMLCommonHandler.instance().getFMLLogger().fine(String.format("Unable to process JSON modinfo file for %s", mod.getName()));
                return null;
            }
            meta = new ModMetadata(mod);
            try {
                meta.name = modinfo.a(new Object[]{"name"});
                meta.description = modinfo.a(new Object[]{"description"}).replace("\r", "");
                meta.version = modinfo.a(new Object[]{"version"});
                meta.credits = modinfo.a(new Object[]{"credits"});
                List authors = modinfo.b(new Object[]{"authors"});
                StringBuilder sb2 = new StringBuilder();
                for (int i2 = 0; i2 < authors.size(); ++i2) {
                    meta.authorList.add(((fd)authors.get(i2)).b());
                }
                meta.logoFile = modinfo.a(new Object[]{"logoFile"});
                meta.url = modinfo.a(new Object[]{"url"});
                meta.updateUrl = modinfo.a(new Object[]{"updateUrl"});
                meta.parent = modinfo.a(new Object[]{"parent"});
                List screenshots = modinfo.b(new Object[]{"screenshots"});
                meta.screenshots = new String[screenshots.size()];
                for (int i3 = 0; i3 < screenshots.size(); ++i3) {
                    meta.screenshots[i3] = ((fd)screenshots.get(i3)).b();
                }
            }
            catch (Exception e) {
                FMLCommonHandler.instance().getFMLLogger().log(Level.FINE, String.format("An error occured reading the info file for %s", mod.getName()), e);
                if (yr.class.getPackage() == null) break block6;
                System.out.println(String.format("An error occured reading the info file for %s", mod.getName()));
                e.printStackTrace();
            }
        }
        return meta;
    }

    public void pruneOldTextureFX(h var1, List<tt> effects) {
        ListIterator<tt> li2 = this.addedTextureFX.listIterator();
        while (li2.hasNext()) {
            tt tex = li2.next();
            if (tex instanceof FMLTextureFX) {
                if (!((FMLTextureFX)tex).unregister(this.client.p, effects)) continue;
                li2.remove();
                continue;
            }
            effects.remove(tex);
            li2.remove();
        }
    }

    public void loadTextures(h texturePack) {
        this.registerTextureOverrides(this.client.p);
    }

    public void onEarlyTexturePackLoad(h fallback) {
        if (this.client == null) {
            this.fallbackTexturePack = fallback;
        } else {
            this.loadTextures(fallback);
        }
    }

    public void sendPacket(abs packet) {
        if (this.networkClient != null) {
            this.networkClient.c(packet);
        }
    }

    public void addAnimation(tt anim) {
        if (this.animationCallbackMod == null) {
            return;
        }
        OverrideInfo info = new OverrideInfo();
        info.index = anim.g;
        info.imageIndex = anim.k;
        info.textureFX = anim;
        if (this.animationSet.contains(info)) {
            this.animationSet.remove(info);
        }
        this.animationSet.add(info);
    }

    @Override
    public void profileStart(String profileLabel) {
        lv.a(profileLabel);
    }

    @Override
    public void profileEnd() {
        lv.b();
    }

    public void preGameLoad(String user, String sessionToken) {
        Minecraft.fmlReentry(user, sessionToken);
    }

    public void onTexturePackChange(aaw engine, h texturepack, List<tt> effects) {
        FMLClientHandler.instance().pruneOldTextureFX(texturepack, effects);
        for (tt tex : effects) {
            if (!(tex instanceof ITextureFX)) continue;
            ((ITextureFX)tex).onTexturePackChanged(engine, texturepack, this.getTextureDimensions(tex));
        }
        FMLClientHandler.instance().loadTextures(texturepack);
    }

    public void setTextureDimensions(int id2, int width, int height, List<tt> effects) {
        Dimension dim = new Dimension(width, height);
        this.textureDims.put(id2, dim);
        for (tt tex : effects) {
            if (this.getEffectTexture(tex) != id2 || !(tex instanceof ITextureFX)) continue;
            ((ITextureFX)tex).onTextureDimensionsUpdate(width, height);
        }
    }

    public Dimension getTextureDimensions(tt effect) {
        return this.getTextureDimensions(this.getEffectTexture(effect));
    }

    public Dimension getTextureDimensions(int id2) {
        return this.textureDims.get(id2);
    }

    public int getEffectTexture(tt effect) {
        Integer id2 = this.effectTextures.get(effect);
        if (id2 != null) {
            return id2;
        }
        int old = GL11.glGetInteger((int)32873);
        effect.a(this.client.p);
        id2 = GL11.glGetInteger((int)32873);
        GL11.glBindTexture((int)3553, (int)old);
        this.effectTextures.put(effect, id2);
        return id2;
    }

    public boolean onUpdateTextureEffect(tt effect) {
        ITextureFX ifx;
        Logger log = FMLCommonHandler.instance().getFMLLogger();
        ITextureFX iTextureFX = ifx = effect instanceof ITextureFX ? (ITextureFX)effect : null;
        if (ifx != null && ifx.getErrored()) {
            return false;
        }
        String name = effect.getClass().getSimpleName();
        lv.a(name);
        try {
            if (this.optifineContainer == null) {
                effect.a();
            }
        }
        catch (Exception e) {
            log.warning(String.format("Texture FX %s has failed to animate. Likely caused by a texture pack change that they did not respond correctly to", name));
            if (ifx != null) {
                ifx.setErrored(true);
            }
            lv.b();
            return false;
        }
        lv.b();
        if (ifx != null) {
            Dimension dim = this.getTextureDimensions(effect);
            int target = (dim.width >> 4) * (dim.height >> 4) << 2;
            if (effect.f.length != target) {
                log.warning(String.format("Detected a texture FX sizing discrepancy in %s (%d, %d)", name, effect.f.length, target));
                ifx.setErrored(true);
                return false;
            }
        }
        return true;
    }

    public void scaleTextureFXData(byte[] data, ByteBuffer buf, int target, int length) {
        int sWidth = (int)Math.sqrt(data.length / 4);
        int factor = target / sWidth;
        byte[] tmp = new byte[4];
        buf.clear();
        if (factor > 1) {
            for (int y = 0; y < sWidth; ++y) {
                int sRowOff = sWidth * y;
                int tRowOff = target * y * factor;
                for (int x = 0; x < sWidth; ++x) {
                    int sPos = (x + sRowOff) * 4;
                    tmp[0] = data[sPos + 0];
                    tmp[1] = data[sPos + 1];
                    tmp[2] = data[sPos + 2];
                    tmp[3] = data[sPos + 3];
                    int tPosTop = x * factor + tRowOff;
                    for (int y2 = 0; y2 < factor; ++y2) {
                        buf.position((tPosTop + y2 * target) * 4);
                        for (int x2 = 0; x2 < factor; ++x2) {
                            buf.put(tmp);
                        }
                    }
                }
            }
        }
        buf.position(0).limit(length);
    }

    public void onPreRegisterEffect(tt effect) {
        Dimension dim = this.getTextureDimensions(effect);
        if (effect instanceof ITextureFX) {
            ((ITextureFX)effect).onTextureDimensionsUpdate(dim.width, dim.height);
        }
    }

    @Override
    public ModProperty getModLoaderPropertyFor(Field f) {
        if (f.isAnnotationPresent(MLProp.class)) {
            MLProp prop = f.getAnnotation(MLProp.class);
            return new ModProperty(prop.info(), prop.min(), prop.max(), prop.name());
        }
        return null;
    }

    public void addSpecialModEntries(ArrayList<ModContainer> mods) {
        mods.add(new FMLModLoaderContainer());
        if (this.optifineContainer != null) {
            mods.add(this.optifineContainer);
        }
    }

    @Override
    public List<String> getAdditionalBrandingInformation() {
        if (this.optifineContainer != null) {
            return Arrays.asList(String.format("Optifine %s", this.optifineContainer.getVersion()));
        }
        return Collections.emptyList();
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    @Override
    public ProxyInjector findSidedProxyOn(cpw.mods.fml.common.modloader.BaseMod mod) {
        for (Field f : mod.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(SidedProxy.class)) continue;
            SidedProxy sp = f.getAnnotation(SidedProxy.class);
            return new ProxyInjector(sp.clientSide(), sp.serverSide(), sp.bukkitSide(), f);
        }
        return null;
    }

    public void removeBiomeFromDefaultWorldGenerator(abn biome) {
        vx.b.removeBiome(biome);
    }
}

