/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.DefaultOverlayRenderer;
import codechicken.nei.NEIUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;

public class ShapedRecipeHandler
extends TemplateRecipeHandler {
    @Override
    public String getRecipeName() {
        return "Shaped Crafting";
    }

    @Override
    public void loadCraftingRecipes(aan result) {
        List allrecipes = fr.a().b();
        for (wf irecipe : allrecipes) {
            if (!(irecipe instanceof aai) || !NEIUtils.areStacksSameTypeCrafting(irecipe.b(), result)) continue;
            this.arecipes.add(new CachedShapedRecipe((aai)irecipe));
        }
    }

    @Override
    public void loadUsageRecipes(aan ingredient) {
        List allrecipes = fr.a().b();
        for (wf irecipe : allrecipes) {
            CachedShapedRecipe recipe;
            if (!(irecipe instanceof aai) || !(recipe = new CachedShapedRecipe((aai)irecipe)).contains(ingredient)) continue;
            recipe.replaceMetaOnIngredients(ingredient);
            this.arecipes.add(recipe);
        }
    }

    @Override
    public String getGuiTexture() {
        return "/gui/crafting.png";
    }

    @Override
    public boolean hasOverlay(gb gui, dd container, int recipe) {
        return DefaultOverlayRenderer.getOverlayIdent(gui).equals("crafting") || this.isRecipe2x2(recipe) && DefaultOverlayRenderer.getOverlayIdent(gui).equals("crafting2x2");
    }

    public boolean isRecipe2x2(int recipe) {
        for (PositionedStack stack : this.getIngredientStacks(recipe)) {
            if (stack.relx <= 43 && stack.rely <= 24) continue;
            return false;
        }
        return true;
    }

    public class CachedShapedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        ArrayList ingredients;
        PositionedStack result;

        public CachedShapedRecipe(aai recipe) {
            super(ShapedRecipeHandler.this);
            this.result = new PositionedStack(recipe.b(), 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(recipe);
        }

        public CachedShapedRecipe(int width, int height, aan[] items, aan out) {
            super(ShapedRecipeHandler.this);
            this.result = new PositionedStack(out, 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(width, height, items);
        }

        public void setIngredients(int width, int height, aan[] items) {
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    if (items[y * width + x] != null) {
                        PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18);
                        stack.setMaxSize(1);
                        this.ingredients.add(stack);
                    }
                    ++y;
                }
                ++x;
            }
        }

        public void setIngredients(aai recipe) {
            aan[] items;
            int height;
            int width;
            try {
                width = (Integer)ModLoader.getPrivateValue(aai.class, recipe, 0);
                height = (Integer)ModLoader.getPrivateValue(aai.class, recipe, 1);
                items = (aan[])ModLoader.getPrivateValue(aai.class, recipe, 2);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.setIngredients(width, height, items);
        }

        public void replaceMetaOnIngredients(aan ingredient) {
            for (PositionedStack stack : this.ingredients) {
                if (stack.item.i() != -1 || !NEIUtils.areStacksSameTypeCrafting(ingredient, stack.item)) continue;
                stack.item.b(ingredient.i());
            }
        }

        @Override
        public ArrayList getIngredients() {
            int cycle = ShapedRecipeHandler.this.cycleticks / 20;
            ArrayList<PositionedStack> cycledstacks = new ArrayList<PositionedStack>();
            for (PositionedStack basestack : this.ingredients) {
                PositionedStack stack = basestack.copy();
                if (stack.item.i() == -1) {
                    int maxDamage = 0;
                    do {
                        stack.item.b(++maxDamage);
                    } while (NEIUtils.isValidItem(stack.item));
                    stack.item.b(cycle % maxDamage);
                }
                cycledstacks.add(stack);
            }
            return cycledstacks;
        }

        public boolean contains(aan ingredient) {
            for (PositionedStack stack : this.ingredients) {
                if (!NEIUtils.areStacksSameTypeCrafting(stack.item, ingredient)) continue;
                return true;
            }
            return false;
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }
    }
}

