/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ConfigFile;
import codechicken.core.ConfigTag;
import codechicken.core.CoreUtils;
import codechicken.core.IStringMatcher;
import codechicken.nei.API;
import codechicken.nei.AllowedPropertyMap;
import codechicken.nei.GuiNEIBlockIDs;
import codechicken.nei.GuiNEISettings;
import codechicken.nei.IConfigureNEI;
import codechicken.nei.InterActionMap;
import codechicken.nei.ItemHash;
import codechicken.nei.ItemInfo;
import codechicken.nei.ItemVisibilityHash;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIPacketHandler;
import codechicken.nei.NEIUtils;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.Minecraft;

public class NEIConfig {
    private static aan[][] states = new aan[7][40];
    private static boolean[] statesSaved = new boolean[7];
    private static boolean SMPMagnetMode;
    private static boolean SMPCreativeInv;
    public static ItemVisibilityHash vishash;
    private static boolean configLoaded;
    private static boolean hasSMPCounterpart;
    private static HashSet permissableActions;
    private static HashSet bannedBlocks;
    private static HashSet disabledProperties;
    public static ady saveCompound;
    public static File saveFile;
    public static ConfigFile globalConfig;
    public static ConfigFile worldConfig;
    public static boolean global;

    static {
        permissableActions = new HashSet();
        bannedBlocks = new HashSet();
        disabledProperties = new HashSet();
        saveCompound = new ady();
        saveFile = new File(Minecraft.b(), "saves/NEI.dat");
        globalConfig = new ConfigFile(new File(Minecraft.b(), "config/NEI.cfg"));
        global = false;
        NEIConfig.setDefaults();
    }

    private static void setDefaults() {
        globalConfig.setComment("Main configuration of NEI.:Most of these options can be changed ingame.:Deleting any element will restore it to it's default value");
        globalConfig.getTag("KeyBinding").useBraces();
        globalConfig.getTag("options").useBraces();
        globalConfig.getTag("command").useBraces().setComment("Change these options if you have a different mod installed on the server that handles the commands differently, Eg. Bukkit Essentials");
        globalConfig.setNewLineMode(1);
        globalConfig.getTag("options.enable").setPosition(0).getBooleanValue(true);
        globalConfig.getTag("options.enablemp").setPosition(1).getBooleanValue(true);
        API.addSetting(new GuiNEISettings.NEIOption(""){

            @Override
            public String getIdent() {
                return NEIConfig.isMultiplayer() ? "options.enablemp" : "options.enable";
            }

            @Override
            public String updateText() {
                return "NEI " + (this.enabled() ? "Enabled" : "Disabled");
            }
        });
        globalConfig.getTag("options.hidden").setPosition(2).getBooleanValue(false);
        globalConfig.getTag("options.cheatmode").setPosition(3).setNewLine(true).getIntValue(2);
        API.addSetting(new GuiNEISettings.NEIOption("options.cheatmode"){

            @Override
            public String updateText() {
                return String.valueOf((new String[]{"Recipe", "Utility", "Cheat"})[this.intValue()]) + " Mode";
            }

            @Override
            public void onClick() {
                NEIConfig.cycleCheatMode();
            }
        });
        globalConfig.getTag("options.lockmode").setPosition(4).setComment("For those who can't help themselves:Set this to a mode and you will be unable to change it ingame").getIntValue(-1);
        globalConfig.getTag("options.utility actions").setPosition(5).setDefaultValue("delete, magnet");
        StringBuilder actionlist = new StringBuilder();
        InterActionMap[] actions = InterActionMap.values();
        int i2 = 0;
        while (i2 < actions.length) {
            if (i2 != 0) {
                actionlist.append(", ");
            }
            actionlist.append(actions[i2].getName());
            ++i2;
        }
        globalConfig.getTag("options.utility actions").setComment("list the actions that are considered 'utilities' rather than cheats:Choose from " + actionlist.toString());
        globalConfig.getTag("options.layout style").setPosition(6).setNewLine(true).getIntValue(0);
        API.addSetting(new GuiNEISettings.NEIOption("options.layout style"){

            @Override
            public String updateText() {
                return LayoutManager.getLayoutStyle().getName();
            }

            @Override
            public void onClick() {
                NEIConfig.cycleLayoutStyle();
            }
        });
        globalConfig.getTag("options.edge-align buttons").setPosition(7).getBooleanValue(false);
        globalConfig.getTag("options.show ids").setPosition(8).setNewLine(true).getIntValue(1);
        API.addSetting(new GuiNEISettings.NEIOption("options.show ids"){

            @Override
            public String updateText() {
                return "ItemID's: " + (new String[]{"Hidden", "Auto", "Shown"})[this.intValue()];
            }

            @Override
            public void onClick() {
                NEIConfig.cycleIDVisibility();
            }
        });
        globalConfig.getTag("options.realtimesearch").setPosition(9).getBooleanValue(true);
        API.addSetting(new GuiNEISettings.NEIOption("options.realtimesearch"){

            @Override
            public String updateText() {
                return " Realtime Search " + (this.enabled() ? "Enabled" : "Disabled");
            }
        });
        globalConfig.getTag("options.searchinventories").setPosition(10).getBooleanValue(false);
        globalConfig.getTag("options.itemdrops").setPosition(11).setNewLine(true).getBooleanValue(true);
        API.addSetting(new GuiNEISettings.NEIOption("options.itemdrops"){

            @Override
            public String updateText() {
                return "Item Drops: " + (this.enabled() || NEIConfig.isMultiplayer() ? "Enabled" : "Disabled");
            }

            @Override
            public void onClick() {
                if (!NEIConfig.isMultiplayer()) {
                    super.onClick();
                }
            }
        });
        globalConfig.getTag("command.creative").setComment("{0} = player, {1} = 1 for creative, 0 for survival").setDefaultValue("/gamemode {0} {1}");
        globalConfig.getTag("command.give").setNewLine(true).setComment("{0} = player, {1} = itemID, {2} = quantity, {3} = itemDamage").setDefaultValue("/give {0} {1} {2} {3}");
        globalConfig.getTag("command.time").setNewLine(true).setComment("{0} = worldtime").setDefaultValue("/time set {0}");
        globalConfig.getTag("command.rain").setNewLine(true).setComment("{0} = 1 for on, 0 for off").setDefaultValue("/toggledownfall");
        globalConfig.getTag("command.heal").setNewLine(true).setComment("The vanilla server doesn't have a heal command, however others may:{0} = player").setDefaultValue("null");
        globalConfig.getTag("saved.search").setDefaultValue("");
        NEIConfig.checkCheatMode();
        NEIConfig.addBlockIDSettings();
        NEIConfig.setDefaultKeyBindings();
        globalConfig.saveConfig();
    }

    private static void addBlockIDSettings() {
        API.addSetting(new GuiNEISettings.NEIOption(""){

            @Override
            public String updateText() {
                return "Block/Item ID Settings";
            }

            @Override
            public void onClick() {
                NEIUtils.getMinecraft().a(new GuiNEIBlockIDs(((GuiNEISettings)NEIUtils.getMinecraft().s).parentScreen));
            }
        }.setGlobalOnly());
        globalConfig.getTag("ID dump").useBraces().setComment("Block/Item ID settings, configured via the options menu ingame.");
        globalConfig.getTag("ID dump.show empty blockIDs").getBooleanValue(false);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.show empty blockIDs"){

            @Override
            public String updateText() {
                return String.valueOf(this.enabled() ? "Show" : "Hide") + " Unused BlockIDs";
            }
        });
        globalConfig.getTag("ID dump.dump on load").getBooleanValue(false);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.dump on load"){

            @Override
            public String updateText() {
                return String.valueOf(this.enabled() ? "Dump ID Map" : "Do Nothing") + " on Load";
            }
        }.setGlobalOnly());
        globalConfig.getTag("ID dump.blockIDs").getBooleanValue(true);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.blockIDs"){

            @Override
            public String updateText() {
                return String.valueOf(this.enabled() ? "Dump" : "Ignore") + " BlockIDs";
            }
        }.setGlobalOnly());
        globalConfig.getTag("ID dump.itemIDs").getBooleanValue(false);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.itemIDs"){

            @Override
            public String updateText() {
                return String.valueOf(this.enabled() ? "Dump" : "Ignore") + " ItemIDs";
            }
        }.setGlobalOnly());
        globalConfig.getTag("ID dump.unused blockIDs").getBooleanValue(true);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.unused blockIDs"){

            @Override
            public String updateText() {
                return String.valueOf(this.enabled() ? "Dump" : "Ignore") + " Unused BlockIDs";
            }
        }.setGlobalOnly());
        globalConfig.getTag("ID dump.unused itemIDs").getBooleanValue(false);
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption("ID dump.unused itemIDs"){

            @Override
            public String updateText() {
                return String.valueOf(this.enabled() ? "Dump" : "Ignore") + " Unused ItemIDs";
            }
        }.setGlobalOnly());
        API.addSetting(GuiNEIBlockIDs.class, new GuiNEISettings.NEIOption(""){

            @Override
            public String updateText() {
                return NEIConfig.canDump() ? "Dump ID Map Now" : "Nothing To Dump";
            }

            @Override
            public void onClick() {
                if (NEIConfig.canDump()) {
                    NEIUtils.dumpIDs();
                }
            }
        }.setGlobalOnly());
        if (!NEIConfig.canDump()) {
            globalConfig.getTag("ID dump.dump on load").setBooleanValue(false);
        }
    }

    public static boolean canDump() {
        return NEIConfig.getBooleanSetting("ID dump.itemIDs") || NEIConfig.getBooleanSetting("ID dump.blockIDs") || NEIConfig.getBooleanSetting("ID dump.unused itemIDs") || NEIConfig.getBooleanSetting("ID dump.unused blockIDs");
    }

    private static void setDefaultKeyBindings() {
        API.addKeyBind("recipe", "Recipe", 19);
        API.addKeyBind("usage", "Usage", 22);
        API.addKeyBind("back", "Previous Recipe", 14);
        API.addKeyBind("enchant", "Enchantment", 45);
        API.addKeyBind("prev", "Prev Page", 201);
        API.addKeyBind("next", "Next Page", 209);
        API.addKeyBind("hide", "Hide\\Show", 24);
    }

    private static void convertBooleanSetting(ConfigTag tag, int valtrue, int valfalse) {
        String val = tag.getValue();
        if (val.equals("true")) {
            tag.setIntValue(valtrue);
        } else if (val.equals("false")) {
            tag.setIntValue(valfalse);
        }
    }

    public static void loadWorld() {
        NEIConfig.loadConfig();
        xd world = NEIUtils.getMinecraft().f;
        if (world.F) {
            worldConfig = null;
            SMPMagnetMode = false;
            SMPCreativeInv = false;
        } else {
            File saveDir = CoreUtils.getWorldBaseSaveLocation(world);
            worldConfig = new ConfigFile(new File(saveDir, "NEI.cfg"));
            worldConfig.setComment("World based configuration of NEI.:Most of these options can be changed ingame.:Deleting any element will restore it to it's default value");
            worldConfig.getTag("options").useBraces();
            worldConfig.getTag("options.searchinventories").getBooleanValue(false);
            worldConfig.getTag("saved").useBraces();
            worldConfig.getTag("saved.search").setDefaultValue("");
            worldConfig.getTag("saved.magnetmode").getBooleanValue(false);
            worldConfig.getTag("saved.creativeinv").getBooleanValue(false);
            for (String prop : AllowedPropertyMap.nameToIDMap.keySet()) {
                worldConfig.getTag("saved.disabled-" + prop).getBooleanValue(false);
            }
        }
        LayoutManager.searchField.setText(NEIConfig.getSearchExpression());
    }

    public static boolean isWorldSpecific(String setting) {
        return worldConfig != null && worldConfig.containsTag(setting);
    }

    public static void copyWorldSetting(String setting) {
        worldConfig.getTag(setting).setValue(globalConfig.getTag(setting).getValue());
    }

    public static void removeWorldSetting(String setting) {
        worldConfig.removeTag(setting);
    }

    public static boolean isMultiplayer() {
        return NEIUtils.getMinecraft().f.F;
    }

    public static boolean isStateSaved(int i2) {
        return statesSaved[i2];
    }

    public static ConfigTag getSetting(String s) {
        if (worldConfig == null || global || !worldConfig.containsTag(s)) {
            return globalConfig.getTag(s);
        }
        return worldConfig.getTag(s);
    }

    public static boolean getBooleanSetting(String s) {
        return NEIConfig.getSetting(s).getBooleanValue();
    }

    public static boolean isEnabled() {
        return NEIConfig.isMultiplayer() ? NEIConfig.getBooleanSetting("options.enablemp") : NEIConfig.getBooleanSetting("options.enable");
    }

    public static void setEnabled(boolean flag) {
        NEIConfig.getSetting(NEIConfig.isMultiplayer() ? "options.enablemp" : "options.enable").setBooleanValue(flag);
    }

    public static int getKeyBinding(String string) {
        return NEIConfig.getSetting("KeyBinding." + string).getIntValue();
    }

    public static void setKeyBinding(String string, int key) {
        NEIConfig.getSetting("KeyBinding." + string).setIntValue(key);
    }

    public static void setDefaultKeyBinding(String string, int key) {
        globalConfig.getTag("KeyBinding." + string).getIntValue(key);
    }

    public static int getCheatMode() {
        return NEIConfig.getIntSetting("options.cheatmode");
    }

    public static void cycleCheatMode() {
        NEIConfig.cycleSetting("options.cheatmode", 3);
        NEIConfig.checkCheatMode();
    }

    private static void checkCheatMode() {
        if (NEIConfig.getLockedMode() != -1) {
            NEIConfig.setIntSetting("options.cheatmode", NEIConfig.getLockedMode());
        }
    }

    public static int getLockedMode() {
        return NEIConfig.getIntSetting("options.lockmode");
    }

    public static int getLayoutStyle() {
        return NEIConfig.getIntSetting("options.layout style");
    }

    protected static void cycleLayoutStyle() {
        int currentLayout;
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (Map.Entry entry : LayoutManager.layoutStyles.entrySet()) {
            list.add((Integer)entry.getKey());
        }
        Collections.sort(list);
        int nextLayout = currentLayout = NEIConfig.getLayoutStyle();
        if (nextLayout == (Integer)list.getLast()) {
            nextLayout = -1;
        }
        for (Integer i2 : list) {
            if (i2 <= nextLayout) continue;
            nextLayout = i2;
            break;
        }
        NEIConfig.setIntSetting("options.layout style", nextLayout);
    }

    public static String getStringSetting(String s) {
        return NEIConfig.getSetting(s).getValue();
    }

    public static boolean isHidden() {
        return NEIConfig.getBooleanSetting("options.hidden");
    }

    public static boolean showIDs() {
        int i2 = NEIConfig.getIntSetting("options.show ids");
        return i2 == 2 || i2 == 1 && NEIConfig.isEnabled() && !NEIConfig.isHidden();
    }

    public static int getIDVisibility() {
        return NEIConfig.getIntSetting("options.show ids");
    }

    public static void cycleIDVisibility() {
        NEIConfig.cycleSetting("options.show ids", 3);
    }

    public static void toggleBooleanSetting(String setting) {
        ConfigTag tag;
        tag.setBooleanValue(!(tag = NEIConfig.getSetting(setting)).getBooleanValue());
    }

    public static void cycleSetting(String setting, int max) {
        ConfigTag tag = NEIConfig.getSetting(setting);
        tag.setIntValue((tag.getIntValue() + 1) % max);
    }

    public static int getIntSetting(String setting) {
        return NEIConfig.getSetting(setting).getIntValue();
    }

    public static void setIntSetting(String setting, int val) {
        NEIConfig.getSetting(setting).setIntValue(val);
    }

    public static String getSearchExpression() {
        return NEIConfig.getStringSetting("saved.search");
    }

    public static void setSearchExpression(String expression) {
        NEIConfig.getSetting("saved.search").setValue(expression);
    }

    public static boolean getMagnetMode() {
        return NEIConfig.isMultiplayer() ? SMPMagnetMode : NEIConfig.getBooleanSetting("saved.magnetmode");
    }

    public static boolean invCreativeMode() {
        return NEIConfig.isMultiplayer() ? SMPCreativeInv : NEIConfig.getBooleanSetting("saved.creativeinv");
    }

    public static void setInvCreative(boolean b) {
        if (NEIConfig.isMultiplayer()) {
            SMPCreativeInv = b;
        } else {
            NEIConfig.getSetting("saved.creativeinv").setBooleanValue(b);
        }
    }

    public static void setMagnetMode(boolean b) {
        if (NEIConfig.isMultiplayer()) {
            SMPMagnetMode = b;
        } else {
            NEIConfig.getSetting("saved.magnetmode").setBooleanValue(b);
        }
    }

    public static boolean areDamageVariantsShown() {
        if (NEIConfig.isMultiplayer()) {
            String s = NEIConfig.getSetting("command.give").getValue();
            return s.contains("{3}");
        }
        return true;
    }

    public static void clearState(int state) {
        int i2 = 0;
        while (i2 < states[state].length) {
            NEIConfig.states[state][i2] = null;
            ++i2;
        }
        NEIConfig.statesSaved[state] = false;
        saveCompound.a("save" + state, (gh)new no());
        NEIConfig.saveConfig();
    }

    public static void loadState(int state) {
        if (!statesSaved[state]) {
            return;
        }
        aak inv = NEIUtils.getMinecraft().h.ap;
        if (NEIConfig.isMultiplayer()) {
            NEIPacketHandler.sendStateLoad(states[state]);
            return;
        }
        int i2 = 0;
        while (i2 < states[state].length) {
            aan itemstack = NEIUtils.copyStack(states[state][i2]);
            if (itemstack != null && itemstack.a() == null) {
                itemstack = null;
            }
            inv.a(i2, itemstack);
            ++i2;
        }
    }

    public static void saveState(int state) {
        no statesave = saveCompound.n("save" + state);
        aak inv = NEIUtils.getMinecraft().h.ap;
        int i2 = 0;
        while (i2 < states[state].length) {
            NEIConfig.states[state][i2] = NEIUtils.copyStack(inv.k_(i2));
            if (states[state][i2] != null) {
                ady stacksave = new ady();
                stacksave.a("Slot", (byte)i2);
                states[state][i2].b(stacksave);
                statesave.a((gh)stacksave);
            }
            ++i2;
        }
        saveCompound.a("save" + state, (gh)statesave);
        NEIConfig.statesSaved[state] = true;
        NEIConfig.saveConfig();
    }

    public static void loadStates() {
        boolean upgradedStateSaves = saveCompound.o("saveState2");
        if (!upgradedStateSaves) {
            saveCompound.a("saveState2", true);
            int i2 = 0;
            while (i2 < 7) {
                NEIConfig.clearState(i2);
                ++i2;
            }
            return;
        }
        int state = 0;
        while (state < 7) {
            no statesave = saveCompound.n("save" + state);
            int tagPos = 0;
            while (tagPos < statesave.d()) {
                aan stack;
                ady stacksave = (ady)statesave.a(tagPos);
                int i3 = stacksave.d("Slot") & 0xFF;
                NEIConfig.states[state][i3] = stack = aan.a((ady)stacksave);
                ++tagPos;
            }
            if (statesave.d() > 0) {
                NEIConfig.statesSaved[state] = true;
            }
            ++state;
        }
    }

    public static void loadConfig() {
        if (configLoaded) {
            return;
        }
        NEIConfig.loadSavedConfig();
        vishash = new ItemVisibilityHash();
        LayoutManager.searchField.text = NEIConfig.getSearchExpression();
        ItemInfo.load();
        configLoaded = true;
        ArrayList configclasses = CommonUtils.findClasses(new IStringMatcher(){

            @Override
            public boolean matches(String test) {
                return test.startsWith("NEI") && test.endsWith("Config.class");
            }
        }, IConfigureNEI.class);
        for (Class class1 : configclasses) {
            try {
                IConfigureNEI config = (IConfigureNEI)class1.newInstance();
                config.loadConfig();
                System.out.println("Loaded " + class1.getName());
            }
            catch (Exception e) {
                System.out.println("Failed to Load " + class1.getName());
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        try {
            if (!saveFile.exists()) {
                saveFile.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(saveFile);
            DataOutputStream dout = new DataOutputStream(fout);
            gh.a((gh)saveCompound, (DataOutput)dout);
            dout.close();
            fout.close();
        }
        catch (Exception e) {
            NEIUtils.reportException(e);
        }
    }

    private static void loadSavedConfig() {
        try {
            if (!saveFile.exists()) {
                saveFile.createNewFile();
            }
            if (saveFile.length() == 0L) {
                return;
            }
            FileInputStream fin = new FileInputStream(saveFile);
            DataInputStream din = new DataInputStream(fin);
            saveCompound = (ady)gh.b((DataInput)din);
            din.close();
            fin.close();
            NEIConfig.loadStates();
            ItemVisibilityHash.loadStates();
        }
        catch (Exception e) {
            NEIUtils.reportException(e);
        }
    }

    public static boolean hasSMPCounterPart() {
        return hasSMPCounterpart;
    }

    public static void setHasSMPCounterPart(boolean flag) {
        hasSMPCounterpart = flag;
        permissableActions.clear();
        bannedBlocks.clear();
        disabledProperties.clear();
    }

    public static void resetPermissableActions() {
        permissableActions.clear();
    }

    public static void addPermissableAction(InterActionMap action) {
        permissableActions.add(action);
    }

    public static boolean isActionPermissable(InterActionMap action) {
        return NEIConfig.isActionPermissable(action.getName());
    }

    public static boolean isActionPermissable(String actionname) {
        if (!NEIConfig.isEnabled() || NEIConfig.isHidden()) {
            return false;
        }
        if (actionname.equals("nbt")) {
            return !NEIConfig.isMultiplayer() || NEIConfig.hasSMPCounterPart();
        }
        InterActionMap action = InterActionMap.getAction(actionname);
        if (!NEIConfig.isActionPermissableInMode(actionname)) {
            return false;
        }
        if (NEIConfig.isMultiplayer()) {
            if (action == InterActionMap.HEAL && !hasSMPCounterpart) {
                return !NEIConfig.getStringSetting("command.heal").equals("null");
            }
            if (hasSMPCounterpart) {
                return permissableActions.contains((Object)action);
            }
            return !hasSMPCounterpart && !action.requiresSMPCounterpart;
        }
        return true;
    }

    private static boolean isActionPermissableInMode(String actionmode) {
        String[] actions;
        if (NEIConfig.getCheatMode() == 0) {
            return false;
        }
        if (NEIConfig.getCheatMode() == 2) {
            return true;
        }
        String[] stringArray = actions = NEIConfig.getUtilityDefinition();
        int n2 = actions.length;
        int n3 = 0;
        while (n3 < n2) {
            String action = stringArray[n3];
            if (action.equalsIgnoreCase(actionmode)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private static String[] getUtilityDefinition() {
        return NEIConfig.getStringSetting("options.utility actions").replace(" ", "").split(",");
    }

    public static void setBannedBlocks(ArrayList ahash) {
        bannedBlocks.clear();
        for (ItemHash hash : ahash) {
            bannedBlocks.add(hash);
        }
    }

    public static void resetDisabledProperties() {
        disabledProperties.clear();
    }

    public static boolean canGetItem(ItemHash item) {
        return NEIConfig.isMultiplayer() ? !bannedBlocks.contains(item) : true;
    }

    public static boolean isPropertyDisabled(String name) {
        if (NEIConfig.isMultiplayer()) {
            return disabledProperties.contains(AllowedPropertyMap.nameToIDMap.get(name));
        }
        return NEIConfig.getBooleanSetting("saved.disabled-" + name);
    }

    public static void setPropertyDisabled(int ID) {
        disabledProperties.add(ID);
    }

    public static void setPropertyDisabled(String name, boolean disable) {
        if (NEIConfig.isMultiplayer()) {
            if (NEIConfig.hasSMPCounterPart()) {
                NEIPacketHandler.sendSetPropertyDisabled(name, disable);
            }
        } else {
            NEIConfig.getSetting("saved.disabled-" + name).setBooleanValue(disable);
        }
    }
}

