/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.NEIUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class FastTransferManger {
    public LinkedList slotZones = new LinkedList();
    public HashMap slotZoneMap = new HashMap();

    public FastTransferManger(dd container) {
        this.generateSlotMap(container);
    }

    private void generateSlotMap(dd container) {
        int slotNo = 0;
        while (slotNo < container.e.size()) {
            if (!this.slotZoneMap.containsKey(slotNo) && container.b(slotNo).a(new aan(yr.n, 1))) {
                HashSet connectedSlots = new HashSet();
                this.findConnectedSlots(container, slotNo, connectedSlots);
                LinkedList zoneSlots = new LinkedList(connectedSlots);
                Collections.sort(zoneSlots, new SlotPositionComparator(container));
                this.slotZones.add(zoneSlots);
                Iterator iterator = zoneSlots.iterator();
                while (iterator.hasNext()) {
                    int i2 = (Integer)iterator.next();
                    this.slotZoneMap.put(i2, this.slotZones.size() - 1);
                }
            }
            ++slotNo;
        }
    }

    private void findConnectedSlots(dd container, int slotNo, HashSet connectedSlots) {
        connectedSlots.add(slotNo);
        yu slot = container.b(slotNo);
        int threshold = 18;
        int i2 = 0;
        while (i2 < container.e.size()) {
            if (!connectedSlots.contains(i2)) {
                yu slot1 = container.b(i2);
                if (Math.abs(slot.d - slot1.d) <= 18 && Math.abs(slot.e - slot1.e) <= 18) {
                    this.findConnectedSlots(container, i2, connectedSlots);
                }
            }
            ++i2;
        }
    }

    public static int findSlotWithItem(dd container, aan teststack) {
        int slotNo = 0;
        while (slotNo < container.e.size()) {
            aan stack = container.b(slotNo).b();
            if (stack != null && NEIUtils.areStacksSameType(stack, teststack)) {
                return slotNo;
            }
            ++slotNo;
        }
        return -1;
    }

    public static void clearSlots(dd container) {
        int slotNo = 0;
        while (slotNo < container.e.size()) {
            ((yu)container.e.get(slotNo)).d(null);
            ++slotNo;
        }
    }

    public void performMassTransfer(gb window, int fromSlot, int toSlot, aan heldStack) {
        Integer fromZone = (Integer)this.slotZoneMap.get(fromSlot);
        Integer toZone = (Integer)this.slotZoneMap.get(toSlot);
        if (fromZone == null || toZone == null || fromZone == toZone) {
            return;
        }
        if (NEIUtils.getHeldItem() != null && !NEIUtils.areStacksSameType(heldStack, NEIUtils.getHeldItem())) {
            return;
        }
        if (!this.fillZoneWithHeldItem(window, toZone)) {
            return;
        }
        Iterator iterator = ((LinkedList)this.slotZones.get(fromZone)).iterator();
        while (iterator.hasNext()) {
            int transferFrom = (Integer)iterator.next();
            aan transferStack = window.d.b(transferFrom).b();
            if (!NEIUtils.areStacksSameType(heldStack, transferStack)) continue;
            this.clickSlot(window, transferFrom);
            if (this.fillZoneWithHeldItem(window, toZone)) continue;
            this.clickSlot(window, transferFrom);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findShiftClickDestinationSlot(dd container, int fromSlot) {
        LinkedList save = this.saveContainer(container);
        yu slot = container.b(fromSlot);
        aan stack = slot.b();
        if (stack == null) {
            return -1;
        }
        stack.a = 1;
        slot.d(stack.k());
        LinkedList compareBefore = this.saveContainer(container);
        container.a(fromSlot, 0, true, (yw)NEIUtils.getMinecraft().h);
        LinkedList compareAfter = this.saveContainer(container);
        try {
            if (compareAfter.get(fromSlot) != null) {
                return -1;
            }
            int i2 = 0;
            while (i2 < compareBefore.size()) {
                if (i2 != fromSlot && !NEIUtils.areStacksIdentical((aan)compareBefore.get(i2), (aan)compareAfter.get(i2)) && compareAfter.get(i2) != null && (compareBefore.get(i2) == null && NEIUtils.areStacksSameType(stack, (aan)compareAfter.get(i2)) || NEIUtils.areStacksSameType(stack, (aan)compareAfter.get(i2)) && ((aan)compareAfter.get((int)i2)).a - ((aan)compareBefore.get((int)i2)).a > 0)) {
                    int n2 = i2;
                    return n2;
                }
                ++i2;
            }
            return -1;
        }
        finally {
            this.restoreContainer(container, save);
        }
    }

    public LinkedList saveContainer(dd container) {
        LinkedList<aan> stacks = new LinkedList<aan>();
        int i2 = 0;
        while (i2 < container.e.size()) {
            stacks.add(NEIUtils.copyStack(container.b(i2).b()));
            ++i2;
        }
        return stacks;
    }

    public void restoreContainer(dd container, LinkedList items) {
        int i2 = 0;
        while (i2 < container.e.size()) {
            container.b(i2).d((aan)items.get(i2));
            ++i2;
        }
    }

    public void transferItem(gb window, int fromSlot) {
        int toSlot = this.findShiftClickDestinationSlot(window.d, fromSlot);
        if (toSlot == -1) {
            return;
        }
        if (!window.d.b(fromSlot).a(null)) {
            this.moveOutputSet(window, fromSlot, toSlot);
        } else {
            this.moveOneItem(window, fromSlot, toSlot);
        }
    }

    public void moveOutputSet(gb window, int fromSlot, int toSlot) {
        if (NEIUtils.getHeldItem() != null) {
            return;
        }
        this.clickSlot(window, fromSlot);
        this.clickSlot(window, toSlot);
    }

    public void moveOneItem(gb window, int fromSlot, int toSlot) {
        this.clickSlot(window, fromSlot);
        this.clickSlot(window, toSlot, 1);
        this.clickSlot(window, fromSlot);
    }

    public void retrieveItem(gb window, int toSlot) {
        yu slot = window.d.b(toSlot);
        aan slotStack = slot.b();
        if (slotStack == null || slotStack.a == slot.a() || slotStack.a == slotStack.c()) {
            return;
        }
        Integer destZone = (Integer)this.slotZoneMap.get(toSlot);
        if (destZone == null) {
            return;
        }
        int firstZoneSlot = this.findShiftClickDestinationSlot(window.d, toSlot);
        int firstZone = -1;
        if (firstZoneSlot != -1 && this.retrieveItemFromZone(window, firstZone = ((Integer)this.slotZoneMap.get(firstZoneSlot)).intValue(), toSlot)) {
            return;
        }
        int zone = 0;
        while (zone < this.slotZones.size()) {
            if (zone != destZone && zone != firstZone && this.retrieveItemFromZone(window, zone, toSlot)) {
                return;
            }
            ++zone;
        }
        this.retrieveItemFromZone(window, destZone, toSlot);
    }

    private boolean retrieveItemFromZone(gb window, int zone, int toSlot) {
        yu slot;
        aan stack1;
        int i2;
        aan stack = window.d.b(toSlot).b();
        Iterator iterator = ((LinkedList)this.slotZones.get(zone)).iterator();
        while (iterator.hasNext()) {
            i2 = (Integer)iterator.next();
            if (i2 == toSlot || !NEIUtils.areStacksSameType(stack, stack1 = (slot = window.d.b(i2)).b()) || stack1.a == slot.a() || stack1.a == stack1.c()) continue;
            this.moveOneItem(window, i2, toSlot);
            return true;
        }
        iterator = ((LinkedList)this.slotZones.get(zone)).iterator();
        while (iterator.hasNext()) {
            i2 = (Integer)iterator.next();
            if (i2 == toSlot || !NEIUtils.areStacksSameType(stack, stack1 = (slot = window.d.b(i2)).b())) continue;
            this.moveOneItem(window, i2, toSlot);
            return true;
        }
        return false;
    }

    public void clickSlot(gb window, int slotIndex) {
        this.clickSlot(window, slotIndex, 0);
    }

    public void clickSlot(gb window, int slotIndex, int button) {
        this.clickSlot(window, slotIndex, button, false);
    }

    public void clickSlot(gb window, int slotIndex, int button, boolean shift) {
        window.clickSlot(null, slotIndex, button, shift);
    }

    public boolean fillZoneWithHeldItem(gb window, int zoneIndex) {
        aan inToSlot;
        aan held;
        int transferTo;
        Iterator iterator = ((LinkedList)this.slotZones.get(zoneIndex)).iterator();
        while (iterator.hasNext()) {
            transferTo = (Integer)iterator.next();
            held = NEIUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.d.b(transferTo).b();
            if (!NEIUtils.areStacksSameType(inToSlot, held)) continue;
            this.clickSlot(window, transferTo);
        }
        iterator = ((LinkedList)this.slotZones.get(zoneIndex)).iterator();
        while (iterator.hasNext()) {
            transferTo = (Integer)iterator.next();
            held = NEIUtils.getHeldItem();
            if (held == null) break;
            inToSlot = window.d.b(transferTo).b();
            if (inToSlot != null) continue;
            this.clickSlot(window, transferTo);
        }
        return NEIUtils.getHeldItem() == null;
    }

    public void throwAll(gb window, int pickedUpFromSlot) {
        aan held = NEIUtils.getHeldItem();
        if (held == null) {
            return;
        }
        this.clickSlot(window, -999);
        Iterator iterator = ((LinkedList)this.slotZones.get((Integer)this.slotZoneMap.get(pickedUpFromSlot))).iterator();
        while (iterator.hasNext()) {
            int slotIndex = (Integer)iterator.next();
            yu slot = window.d.b(slotIndex);
            if (!NEIUtils.areStacksSameType(held, slot.b())) continue;
            this.clickSlot(window, slotIndex);
            this.clickSlot(window, -999);
        }
    }

    public static class SlotPositionComparator
    implements Comparator {
        dd container;

        public SlotPositionComparator(dd c2) {
            this.container = c2;
        }

        public int compare(Integer arg0, Integer arg1) {
            yu slot1 = this.container.b(arg0.intValue());
            yu slot2 = this.container.b(arg1.intValue());
            if (slot2.e != slot1.e) {
                return slot1.e - slot2.e;
            }
            return slot1.d - slot2.d;
        }
    }
}

