/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.GuiManager;
import codechicken.nei.Image;
import codechicken.nei.NEIConfig;
import codechicken.nei.NEIController;
import codechicken.nei.Widget;
import org.lwjgl.opengl.GL11;

public class Button
extends Widget {
    public String label;
    public String identifier;
    public Image icon;
    public boolean iconHighlight;
    public int state;
    public static final Image stateOff = new Image(48, 0, 8, 12);
    public static final Image stateOn = new Image(56, 0, 8, 12);
    public static final Image stateDisabled = new Image(64, 0, 8, 12);

    public Button(String s, String ident) {
        this.label = s;
        this.identifier = ident;
    }

    public Button(String ident) {
        this.label = "";
        this.identifier = ident;
    }

    public int contentWidth(GuiManager gui) {
        int textw;
        int n2 = textw = this.getRenderIcon() == null ? gui.getTextWidth(this.label) : this.getRenderIcon().width;
        if (NEIConfig.getLayoutStyle() == 0) {
            textw += 4;
        } else if ((this.state & 4) != 0) {
            textw += Button.stateOff.width;
        }
        return textw;
    }

    public void setOwnWidth(GuiManager gui) {
        this.width = this.contentWidth(gui) + this.getMargin();
    }

    public int getMargin() {
        return 2;
    }

    @Override
    public void draw(GuiManager gui, int mousex, int mousey) {
        boolean mouseover = this.contains(mousex, mousey);
        Image renderIcon = this.getRenderIcon();
        if (NEIConfig.getLayoutStyle() == 1) {
            int cwidth = this.contentWidth(gui);
            int textx = this.x + (this.width - cwidth) / 2;
            int texty = this.y + (this.height - 8) / 2;
            gui.drawRect(this.x, this.y, this.width, this.height, this.contains(mousex, mousey) ? -297791480 : -301989888);
            if (renderIcon == null) {
                gui.drawText(textx, texty, this.label, -1);
            } else {
                int icony = this.y + (this.height - renderIcon.height) / 2;
                gui.drawIcon(textx, icony, renderIcon);
                if ((this.state & 3) == 2) {
                    gui.drawRect(textx, icony, renderIcon.width, renderIcon.height, Integer.MIN_VALUE);
                }
                if ((this.state & 4) != 0) {
                    Image stateimage = (this.state & 3) == 1 ? stateOn : ((this.state & 3) == 2 ? stateDisabled : stateOff);
                    gui.drawIcon(textx + renderIcon.width, icony, stateimage);
                }
            }
        } else {
            GL11.glDisable((int)2896);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int tex = (this.state & 3) == 1 ? 2 : ((this.state & 3) == 2 ? 0 : 1);
            gui.drawButtonBackground(this.x, this.y, this.width, this.height, true, tex);
            if (renderIcon == null) {
                if (mouseover && (this.state & 3) != 2 || (this.state & 3) == 1) {
                    gui.drawTextCentered(this.label, this.x + this.width / 2, this.y + (this.height - 8) / 2, 0xFFFFA0);
                } else if ((this.state & 3) == 2) {
                    gui.drawTextCentered(this.label, this.x + this.width / 2, this.y + (this.height - 8) / 2, 0x601010);
                } else {
                    gui.drawTextCentered(this.label, this.x + this.width / 2, this.y + (this.height - 8) / 2, 0xE0E0E0);
                }
            } else {
                if (!this.iconHighlight) {
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                int iconx = this.x + (this.width - this.icon.width) / 2;
                int icony = this.y + (this.height - this.icon.height) / 2;
                gui.drawIcon(iconx, icony, renderIcon);
            }
        }
    }

    @Override
    public boolean handleClick(int i2, int j2, int k) {
        if (k == 1 || k == 0) {
            NEIController.onButtonPress(this.identifier, k == 1);
        }
        return true;
    }

    public Image getRenderIcon() {
        return this.icon;
    }
}

