/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.API;
import codechicken.nei.GuiManager;
import codechicken.nei.MultiItemRange;
import codechicken.nei.NEIUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.lwjgl.opengl.GL11;

public class BrewingRecipeHandler
extends TemplateRecipeHandler {
    public static final HashSet ingredientIDs = new HashSet();
    public static final HashSet apotions = new HashSet();

    @Override
    public String getRecipeName() {
        return "Brewing";
    }

    @Override
    public void loadCraftingRecipes(aan result) {
        if (result.c != yr.bs.bQ) {
            return;
        }
        int damage = result.i();
        for (CachedBrewingRecipe recipe : apotions) {
            if (recipe.result.item.i() != damage) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public void loadUsageRecipes(aan ingredient) {
        if (ingredient.c != yr.bs.bQ && !ingredientIDs.contains(ingredient.c)) {
            return;
        }
        for (CachedBrewingRecipe recipe : apotions) {
            if (!NEIUtils.areStacksSameType(recipe.ingredient.item, ingredient) && !NEIUtils.areStacksSameType(recipe.precursorPotion.item, ingredient)) continue;
            this.arecipes.add(recipe);
        }
    }

    @Override
    public String getGuiTexture() {
        return "/gui/alchemy.png";
    }

    public void drawForegrounda(GuiManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.bindTextureByName("/gui/alchemy.png");
        int t2 = this.cycleticks % 120 / 4;
        gui.drawTexturedModalRect(92, 5, 176, 0, 8, t2 + 1);
        t2 = this.cycleticks % 35;
        gui.drawTexturedModalRect(60, 33 - t2, 185, 31 - t2, 12, t2 - 1);
    }

    public void searchPotions() {
        HashSet newPotions;
        TreeSet<Integer> allPotions = new TreeSet<Integer>();
        HashSet<Integer> nextLevelPotions = new HashSet<Integer>();
        nextLevelPotions.add(0);
        do {
            newPotions = new HashSet();
            for (Integer basePotionID : nextLevelPotions) {
                if (ei.c((int)basePotionID)) continue;
                for (Integer ingredID : ingredientIDs) {
                    int result = hx.a((int)basePotionID, (String)yr.e[ingredID].o());
                    if (ei.c((int)result)) {
                        this.addPotion(ingredID, basePotionID, result, allPotions, newPotions);
                        continue;
                    }
                    List baseMods = yr.bs.e_(basePotionID.intValue());
                    List newMods = yr.bs.e_(result);
                    if (basePotionID > 0 && baseMods == newMods || baseMods != null && (baseMods.equals(newMods) || newMods == null) || basePotionID == result || this.levelModifierChanged(basePotionID, result)) continue;
                    this.addPotion(ingredID, basePotionID, result, allPotions, newPotions);
                }
            }
        } while ((nextLevelPotions = newPotions).size() > 0);
        allPotions.add(0);
        API.setItemDamageVariants(yr.bs.bQ, allPotions);
        API.addSetRange("Vanilla.Items.Potions", new MultiItemRange().add((yr)yr.bs));
        API.addSetRange("Vanilla.Items.Potions.Splash", new MultiItemRange().add((yr)yr.bs, 16384, 32768));
        MultiItemRange positivepots = new MultiItemRange();
        MultiItemRange negativepots = new MultiItemRange();
        MultiItemRange neutralpots = new MultiItemRange();
        Iterator iterator = allPotions.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2;
            int potionID = (Integer)iterator.next();
            List effectlist = yr.bs.e_(potionID);
            int type = 0;
            if (effectlist != null && !effectlist.isEmpty() && (iterator2 = effectlist.iterator()).hasNext()) {
                alg potioneffect = (alg)iterator2.next();
                type = aad.a[potioneffect.a()].f() ? -1 : 1;
            }
            if (type == 0) {
                neutralpots.add((yr)yr.bs, potionID, potionID);
                continue;
            }
            if (type == 1) {
                positivepots.add((yr)yr.bs, potionID, potionID);
                continue;
            }
            if (type != -1) continue;
            negativepots.add((yr)yr.bs, potionID, potionID);
        }
        API.addSetRange("Items.Potions.Positive", positivepots);
        API.addSetRange("Items.Potions.Negative", negativepots);
        API.addSetRange("Items.Potions.Neutral", neutralpots);
    }

    private boolean levelModifierChanged(int basePotionID, int result) {
        int basemod = basePotionID & 0xE0;
        int resultmod = result & 0xE0;
        return basemod != 0 && basemod != resultmod;
    }

    private void addPotion(int ingred, int basePotion, int result, TreeSet allPotions, HashSet newPotions) {
        apotions.add(new CachedBrewingRecipe(ingred, basePotion, result));
        if (allPotions.add(result)) {
            newPotions.add(result);
        }
    }

    @Override
    public String getOverlayIdentifier() {
        return "brewing";
    }

    public class CachedBrewingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        int hashcode;
        PositionedStack precursorPotion;
        PositionedStack result;
        PositionedStack ingredient;

        public CachedBrewingRecipe(int ingredID, int basePotionID, int resultDamage) {
            super(BrewingRecipeHandler.this);
            this.precursorPotion = new PositionedStack(new aan(yr.bs.bQ, 1, basePotionID), 51, 35);
            this.ingredient = new PositionedStack(new aan(ingredID, 1, 0), 74, 6);
            this.result = new PositionedStack(new aan(yr.bs.bQ, 1, resultDamage), 97, 35);
            this.calculateHashcode();
        }

        @Override
        public PositionedStack getResult() {
            return this.result;
        }

        @Override
        public ArrayList getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(this.ingredient);
            recipestacks.add(this.precursorPotion);
            return recipestacks;
        }

        private void calculateHashcode() {
            this.hashcode = this.result.item.i() << 16 + this.precursorPotion.item.i();
            this.hashcode = 31 * this.hashcode + (this.ingredient.item.c << 16 + this.ingredient.item.i());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CachedBrewingRecipe)) {
                return false;
            }
            CachedBrewingRecipe recipe2 = (CachedBrewingRecipe)obj;
            return this.result.item.i() == recipe2.result.item.i() && this.precursorPotion.item.i() == recipe2.precursorPotion.item.i() && NEIUtils.areStacksSameType(this.ingredient.item, recipe2.ingredient.item);
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

