/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ReflectionManager {
    public static HashMap primitiveWrappers = new HashMap();

    static {
        primitiveWrappers.put(Integer.TYPE, Integer.class);
        primitiveWrappers.put(Short.TYPE, Short.class);
        primitiveWrappers.put(Byte.TYPE, Byte.class);
        primitiveWrappers.put(Long.TYPE, Long.class);
        primitiveWrappers.put(Double.TYPE, Double.class);
        primitiveWrappers.put(Float.TYPE, Float.class);
        primitiveWrappers.put(Boolean.TYPE, Boolean.class);
        primitiveWrappers.put(Character.TYPE, Character.class);
    }

    public static boolean isInstance(Class class1, Object obj) {
        Class primitive = (Class)primitiveWrappers.get(class1);
        if (primitive != null) {
            if (primitive == Long.class && Long.class.isInstance(obj)) {
                return true;
            }
            if ((primitive == Long.class || primitive == Integer.class) && Integer.class.isInstance(obj)) {
                return true;
            }
            if ((primitive == Long.class || primitive == Integer.class || primitive == Short.class) && Short.class.isInstance(obj)) {
                return true;
            }
            if ((primitive == Long.class || primitive == Integer.class || primitive == Short.class || primitive == Byte.class) && Integer.class.isInstance(obj)) {
                return true;
            }
            if (primitive == Double.class && Double.class.isInstance(obj)) {
                return true;
            }
            if ((primitive == Double.class || primitive == Float.class) && Float.class.isInstance(obj)) {
                return true;
            }
            return primitive.isInstance(obj);
        }
        return class1.isInstance(obj);
    }

    public static Class findClass(String name) {
        return ReflectionManager.findClass(name, true);
    }

    public static boolean classExists(String name) {
        return ReflectionManager.findClass(name, false) != null;
    }

    public static Class findClass(String name, boolean init) {
        try {
            return Class.forName(name, init, ReflectionManager.class.getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            try {
                return Class.forName("net.minecraft.src." + name, init, ReflectionManager.class.getClassLoader());
            }
            catch (ClassNotFoundException cnfe2) {
                return null;
            }
        }
    }

    public static BaseMod getMod(String name) {
        for (BaseMod obj : ModLoader.getLoadedMods()) {
            BaseMod mod = obj;
            if (!mod.getName().equals(name)) continue;
            return mod;
        }
        return null;
    }

    public static void setField(Class class1, Object instance, String name, Object value) throws IllegalArgumentException, IllegalAccessException {
        ReflectionManager.setField(class1, instance, new String[]{name}, value);
    }

    public static void setField(Class class1, Object instance, String[] names, Object value) throws IllegalArgumentException, IllegalAccessException {
        Field[] fieldArray = class1.getDeclaredFields();
        int n2 = fieldArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Field field = fieldArray[n3];
            boolean match = false;
            String[] stringArray = names;
            int n4 = names.length;
            int n5 = 0;
            while (n5 < n4) {
                String name = stringArray[n5];
                if (field.getName().equals(name)) {
                    match = true;
                    break;
                }
                ++n5;
            }
            if (match) {
                field.setAccessible(true);
                field.set(instance, value);
                return;
            }
            ++n3;
        }
    }

    public static void setField(Class class1, Object instance, int fieldindex, Object value) throws IllegalArgumentException, IllegalAccessException {
        Field field = class1.getDeclaredFields()[fieldindex];
        field.setAccessible(true);
        field.set(instance, value);
    }

    public static void callMethod(Class class1, String name, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ReflectionManager.callMethod(class1, null, new String[]{name}, params);
    }

    public static void callMethod(Class class1, String[] names, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ReflectionManager.callMethod(class1, null, names, params);
    }

    public static void callMethod(Class class1, Object instance, String name, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ReflectionManager.callMethod(class1, null, instance, new String[]{name}, params);
    }

    public static void callMethod(Class class1, Object instance, String[] names, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ReflectionManager.callMethod(class1, null, instance, names, params);
    }

    public static Object callMethod(Class class1, Class returntype, String[] names, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return ReflectionManager.callMethod(class1, returntype, null, names, params);
    }

    public static Object callMethod(Class class1, Class returntype, Object instance, String[] names, Object ... params) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method[] methodArray = class1.getDeclaredMethods();
        int n2 = methodArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block6: {
                Class<?>[] paramtypes;
                Method method = methodArray[n3];
                boolean match = false;
                String[] stringArray = names;
                int n4 = names.length;
                int n5 = 0;
                while (n5 < n4) {
                    String name = stringArray[n5];
                    if (method.getName().equals(name)) {
                        match = true;
                        break;
                    }
                    ++n5;
                }
                if (match && (paramtypes = method.getParameterTypes()).length == params.length) {
                    int i2 = 0;
                    while (i2 < params.length) {
                        if (ReflectionManager.isInstance(paramtypes[i2], params[i2])) {
                            ++i2;
                            continue;
                        }
                        break block6;
                    }
                    method.setAccessible(true);
                    return method.invoke(instance, params);
                }
            }
            ++n3;
        }
        return null;
    }

    public static Object getField(Class class1, Class fieldType, Object instance, int fieldIndex) throws IllegalArgumentException, IllegalAccessException {
        Field field = class1.getDeclaredFields()[fieldIndex];
        field.setAccessible(true);
        return field.get(instance);
    }

    public static Object newInstance(Class class1, Object ... params) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructorArray = class1.getDeclaredConstructors();
        int n2 = constructorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block4: {
                Constructor<?> constructor = constructorArray[n3];
                Class<?>[] paramtypes = constructor.getParameterTypes();
                if (paramtypes.length == params.length) {
                    int i2 = 0;
                    while (i2 < params.length) {
                        if (ReflectionManager.isInstance(paramtypes[i2], params[i2])) {
                            ++i2;
                            continue;
                        }
                        break block4;
                    }
                    constructor.setAccessible(true);
                    return constructor.newInstance(params);
                }
            }
            ++n3;
        }
        return null;
    }

    public static boolean hasField(Class class1, String fieldName) {
        try {
            class1.getDeclaredField("fieldName");
            return true;
        }
        catch (NoSuchFieldException nfe) {
            return false;
        }
    }
}

