/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.Vector3;
import java.util.Formatter;
import java.util.Locale;

public class Quat {
    public double x;
    public double y;
    public double z;
    public double s;
    public static final double SQRT2 = Math.sqrt(2.0);

    public Quat() {
        this.s = 1.0;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Quat(Quat quat) {
        this.x = quat.x;
        this.y = quat.y;
        this.z = quat.z;
        this.s = quat.s;
    }

    public Quat(double d2, double d1, double d22, double d3) {
        this.x = d1;
        this.y = d22;
        this.z = d3;
        this.s = d2;
    }

    public void set(Quat quat) {
        this.x = quat.x;
        this.y = quat.y;
        this.z = quat.z;
        this.s = quat.s;
    }

    public static Quat aroundAxis(double ax, double ay, double az2, double angle) {
        double d4 = Math.sin(angle *= 0.5);
        return new Quat(Math.cos(angle), ax * d4, ay * d4, az2 * d4);
    }

    public void multiply(Quat quat) {
        double d2 = this.s * quat.s - this.x * quat.x - this.y * quat.y - this.z * quat.z;
        double d1 = this.s * quat.x + this.x * quat.s - this.y * quat.z + this.z * quat.y;
        double d22 = this.s * quat.y + this.x * quat.z + this.y * quat.s - this.z * quat.x;
        double d3 = this.s * quat.z - this.x * quat.y + this.y * quat.x + this.z * quat.s;
        this.s = d2;
        this.x = d1;
        this.y = d22;
        this.z = d3;
    }

    public void rightMultiply(Quat quat) {
        double d2 = this.s * quat.s - this.x * quat.x - this.y * quat.y - this.z * quat.z;
        double d1 = this.s * quat.x + this.x * quat.s + this.y * quat.z - this.z * quat.y;
        double d22 = this.s * quat.y - this.x * quat.z + this.y * quat.s + this.z * quat.x;
        double d3 = this.s * quat.z + this.x * quat.y - this.y * quat.x + this.z * quat.s;
        this.s = d2;
        this.x = d1;
        this.y = d22;
        this.z = d3;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.s * this.s);
    }

    public void normalize() {
        double d2 = this.mag();
        if (d2 == 0.0) {
            return;
        }
        d2 = 1.0 / d2;
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        this.s *= d2;
    }

    public void rotate(Vector3 vec) {
        double d2 = -this.x * vec.x - this.y * vec.y - this.z * vec.z;
        double d1 = this.s * vec.x + this.y * vec.z - this.z * vec.y;
        double d22 = this.s * vec.y - this.x * vec.z + this.z * vec.x;
        double d3 = this.s * vec.z + this.x * vec.y - this.y * vec.x;
        vec.x = d1 * this.s - d2 * this.x - d22 * this.z + d3 * this.y;
        vec.y = d22 * this.s - d2 * this.y + d1 * this.z - d3 * this.x;
        vec.z = d3 * this.s - d2 * this.z - d1 * this.y + d22 * this.x;
    }

    public String toString() {
        StringBuilder stringbuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringbuilder, Locale.US);
        formatter.format("Quaternion:\n", new Object[0]);
        formatter.format("  < %f %f %f %f >\n", this.s, this.x, this.y, this.z);
        return stringbuilder.toString();
    }

    public static Quat aroundAxis(Vector3 axis, double angle) {
        return Quat.aroundAxis(axis.x, axis.y, axis.z, angle);
    }
}

