/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.ConfigFile;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.TreeMap;

public class ConfigTag {
    public ConfigFile parentfile;
    public ConfigTag parenttag;
    public TreeMap childtags = new TreeMap();
    public String name;
    public String qualifiedname;
    public String comment;
    public String value;
    public boolean brace;
    public boolean newline;
    public int position = Integer.MAX_VALUE;

    public ConfigTag(ConfigTag parent, String name) {
        this.parenttag = parent;
        this.parentfile = parent.parentfile;
        this.name = name;
        this.qualifiedname = String.valueOf(parent.qualifiedname) + "." + name;
        parent.childtags.put(name, this);
    }

    public ConfigTag(ConfigFile parent, String name) {
        this.parentfile = parent;
        this.name = name;
        this.qualifiedname = name;
        this.parentfile.maintags.put(name, this);
        this.newline = parent.newlinemode == 2;
    }

    public ConfigTag getTag(String tagname, boolean createnew) {
        int dotpos = (tagname = tagname.replace('_', ' ')).indexOf(".");
        String maintagname = dotpos == -1 ? tagname : tagname.substring(0, dotpos);
        ConfigTag basetag = (ConfigTag)this.childtags.get(maintagname);
        if (basetag == null) {
            if (!createnew) {
                return null;
            }
            basetag = this.getNewTag(maintagname);
            this.parentfile.saveConfig();
        }
        if (dotpos == -1) {
            return basetag;
        }
        return basetag.getTag(tagname.substring(dotpos + 1));
    }

    public ConfigTag getTag(String tagname) {
        return this.getTag(tagname, true);
    }

    public ConfigTag getNewTag(String name) {
        return new ConfigTag(this, name);
    }

    public boolean tagExists(String tagname) {
        return this.getTag(tagname, false) != null;
    }

    public boolean deleteTag(String tagname) {
        String lastpart;
        ConfigTag tag = this.getTag(tagname, false);
        if (tag == null) {
            return false;
        }
        int dotpos = tagname.lastIndexOf(".");
        String string = lastpart = dotpos == -1 ? tagname : tagname.substring(dotpos + 1, tagname.length());
        if (tag.parenttag != null) {
            return tag.parenttag.childtags.remove(lastpart) != null;
        }
        if (tag.parentfile != null) {
            return tag.parentfile.maintags.remove(lastpart) != null;
        }
        return false;
    }

    public void setValue(String value) {
        this.value = value;
        this.parentfile.saveConfig();
    }

    public void setDefaultValue(String defaultvalue) {
        if (this.value == null) {
            this.value = defaultvalue;
            this.parentfile.saveConfig();
        }
    }

    public void setIntValue(int i2) {
        this.setValue(Integer.toString(i2));
    }

    public void setBooleanValue(boolean b) {
        this.setValue(Boolean.toString(b));
    }

    public void setHexValue(int i2) {
        this.setValue(Long.toString((long)i2 << 32 >>> 32, 16));
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String defaultvalue) {
        this.setDefaultValue(defaultvalue);
        return this.value;
    }

    public int getIntValue() {
        return Integer.parseInt(this.getValue());
    }

    public int getIntValue(int defaultvalue) {
        if (this.value == null) {
            this.setIntValue(defaultvalue);
        }
        try {
            return this.getIntValue();
        }
        catch (NumberFormatException nfe) {
            this.setIntValue(defaultvalue);
            return this.getIntValue();
        }
    }

    public boolean getBooleanValue() {
        String value = this.getValue();
        if (value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"))) {
            return true;
        }
        if (value != null && (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no"))) {
            return false;
        }
        throw new NumberFormatException(String.valueOf(this.qualifiedname) + ".value=" + value);
    }

    public boolean getBooleanValue(boolean defaultvalue) {
        if (this.value == null) {
            this.setBooleanValue(defaultvalue);
        }
        try {
            return this.getBooleanValue();
        }
        catch (NumberFormatException nfe) {
            this.setBooleanValue(defaultvalue);
            return this.getBooleanValue();
        }
    }

    public int getHexValue() {
        return (int)Long.parseLong(this.getValue(), 16);
    }

    public int getHexValue(int defaultvalue) {
        if (this.value == null) {
            this.setHexValue(defaultvalue);
        }
        try {
            return this.getHexValue();
        }
        catch (NumberFormatException nfe) {
            this.setHexValue(defaultvalue);
            return this.getHexValue();
        }
    }

    public void save(FileOutputStream fout, int tabs, String bracequalifier) {
        String unqualifiedname = this.qualifiedname;
        unqualifiedname = unqualifiedname.replace(' ', '_');
        if (this.qualifiedname.contains(".") && !bracequalifier.equals("")) {
            unqualifiedname = this.qualifiedname.substring(bracequalifier.length() + 1).replace(' ', '_');
        }
        if (this.newline) {
            ConfigFile.writeLine(fout, "", tabs);
        }
        if (this.comment != null && !this.comment.equals("")) {
            String doubledelimcomment = this.comment.replace("::", "~|~");
            String[] comments = doubledelimcomment.split(":");
            int i2 = 0;
            while (i2 < comments.length) {
                comments[i2] = comments[i2].replace("~|~", ":");
                ConfigFile.writeLine(fout, "#" + comments[i2], tabs);
                ++i2;
            }
        }
        if (this.value != null) {
            ConfigFile.writeLine(fout, String.valueOf(unqualifiedname) + "=" + this.value, tabs);
        }
        if (this.brace && this.childtags.size() > 0) {
            ConfigFile.writeLine(fout, unqualifiedname, tabs);
            ConfigFile.writeLine(fout, "{", tabs);
            ConfigFile.saveTagTree(fout, this.childtags, tabs + 1, this.qualifiedname.replace(' ', '_'));
            ConfigFile.writeLine(fout, "}", tabs);
        } else if (this.childtags.size() > 0) {
            ConfigFile.saveTagTree(fout, this.childtags, tabs, bracequalifier);
        }
    }

    public ConfigTag setNewLine(boolean b) {
        this.newline = b;
        this.parentfile.saveConfig();
        return this;
    }

    public ConfigTag useBraces() {
        this.brace = true;
        if (this.parenttag == null && this.parentfile.newlinemode == 1) {
            this.newline = true;
        }
        this.parentfile.saveConfig();
        return this;
    }

    public ConfigTag setComment(String string) {
        this.comment = string;
        this.parentfile.saveConfig();
        return this;
    }

    public ConfigTag setPosition(int pos) {
        this.position = pos;
        this.parentfile.saveConfig();
        return this;
    }

    public void loadChildren(FileInputStream fin) {
        String comment = "";
        String bracequalifier = "";
        try {
            while (fin.available() != 0) {
                String line = ConfigFile.readLine(fin);
                if (line.startsWith("#")) {
                    if (comment == null || comment.equals("")) {
                        comment = line.substring(1);
                        continue;
                    }
                    comment = String.valueOf(comment) + ":" + line.substring(1);
                    continue;
                }
                if (line.contains("=")) {
                    String qualifiedname = line.substring(0, line.indexOf("="));
                    this.getTag(qualifiedname).setComment(comment).setValue(line.substring(line.indexOf("=") + 1));
                    comment = "";
                    bracequalifier = qualifiedname;
                    continue;
                }
                if (line.equals("{")) {
                    this.getTag(bracequalifier).setComment(comment).useBraces().loadChildren(fin);
                    comment = "";
                    bracequalifier = "";
                    continue;
                }
                if (line.equals("}")) {
                    return;
                }
                bracequalifier = line;
            }
        }
        catch (IOException e) {
            ModLoader.throwException("Code Chicken Core", e);
        }
    }
}

