/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.ConfigTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

public class ConfigFile {
    public File file;
    public TreeMap maintags;
    public String comment;
    public int newlinemode = 2;
    public static boolean loading;
    public static final byte[] lineend;

    static {
        lineend = new byte[]{13, 10};
    }

    public ConfigFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                ModLoader.throwException("Code Chicken Core", e);
            }
        }
        this.file = file;
        this.maintags = new TreeMap();
        this.loadConfig();
    }

    private void loadConfig() {
        FileInputStream fin;
        loading = true;
        try {
            fin = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            ModLoader.throwException("Code Chicken Core", e);
            return;
        }
        String comment = "";
        String bracequalifier = "";
        boolean readingheader = true;
        try {
            while (fin.available() != 0) {
                boolean headerline = false;
                String line = ConfigFile.readLine(fin);
                if (line.startsWith("#")) {
                    if (readingheader) {
                        this.comment = comment == null || comment.equals("") ? line.substring(1) : String.valueOf(this.comment) + ":" + line.substring(1);
                        headerline = true;
                    } else {
                        comment = comment == null || comment.equals("") ? line.substring(1) : String.valueOf(comment) + ":" + line.substring(1);
                    }
                } else if (line.contains("=")) {
                    String qualifiedname = line.substring(0, line.indexOf("="));
                    this.getTag(qualifiedname).setComment(comment).setValue(line.substring(line.indexOf("=") + 1));
                    comment = "";
                    bracequalifier = qualifiedname;
                } else if (line.equals("{")) {
                    this.getTag(bracequalifier).setComment(comment).useBraces().loadChildren(fin);
                    comment = "";
                    bracequalifier = "";
                } else if (line.equals("")) {
                    comment = "";
                    bracequalifier = "";
                } else {
                    bracequalifier = line;
                }
                if (headerline) continue;
                readingheader = false;
            }
            fin.close();
        }
        catch (IOException e) {
            ModLoader.throwException("Code Chicken Core", e);
        }
        loading = false;
    }

    public static String readLine(FileInputStream fin) {
        byte[] data = new byte[1024];
        int numbytes = 0;
        int lastbyte = 0;
        while (true) {
            try {
                while (true) {
                    int databyte;
                    if ((databyte = fin.read()) == -1) {
                        return ConfigFile.formatLine(new String(data, 0, numbytes, "US-ASCII"));
                    }
                    if (lastbyte == 13 && databyte == 10) {
                        return ConfigFile.formatLine(new String(data, 0, numbytes - 1, "US-ASCII"));
                    }
                    lastbyte = databyte;
                    data[numbytes] = (byte)databyte;
                    ++numbytes;
                }
            }
            catch (IOException e) {
                ModLoader.throwException("Code Chicken Core", e);
                continue;
            }
            break;
        }
    }

    public static String formatLine(String line) {
        if ((line = line.replace("\t", "")).startsWith("#")) {
            return line;
        }
        if (line.contains("=")) {
            line = String.valueOf(line.substring(0, line.indexOf("=")).replace(" ", "")) + line.substring(line.indexOf("="));
            return line;
        }
        line = line.replace(" ", "");
        return line;
    }

    public static void writeLine(FileOutputStream fout, String line, int tabs) {
        try {
            int i2 = 0;
            while (i2 < tabs) {
                fout.write(9);
                ++i2;
            }
            byte[] data = line.getBytes("US-ASCII");
            fout.write(data);
            fout.write(lineend);
        }
        catch (IOException e) {
            ModLoader.throwException("Code Chicken Core", e);
        }
    }

    public ConfigTag getTag(String tagname, boolean createnew) {
        int dotpos = (tagname = tagname.replace('_', ' ')).indexOf(".");
        String basetagname = dotpos == -1 ? tagname : tagname.substring(0, dotpos);
        ConfigTag basetag = (ConfigTag)this.maintags.get(basetagname);
        if (basetag == null) {
            if (!createnew) {
                return null;
            }
            basetag = this.getNewTag(basetagname);
            this.saveConfig();
        }
        if (dotpos == -1) {
            return basetag;
        }
        return basetag.getTag(tagname.substring(dotpos + 1), createnew);
    }

    public ConfigTag getTag(String tagname) {
        return this.getTag(tagname, true);
    }

    public boolean containsTag(String tagname) {
        return this.getTag(tagname, false) != null;
    }

    public boolean removeTag(String tagname) {
        String lastpart;
        ConfigTag tag = this.getTag(tagname, false);
        if (tag == null) {
            return false;
        }
        int dotpos = tagname.lastIndexOf(".");
        String string = lastpart = dotpos == -1 ? tagname : tagname.substring(dotpos + 1, tagname.length());
        if (tag.parenttag != null) {
            return tag.parenttag.childtags.remove(lastpart) != null;
        }
        if (tag.parentfile != null) {
            return tag.parentfile.maintags.remove(lastpart) != null;
        }
        return false;
    }

    public ConfigTag getNewTag(String tagname) {
        return new ConfigTag(this, tagname);
    }

    public void saveConfig() {
        FileOutputStream fout;
        if (loading) {
            return;
        }
        try {
            fout = new FileOutputStream(this.file);
        }
        catch (FileNotFoundException e) {
            ModLoader.throwException("Code Chicken Core", e);
            return;
        }
        if (this.comment != null && !this.comment.equals("")) {
            String doubledelimcomment = this.comment.replace("::", "~|~");
            String[] comments = doubledelimcomment.split(":");
            int i2 = 0;
            while (i2 < comments.length) {
                comments[i2] = comments[i2].replace("~|~", ":");
                ConfigFile.writeLine(fout, "#" + comments[i2], 0);
                ++i2;
            }
        }
        ConfigFile.writeLine(fout, "", 0);
        ConfigFile.saveTagTree(fout, this.maintags, 0, "");
        try {
            fout.close();
        }
        catch (IOException e) {
            ModLoader.throwException("Code Chicken Core", e);
        }
    }

    public ConfigFile setComment(String header) {
        this.comment = header;
        this.saveConfig();
        return this;
    }

    public static void saveTagTree(FileOutputStream fout, TreeMap tagtree, int braces, String bracequalifier) {
        ArrayList<ConfigTag> taglist = new ArrayList<ConfigTag>(tagtree.size());
        for (Map.Entry entry : tagtree.entrySet()) {
            taglist.add((ConfigTag)entry.getValue());
        }
        Collections.sort(taglist, new TagOrderComparator());
        for (ConfigTag configTag : taglist) {
            configTag.save(fout, braces, bracequalifier);
        }
    }

    public static ArrayList getSortedTagList(TreeMap tagtree) {
        ArrayList<ConfigTag> taglist = new ArrayList<ConfigTag>(tagtree.size());
        for (Map.Entry tag : tagtree.entrySet()) {
            taglist.add((ConfigTag)tag.getValue());
        }
        Collections.sort(taglist, new TagOrderComparator());
        return taglist;
    }

    public ConfigFile setNewLineMode(int mode) {
        this.newlinemode = mode;
        for (Map.Entry entry : this.maintags.entrySet()) {
            ConfigTag tag = (ConfigTag)entry.getValue();
            if (this.newlinemode == 0) {
                tag.newline = false;
                continue;
            }
            if (this.newlinemode == 1) {
                tag.newline = tag.brace;
                continue;
            }
            if (this.newlinemode != 2) continue;
            tag.newline = true;
        }
        this.saveConfig();
        return this;
    }

    public static class TagOrderComparator
    implements Comparator {
        public int compare(ConfigTag o1, ConfigTag o2) {
            if (o1.position == o2.position) {
                if (o1.brace == o2.brace) {
                    return o1.name.compareTo(o2.name);
                }
                return o1.brace ? 1 : -1;
            }
            return Integer.valueOf(o1.position).compareTo(o2.position);
        }
    }
}

