/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core;

import codechicken.core.CoreUtils;
import codechicken.core.IStringMatcher;
import codechicken.core.ReflectionManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class CommonUtils {
    private static byte[] charWidth = new byte[]{4, 2, 5, 6, 6, 6, 6, 3, 5, 5, 5, 6, 2, 6, 2, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 2, 2, 5, 6, 5, 6, 7, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 4, 6, 6, 3, 6, 6, 6, 6, 6, 5, 6, 6, 2, 6, 5, 3, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 6, 6, 6, 6, 5, 2, 5, 7, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 3, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 4, 6, 6, 3, 6, 6, 6, 6, 6, 6, 6, 7, 6, 6, 6, 2, 6, 6};
    private static Field mystMapDimension;

    static {
        try {
            mystMapDimension = aaj.class.getDeclaredField("dimension_myst");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static File getWorldBaseSaveLocation(xd world) {
        File savedir = CommonUtils.getWorldSaveLocation(world);
        if (savedir == null) {
            return null;
        }
        if (savedir.getName().contains("DIM")) {
            return savedir.getParentFile();
        }
        return savedir;
    }

    public static File getWorldSaveLocation(xd world, int dimension) {
        File basesave = CommonUtils.getWorldBaseSaveLocation(world);
        if (dimension != 0) {
            return new File(basesave, "DIM" + world.t.getSaveFolder());
        }
        return basesave;
    }

    private static File getWorldSaveLocation(xd world) {
        try {
            akp worldsaver = world.A();
            ua loader = worldsaver.a(world.t);
            if (loader instanceof aiv) {
                return (File)ReflectionManager.getField(aiv.class, File.class, loader, 3);
            }
            return null;
        }
        catch (Exception e) {
            ModLoader.throwException("Code Chicken Core", e);
            return null;
        }
    }

    public static void addLocalization(String s, String s1) {
        try {
            Properties properties = (Properties)ReflectionManager.getField(adn.class, Properties.class, adn.a(), 1);
            properties.put(s, s1);
        }
        catch (Exception e) {
            ModLoader.throwException("Code Chicken Core", e);
        }
    }

    public static String getLocalizedName(String localname, String fullname) {
        try {
            Properties properties = (Properties)ReflectionManager.getField(adn.class, Properties.class, adn.a(), 1);
            String mappedname = (String)properties.get(String.valueOf(localname) + ".name");
            if (mappedname == null || !mappedname.equals(fullname)) {
                CommonUtils.addLocalization(String.valueOf(localname) + ".name", fullname);
            }
        }
        catch (Exception e) {
            ModLoader.throwException("Code Chicken Core", e);
        }
        return localname;
    }

    public static int getDimension(xd world) {
        return world.t.g;
    }

    public static File getModsFolder() {
        return new File(CoreUtils.getMinecraftDir(), "mods");
    }

    public static ArrayList findClasses(IStringMatcher match, Class ... class1) {
        ArrayList classes = new ArrayList();
        ClassLoader loader = ModLoader.class.getClassLoader();
        try {
            CommonUtils.readFromClassPath(loader, CommonUtils.getJarFile(), match, class1, classes);
            CommonUtils.readFromModFolder(loader, CommonUtils.getModsFolder(), match, class1, classes);
        }
        catch (Exception e) {
            ModLoader.throwException("Code Chicken Core", e);
        }
        return classes;
    }

    private static File getJarFile() {
        try {
            return new File(ModLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            ModLoader.throwException("Code Chicken Core", e);
            return null;
        }
    }

    private static void addClass(ClassLoader loader, String resource, Class[] superclasses, ArrayList classlist) {
        try {
            String classname = resource.replace("\\", ".");
            classname = classname.replace("/", ".");
            classname = classname.substring(0, classname.length() - 6);
            Class<?> class1 = Class.forName(classname, true, loader);
            Class[] classArray = superclasses;
            int n2 = superclasses.length;
            int n3 = 0;
            while (n3 < n2) {
                Class superclass = classArray[n3];
                if (!superclass.isAssignableFrom(class1)) {
                    return;
                }
                ++n3;
            }
            classlist.add(class1);
        }
        catch (Throwable t2) {
            ModLoader.throwException("Code Chicken Core", t2);
        }
    }

    private static void readFromClassPath(ClassLoader loader, File file, IStringMatcher match, Class[] superclasses, ArrayList classlist) throws FileNotFoundException, IOException {
        if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
            CommonUtils.readFromZipFile(loader, file, match, superclasses, classlist);
        } else if (file.isDirectory()) {
            CommonUtils.readFromDirectory(loader, file, file, match, superclasses, classlist);
        }
    }

    private static void readFromZipFile(ClassLoader loader, File file, IStringMatcher match, Class[] superclasses, ArrayList classlist) throws IOException {
        ZipEntry zipentry;
        FileInputStream fileinputstream = new FileInputStream(file);
        ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
        while ((zipentry = zipinputstream.getNextEntry()) != null) {
            String name;
            String fullname = zipentry.getName().replace('\\', '/');
            int pos = fullname.lastIndexOf(47);
            String string = name = pos == -1 ? fullname : fullname.substring(pos + 1);
            if (zipentry.isDirectory() || !match.matches(name)) continue;
            CommonUtils.addClass(loader, fullname, superclasses, classlist);
        }
        fileinputstream.close();
    }

    private static void readFromDirectory(ClassLoader loader, File directory, File basedirectory, IStringMatcher match, Class[] superclasses, ArrayList classlist) {
        File[] fileArray = directory.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File child = fileArray[n3];
            if (child.isDirectory()) {
                CommonUtils.readFromDirectory(loader, child, basedirectory, match, superclasses, classlist);
            } else if (child.isFile() && match.matches(child.getName())) {
                CommonUtils.addClass(loader, CommonUtils.getRelativePath(basedirectory, child), superclasses, classlist);
            }
            ++n3;
        }
    }

    private static void readFromModFolder(ClassLoader loader, File file, IStringMatcher match, Class[] superclasses, ArrayList classlist) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("folder must be a Directory.");
        }
        File[] fileArray = file.listFiles();
        int n2 = fileArray.length;
        int n3 = 0;
        while (n3 < n2) {
            File child = fileArray[n3];
            if (child.isFile() && (child.getName().endsWith(".jar") || child.getName().endsWith(".zip"))) {
                CommonUtils.readFromZipFile(loader, child, match, superclasses, classlist);
            } else if (child.isDirectory()) {
                CommonUtils.readFromDirectory(loader, child, child, match, superclasses, classlist);
            }
            ++n3;
        }
    }

    public static String getRelativePath(File parent, File child) {
        if (parent.isFile() || !child.getPath().startsWith(parent.getPath())) {
            return null;
        }
        return child.getPath().substring(parent.getPath().length() + 1);
    }

    public static int getFreeBlockID(int preferred) {
        int i2 = preferred;
        while (i2 < 255) {
            if (pb.m[i2] == null) {
                return i2;
            }
            ++i2;
        }
        i2 = preferred - 1;
        while (i2 > 0) {
            if (pb.m[i2] == null) {
                return i2;
            }
            --i2;
        }
        return -1;
    }

    public static Object[] subArray(Object[] args, int i2) {
        if (i2 > args.length) {
            return (Object[])Array.newInstance(args.getClass().getComponentType(), 0);
        }
        Object[] narray = (Object[])Array.newInstance(args.getClass().getComponentType(), args.length - i2);
        System.arraycopy(args, i2, narray, 0, narray.length);
        return narray;
    }

    public static pl retraceBlock(xd world, yw entityplayer, int x, int y, int z2) {
        bo headVec = bo.b((double)entityplayer.o, (double)(entityplayer.p + 1.62 - (double)entityplayer.H), (double)entityplayer.q);
        bo lookVec = entityplayer.k(1.0f);
        double reach = CoreUtils.getBlockReachDistance(entityplayer);
        bo endVec = headVec.c(lookVec.a * reach, lookVec.b * reach, lookVec.c * reach);
        return pb.m[world.a(x, y, z2)].a(world, x, y, z2, headVec, endVec);
    }

    public static int getCharWidth(char c2) {
        if (c2 == '\u00a7') {
            return -1;
        }
        int charIndex = xn.a.indexOf(c2);
        return charIndex < 0 ? 0 : charWidth[charIndex + 32];
    }

    public static int getStringWidth(String s) {
        if (s == null) {
            return 0;
        }
        int width = 0;
        boolean var3 = false;
        int charIndex = 0;
        while (charIndex < s.length()) {
            char c2 = s.charAt(charIndex);
            int charWidth = CommonUtils.getCharWidth(c2);
            if (charWidth < 0 && charIndex < s.length() - 1) {
                if ((c2 = s.charAt(++charIndex)) != 'l' && c2 != 'L') {
                    if (c2 == 'r' || c2 == 'R') {
                        var3 = false;
                    }
                } else {
                    var3 = true;
                }
                charWidth = CommonUtils.getCharWidth(c2);
            }
            width += charWidth;
            if (var3) {
                ++width;
            }
            ++charIndex;
        }
        return width;
    }

    /*
     * Exception decompiling
     */
    public static List formatMessage(String message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String colourPrefix(int colour) {
        if (colour == -1) {
            return "";
        }
        return "\u00a7" + "0123456789abcdef".charAt(colour);
    }

    public static int getDimension(aaj mapdata) {
        if (mystMapDimension != null) {
            try {
                return mystMapDimension.getInt(mapdata);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return mapdata.d;
    }

    public static void setDimension(aaj mapdata, int dimension) {
        if (mystMapDimension != null) {
            try {
                mystMapDimension.setInt(mapdata, dimension);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            mapdata.d = (byte)dimension;
        }
    }
}

