/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;

public class ConnectedTextures {
    private static ConnectedProperties[][] blockProperties = null;
    private static ConnectedProperties[][] terrainProperties = null;
    private static boolean matchingCtmPng = false;
    private static final int BOTTOM = 0;
    private static final int TOP = 1;
    private static final int EAST = 2;
    private static final int WEST = 3;
    private static final int NORTH = 4;
    private static final int SOUTH = 5;
    private static final String[] propSuffixes = new String[]{"", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};

    public static void update(aaw re) {
        blockProperties = null;
        terrainProperties = null;
        matchingCtmPng = false;
        blockProperties = ConnectedTextures.readConnectedProperties("/ctm/block", 256, re, 1);
        terrainProperties = ConnectedTextures.readConnectedProperties("/ctm/terrain", 256, re, 2);
        matchingCtmPng = ConnectedTextures.getMatchingCtmPng(re);
        Config.dbg("MatchingCtmPng: " + matchingCtmPng);
        if (blockProperties == null && terrainProperties == null && matchingCtmPng) {
            Config.dbg("Registering default ConnectedTextures");
            blockProperties = new ConnectedProperties[256][];
            ConnectedTextures.blockProperties[pb.M.bO] = new ConnectedProperties[1];
            ConnectedTextures.blockProperties[pb.M.bO][0] = ConnectedTextures.makeDefaultProperties("ctm", re);
            ConnectedTextures.blockProperties[pb.an.bO] = new ConnectedProperties[1];
            ConnectedTextures.blockProperties[pb.an.bO][0] = ConnectedTextures.makeDefaultProperties("horizontal", re);
            terrainProperties = new ConnectedProperties[256][];
            ConnectedTextures.terrainProperties[pb.Q.bN] = new ConnectedProperties[1];
            ConnectedTextures.terrainProperties[pb.Q.bN][0] = ConnectedTextures.makeDefaultProperties("top", re);
        }
    }

    private static ConnectedProperties[][] readConnectedProperties(String prefix, int num, aaw re, int defConnect) {
        ConnectedProperties[][] cps = null;
        for (int i2 = 0; i2 < num; ++i2) {
            ArrayList<ConnectedProperties> listIndexProps = new ArrayList<ConnectedProperties>();
            for (int is = 0; is < propSuffixes.length; ++is) {
                String suff = propSuffixes[is];
                String path = prefix + i2 + suff + ".properties";
                InputStream in = re.l.a.a(path);
                if (in == null) break;
                try {
                    Properties props = new Properties();
                    props.load(in);
                    Config.dbg("Connected texture: " + path);
                    ConnectedProperties cp = new ConnectedProperties(props);
                    if (cp.connect == 0) {
                        cp.connect = defConnect;
                    }
                    if (!cp.isValid(path)) continue;
                    cp.textureId = re.b(cp.source);
                    listIndexProps.add(cp);
                    in.close();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (listIndexProps.size() <= 0) continue;
            if (cps == null) {
                cps = new ConnectedProperties[num][0];
            }
            cps[i2] = listIndexProps.toArray(new ConnectedProperties[listIndexProps.size()]);
        }
        return cps;
    }

    public static int getConnectedTexture(ali blockAccess, pb block, int x, int y, int z2, int side, int tileNum) {
        int texNum;
        ConnectedProperties[] cps;
        int blockId;
        int texNum2;
        ConnectedProperties[] cps2;
        if (blockAccess == null) {
            return -1;
        }
        if (terrainProperties != null && adz.a.defaultTexture && tileNum >= 0 && tileNum < terrainProperties.length && (cps2 = terrainProperties[tileNum]) != null && (texNum2 = ConnectedTextures.getConnectedTexture(cps2, blockAccess, block, x, y, z2, side, tileNum)) >= 0) {
            return texNum2;
        }
        if (blockProperties != null && (blockId = block.bO) >= 0 && blockId < blockProperties.length && (cps = blockProperties[blockId]) != null && (texNum = ConnectedTextures.getConnectedTexture(cps, blockAccess, block, x, y, z2, side, tileNum)) >= 0) {
            return texNum;
        }
        return -1;
    }

    private static int getConnectedTexture(ConnectedProperties[] cps, ali blockAccess, pb block, int x, int y, int z2, int side, int tileNum) {
        for (int i2 = 0; i2 < cps.length; ++i2) {
            int texNum;
            ConnectedProperties cp = cps[i2];
            if (cp == null || (texNum = ConnectedTextures.getConnectedTexture(cp, blockAccess, block, x, y, z2, side, tileNum)) < 0) continue;
            return texNum;
        }
        return -1;
    }

    private static int getConnectedTexture(ConnectedProperties cp, ali blockAccess, pb block, int x, int y, int z2, int side, int tileNum) {
        if (side >= 0 && (1 << side & cp.faces) == 0) {
            return -1;
        }
        if (cp.metadata != null) {
            int[] mds = cp.metadata;
            int md2 = blockAccess.e(x, y, z2);
            boolean metadataFound = false;
            for (int i2 = 0; i2 < mds.length; ++i2) {
                if (mds[i2] != md2) continue;
                metadataFound = true;
                break;
            }
            if (!metadataFound) {
                return -1;
            }
        }
        switch (cp.method) {
            case 1: {
                return ConnectedTextures.getConnectedTextureCtm(cp, blockAccess, block, x, y, z2, side, tileNum);
            }
            case 2: {
                return ConnectedTextures.getConnectedTextureHorizontal(cp, blockAccess, block, x, y, z2, side, tileNum);
            }
            case 6: {
                return ConnectedTextures.getConnectedTextureVertical(cp, blockAccess, block, x, y, z2, side, tileNum);
            }
            case 3: {
                return ConnectedTextures.getConnectedTextureTop(cp, blockAccess, block, x, y, z2, side, tileNum);
            }
            case 4: {
                return ConnectedTextures.getConnectedTextureRandom(cp, x, y, z2, side);
            }
            case 5: {
                return ConnectedTextures.getConnectedTextureRepeat(cp, x, y, z2, side);
            }
        }
        return -1;
    }

    private static int getConnectedTextureRandom(ConnectedProperties cp, int x, int y, int z2, int side) {
        int face = side / cp.symmetry * cp.symmetry;
        int rand = Config.getRandom(x, y, z2, side) & Integer.MAX_VALUE;
        int index = 0;
        if (cp.weights == null) {
            index = rand % cp.tiles.length;
        } else {
            int randWeight = rand % cp.sumAllWeights;
            int[] sumWeights = cp.sumWeights;
            for (int i2 = 0; i2 < sumWeights.length; ++i2) {
                if (randWeight >= sumWeights[i2]) continue;
                index = i2;
                break;
            }
        }
        return cp.textureId * 256 + cp.tiles[index];
    }

    private static int getConnectedTextureRepeat(ConnectedProperties cp, int x, int y, int z2, int side) {
        int nx = 0;
        int ny = 0;
        switch (side) {
            case 0: {
                nx = x;
                ny = z2;
                break;
            }
            case 1: {
                nx = x;
                ny = z2;
                break;
            }
            case 2: {
                nx = -x - 1;
                ny = -y;
                break;
            }
            case 3: {
                nx = x;
                ny = -y;
                break;
            }
            case 4: {
                nx = z2;
                ny = -y;
                break;
            }
            case 5: {
                nx = -z2 - 1;
                ny = -y;
            }
        }
        ny %= cp.height;
        if ((nx %= cp.width) < 0) {
            nx += cp.width;
        }
        if (ny < 0) {
            ny += cp.height;
        }
        int index = ny * cp.width + nx;
        return cp.textureId * 256 + cp.tiles[index];
    }

    private static int getConnectedTextureCtm(ConnectedProperties cp, ali blockAccess, pb block, int x, int y, int z2, int side, int tileNum) {
        boolean[] borders = new boolean[6];
        int id = block.bO;
        switch (side) {
            case 0: 
            case 1: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y, z2, id, side, tileNum);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y, z2, id, side, tileNum);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y, z2 + 1, id, side, tileNum);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y, z2 - 1, id, side, tileNum);
                break;
            }
            case 2: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y, z2, id, side, tileNum);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y, z2, id, side, tileNum);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y - 1, z2, id, side, tileNum);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y + 1, z2, id, side, tileNum);
                break;
            }
            case 3: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y, z2, id, side, tileNum);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y, z2, id, side, tileNum);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y - 1, z2, id, side, tileNum);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y + 1, z2, id, side, tileNum);
                break;
            }
            case 4: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y, z2 - 1, id, side, tileNum);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y, z2 + 1, id, side, tileNum);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y - 1, z2, id, side, tileNum);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y + 1, z2, id, side, tileNum);
                break;
            }
            case 5: {
                borders[0] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y, z2 + 1, id, side, tileNum);
                borders[1] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y, z2 - 1, id, side, tileNum);
                borders[2] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y - 1, z2, id, side, tileNum);
                borders[3] = ConnectedTextures.isNeighbour(cp, blockAccess, x, y + 1, z2, id, side, tileNum);
            }
        }
        int index = 0;
        if (borders[0] & !borders[1] & !borders[2] & !borders[3]) {
            index = 3;
        } else if (!borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 1;
        } else if (!borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 12;
        } else if (!borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 36;
        } else if (borders[0] & borders[1] & !borders[2] & !borders[3]) {
            index = 2;
        } else if (!borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 24;
        } else if (borders[0] & !borders[1] & borders[2] & !borders[3]) {
            index = 15;
        } else if (borders[0] & !borders[1] & !borders[2] & borders[3]) {
            index = 39;
        } else if (!borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 13;
        } else if (!borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 37;
        } else if (!borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 25;
        } else if (borders[0] & !borders[1] & borders[2] & borders[3]) {
            index = 27;
        } else if (borders[0] & borders[1] & !borders[2] & borders[3]) {
            index = 38;
        } else if (borders[0] & borders[1] & borders[2] & !borders[3]) {
            index = 14;
        } else if (borders[0] & borders[1] & borders[2] & borders[3]) {
            index = 26;
        }
        if (!Config.isConnectedTexturesFancy()) {
            return cp.textureId * 256 + cp.tiles[index];
        }
        boolean[] edges = new boolean[6];
        switch (side) {
            case 0: 
            case 1: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y, z2 + 1, id, side, tileNum);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y, z2 + 1, id, side, tileNum);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y, z2 - 1, id, side, tileNum);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y, z2 - 1, id, side, tileNum);
                break;
            }
            case 2: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y - 1, z2, id, side, tileNum);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y - 1, z2, id, side, tileNum);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y + 1, z2, id, side, tileNum);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y + 1, z2, id, side, tileNum);
                break;
            }
            case 3: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y - 1, z2, id, side, tileNum);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y - 1, z2, id, side, tileNum);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y + 1, z2, id, side, tileNum);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y + 1, z2, id, side, tileNum);
                break;
            }
            case 4: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, x, y - 1, z2 + 1, id, side, tileNum);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, x, y - 1, z2 - 1, id, side, tileNum);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, x, y + 1, z2 + 1, id, side, tileNum);
                edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, x, y + 1, z2 - 1, id, side, tileNum);
                break;
            }
            case 5: {
                edges[0] = !ConnectedTextures.isNeighbour(cp, blockAccess, x, y - 1, z2 - 1, id, side, tileNum);
                edges[1] = !ConnectedTextures.isNeighbour(cp, blockAccess, x, y - 1, z2 + 1, id, side, tileNum);
                edges[2] = !ConnectedTextures.isNeighbour(cp, blockAccess, x, y + 1, z2 - 1, id, side, tileNum);
                boolean bl = edges[3] = !ConnectedTextures.isNeighbour(cp, blockAccess, x, y + 1, z2 + 1, id, side, tileNum);
            }
        }
        if (index == 13 && edges[0]) {
            index = 4;
        }
        if (index == 15 && edges[1]) {
            index = 5;
        }
        if (index == 37 && edges[2]) {
            index = 16;
        }
        if (index == 39 && edges[3]) {
            index = 17;
        }
        if (index == 14 && edges[0] && edges[1]) {
            index = 7;
        }
        if (index == 25 && edges[0] && edges[2]) {
            index = 6;
        }
        if (index == 27 && edges[3] && edges[1]) {
            index = 19;
        }
        if (index == 38 && edges[3] && edges[2]) {
            index = 18;
        }
        if (index == 14 && !edges[0] && edges[1]) {
            index = 31;
        }
        if (index == 25 && edges[0] && !edges[2]) {
            index = 30;
        }
        if (index == 27 && !edges[3] && edges[1]) {
            index = 41;
        }
        if (index == 38 && edges[3] && !edges[2]) {
            index = 40;
        }
        if (index == 14 && edges[0] && !edges[1]) {
            index = 29;
        }
        if (index == 25 && !edges[0] && edges[2]) {
            index = 28;
        }
        if (index == 27 && edges[3] && !edges[1]) {
            index = 43;
        }
        if (index == 38 && !edges[3] && edges[2]) {
            index = 42;
        }
        if (index == 26 && edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 46;
        }
        if (index == 26 && !edges[0] && edges[1] && edges[2] && edges[3]) {
            index = 9;
        }
        if (index == 26 && edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 21;
        }
        if (index == 26 && edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 8;
        }
        if (index == 26 && edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 20;
        }
        if (index == 26 && edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 11;
        }
        if (index == 26 && !edges[0] && !edges[1] && edges[2] && edges[3]) {
            index = 22;
        }
        if (index == 26 && !edges[0] && edges[1] && !edges[2] && edges[3]) {
            index = 23;
        }
        if (index == 26 && edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 10;
        }
        if (index == 26 && edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 34;
        }
        if (index == 26 && !edges[0] && edges[1] && edges[2] && !edges[3]) {
            index = 35;
        }
        if (index == 26 && edges[0] && !edges[1] && !edges[2] && !edges[3]) {
            index = 32;
        }
        if (index == 26 && !edges[0] && edges[1] && !edges[2] && !edges[3]) {
            index = 33;
        }
        if (index == 26 && !edges[0] && !edges[1] && edges[2] && !edges[3]) {
            index = 44;
        }
        if (index == 26 && !edges[0] && !edges[1] && !edges[2] && edges[3]) {
            index = 45;
        }
        return cp.textureId * 256 + cp.tiles[index];
    }

    private static boolean isNeighbour(ConnectedProperties cp, ali iblockaccess, int x, int y, int z2, int id, int side, int tileNum) {
        int blockId = iblockaccess.a(x, y, z2);
        if (cp.connect == 2) {
            pb neighbourBlock = pb.m[blockId];
            if (neighbourBlock == null) {
                return false;
            }
            int neighbourTileNum = neighbourBlock.d(iblockaccess, x, y, z2, side);
            return neighbourTileNum == tileNum;
        }
        return blockId == id;
    }

    private static int getConnectedTextureHorizontal(ConnectedProperties cp, ali blockAccess, pb block, int x, int y, int z2, int side, int tileNum) {
        if (side == 0 || side == 1) {
            return -1;
        }
        boolean left = false;
        boolean right = false;
        int id = block.bO;
        switch (side) {
            case 2: {
                left = ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y, z2, id, side, tileNum);
                right = ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y, z2, id, side, tileNum);
                break;
            }
            case 3: {
                left = ConnectedTextures.isNeighbour(cp, blockAccess, x - 1, y, z2, id, side, tileNum);
                right = ConnectedTextures.isNeighbour(cp, blockAccess, x + 1, y, z2, id, side, tileNum);
                break;
            }
            case 4: {
                left = ConnectedTextures.isNeighbour(cp, blockAccess, x, y, z2 - 1, id, side, tileNum);
                right = ConnectedTextures.isNeighbour(cp, blockAccess, x, y, z2 + 1, id, side, tileNum);
                break;
            }
            case 5: {
                left = ConnectedTextures.isNeighbour(cp, blockAccess, x, y, z2 + 1, id, side, tileNum);
                right = ConnectedTextures.isNeighbour(cp, blockAccess, x, y, z2 - 1, id, side, tileNum);
            }
        }
        int index = 3;
        index = left ? (right ? 1 : 2) : (right ? 0 : 3);
        return cp.textureId * 256 + cp.tiles[index];
    }

    private static int getConnectedTextureVertical(ConnectedProperties cp, ali blockAccess, pb block, int x, int y, int z2, int side, int tileNum) {
        if (side == 0 || side == 1) {
            return -1;
        }
        int id = block.bO;
        boolean bottom = ConnectedTextures.isNeighbour(cp, blockAccess, x, y - 1, z2, id, side, tileNum);
        boolean top = ConnectedTextures.isNeighbour(cp, blockAccess, x, y + 1, z2, id, side, tileNum);
        int index = 3;
        index = bottom ? (top ? 1 : 2) : (top ? 0 : 3);
        return cp.textureId * 256 + cp.tiles[index];
    }

    private static int getConnectedTextureTop(ConnectedProperties cp, ali blockAccess, pb block, int x, int y, int z2, int side, int tileNum) {
        if (side == 0 || side == 1) {
            return -1;
        }
        int blockId = block.bO;
        if (ConnectedTextures.isNeighbour(cp, blockAccess, x, y + 1, z2, blockId, side, tileNum)) {
            return cp.textureId * 256 + cp.tiles[0];
        }
        return -1;
    }

    public static boolean isConnectedGlassPanes() {
        return Config.isConnectedTextures() && matchingCtmPng;
    }

    private static boolean getMatchingCtmPng(aaw re) {
        Dimension dimCtm = re.getTextureDimensions(re.b("/ctm.png"));
        if (dimCtm == null) {
            return false;
        }
        Dimension dimTerrain = re.getTextureDimensions(re.b("/terrain.png"));
        if (dimTerrain == null) {
            return false;
        }
        return dimCtm.width == dimTerrain.width && dimCtm.height == dimTerrain.height;
    }

    private static ConnectedProperties makeDefaultProperties(String methodStr, aaw re) {
        Properties props = new Properties();
        props.put("source", "/ctm.png");
        props.put("method", methodStr);
        ConnectedProperties cp = new ConnectedProperties(props);
        cp.isValid("(default)");
        cp.textureId = re.b(cp.source);
        return cp;
    }
}

