/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.minecraft.client.Minecraft;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class Config {
    public static final String OF_NAME = "OptiFine";
    public static final String MC_VERSION = "1.2.5";
    public static final String OF_EDITION = "HD_S";
    public static final String OF_RELEASE = "C6";
    public static final String VERSION = "OptiFine_1.2.5_HD_S_C6";
    private static String newRelease = null;
    private static hu gameSettings = null;
    private static Minecraft minecraft = null;
    private static int iconWidthTerrain = 16;
    private static int iconWidthItems = 16;
    private static Map foundClassesMap = new HashMap();
    private static long textureUpdateTime = 0L;
    private static DisplayMode desktopDisplayMode = null;
    private static File logFile = null;
    public static final Boolean DEF_FOG_FANCY = true;
    public static final Float DEF_FOG_START = Float.valueOf(0.2f);
    public static final Boolean DEF_OPTIMIZE_RENDER_DISTANCE = false;
    public static final Boolean DEF_OCCLUSION_ENABLED = false;
    public static final Integer DEF_MIPMAP_LEVEL = 0;
    public static final Integer DEF_MIPMAP_TYPE = 9984;
    public static final Float DEF_ALPHA_FUNC_LEVEL = Float.valueOf(0.1f);
    public static final Boolean DEF_LOAD_CHUNKS_FAR = false;
    public static final Integer DEF_PRELOADED_CHUNKS = 0;
    public static final Integer DEF_CHUNKS_LIMIT = 25;
    public static final Integer DEF_UPDATES_PER_FRAME = 3;
    public static final Boolean DEF_DYNAMIC_UPDATES = false;

    private Config() {
    }

    public static String getVersion() {
        return VERSION;
    }

    private static void checkOpenGlCaps() {
        Config.log("");
        Config.log(Config.getVersion());
        Config.log("" + new Date());
        Config.log("OS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        Config.log("Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        Config.log("VM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        Config.log("LWJGL: " + Sys.getVersion());
        Config.log("OpenGL: " + GL11.glGetString((int)7937) + " version " + GL11.glGetString((int)7938) + ", " + GL11.glGetString((int)7936));
        int ver = Config.getOpenGlVersion();
        String verStr = "" + ver / 10 + "." + ver % 10;
        Config.log("OpenGL Version: " + verStr);
        if (!GLContext.getCapabilities().OpenGL12) {
            Config.log("OpenGL Mipmap levels: Not available (GL12.GL_TEXTURE_MAX_LEVEL)");
        }
        if (!GLContext.getCapabilities().GL_NV_fog_distance) {
            Config.log("OpenGL Fancy fog: Not available (GL_NV_fog_distance)");
        }
        if (!GLContext.getCapabilities().GL_ARB_occlusion_query) {
            Config.log("OpenGL Occlussion culling: Not available (GL_ARB_occlusion_query)");
        }
    }

    public static boolean isFancyFogAvailable() {
        return GLContext.getCapabilities().GL_NV_fog_distance;
    }

    public static boolean isOcclusionAvailable() {
        return GLContext.getCapabilities().GL_ARB_occlusion_query;
    }

    private static int getOpenGlVersion() {
        if (!GLContext.getCapabilities().OpenGL11) {
            return 10;
        }
        if (!GLContext.getCapabilities().OpenGL12) {
            return 11;
        }
        if (!GLContext.getCapabilities().OpenGL13) {
            return 12;
        }
        if (!GLContext.getCapabilities().OpenGL14) {
            return 13;
        }
        if (!GLContext.getCapabilities().OpenGL15) {
            return 14;
        }
        if (!GLContext.getCapabilities().OpenGL20) {
            return 15;
        }
        if (!GLContext.getCapabilities().OpenGL21) {
            return 20;
        }
        if (!GLContext.getCapabilities().OpenGL30) {
            return 21;
        }
        if (!GLContext.getCapabilities().OpenGL31) {
            return 30;
        }
        if (!GLContext.getCapabilities().OpenGL32) {
            return 31;
        }
        if (!GLContext.getCapabilities().OpenGL33) {
            return 32;
        }
        if (!GLContext.getCapabilities().OpenGL40) {
            return 33;
        }
        return 40;
    }

    public static void setGameSettings(hu options) {
        if (gameSettings == null) {
            Config.checkOpenGlCaps();
            Config.startVersionCheckThread();
        }
        gameSettings = options;
        minecraft = Config.gameSettings.B;
    }

    private static void startVersionCheckThread() {
        VersionCheckThread vct = new VersionCheckThread();
        vct.start();
    }

    public static boolean isUseMipmaps() {
        int mipmapLevel = Config.getMipmapLevel();
        return mipmapLevel > 0;
    }

    public static int getMipmapLevel() {
        if (gameSettings == null) {
            return DEF_MIPMAP_LEVEL;
        }
        return Config.gameSettings.ofMipmapLevel;
    }

    public static int getMipmapType() {
        if (gameSettings == null) {
            return DEF_MIPMAP_TYPE;
        }
        if (Config.gameSettings.ofMipmapLinear) {
            return 9986;
        }
        return 9984;
    }

    public static boolean isUseAlphaFunc() {
        float alphaFuncLevel = Config.getAlphaFuncLevel();
        return alphaFuncLevel > DEF_ALPHA_FUNC_LEVEL.floatValue() + 1.0E-5f;
    }

    public static float getAlphaFuncLevel() {
        return DEF_ALPHA_FUNC_LEVEL.floatValue();
    }

    public static boolean isFogFancy() {
        if (!Config.isFancyFogAvailable()) {
            return false;
        }
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofFogType == 2;
    }

    public static boolean isFogFast() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofFogType == 1;
    }

    public static boolean isFogOff() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofFogType == 3;
    }

    public static float getFogStart() {
        if (gameSettings == null) {
            return DEF_FOG_START.floatValue();
        }
        return Config.gameSettings.ofFogStart;
    }

    public static boolean isOcclusionEnabled() {
        if (gameSettings == null) {
            return DEF_OCCLUSION_ENABLED;
        }
        return Config.gameSettings.h;
    }

    public static boolean isOcclusionFancy() {
        if (!Config.isOcclusionEnabled()) {
            return false;
        }
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofOcclusionFancy;
    }

    public static boolean isLoadChunksFar() {
        if (gameSettings == null) {
            return DEF_LOAD_CHUNKS_FAR;
        }
        return Config.gameSettings.ofLoadFar;
    }

    public static int getPreloadedChunks() {
        if (gameSettings == null) {
            return DEF_PRELOADED_CHUNKS;
        }
        return Config.gameSettings.ofPreloadedChunks;
    }

    public static void dbg(String s) {
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String s) {
        Config.dbg(s);
        try {
            if (logFile == null) {
                logFile = new File(Minecraft.b(), "optifog.log");
                logFile.delete();
                logFile.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(logFile, true);
            OutputStreamWriter logFileWriter = new OutputStreamWriter((OutputStream)fos, "ASCII");
            try {
                logFileWriter.write(s);
                logFileWriter.write("\n");
                logFileWriter.flush();
            }
            finally {
                logFileWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getUpdatesPerFrame() {
        if (gameSettings != null) {
            return Config.gameSettings.ofChunkUpdates;
        }
        return 1;
    }

    public static boolean isDynamicUpdates() {
        if (gameSettings != null) {
            return Config.gameSettings.ofChunkUpdatesDynamic;
        }
        return true;
    }

    public static boolean isRainFancy() {
        if (Config.gameSettings.ofRain == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofRain == 2;
    }

    public static boolean isWaterFancy() {
        if (Config.gameSettings.ofWater == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofWater == 2;
    }

    public static boolean isRainOff() {
        return Config.gameSettings.ofRain == 3;
    }

    public static boolean isCloudsFancy() {
        if (Config.gameSettings.ofClouds == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofClouds == 2;
    }

    public static boolean isCloudsOff() {
        return Config.gameSettings.ofClouds == 3;
    }

    public static boolean isTreesFancy() {
        if (Config.gameSettings.ofTrees == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofTrees == 2;
    }

    public static boolean isGrassFancy() {
        if (Config.gameSettings.ofGrass == 0) {
            return Config.gameSettings.j;
        }
        return Config.gameSettings.ofGrass == 2;
    }

    public static int limit(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static float limit(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    public static float limitTo1(float val) {
        if (val < 0.0f) {
            return 0.0f;
        }
        if (val > 1.0f) {
            return 1.0f;
        }
        return val;
    }

    public static boolean isAnimatedWater() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedWater != 2;
        }
        return true;
    }

    public static boolean isGeneratedWater() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedWater == 1;
        }
        return true;
    }

    public static boolean isAnimatedPortal() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedPortal;
        }
        return true;
    }

    public static boolean isAnimatedLava() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedLava != 2;
        }
        return true;
    }

    public static boolean isGeneratedLava() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedLava == 1;
        }
        return true;
    }

    public static boolean isAnimatedFire() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedFire;
        }
        return true;
    }

    public static boolean isAnimatedRedstone() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedRedstone;
        }
        return true;
    }

    public static boolean isAnimatedExplosion() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedExplosion;
        }
        return true;
    }

    public static boolean isAnimatedFlame() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedFlame;
        }
        return true;
    }

    public static boolean isAnimatedSmoke() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedSmoke;
        }
        return true;
    }

    public static boolean isVoidParticles() {
        if (gameSettings != null) {
            return Config.gameSettings.ofVoidParticles;
        }
        return true;
    }

    public static boolean isWaterParticles() {
        if (gameSettings != null) {
            return Config.gameSettings.ofWaterParticles;
        }
        return true;
    }

    public static boolean isRainSplash() {
        if (gameSettings != null) {
            return Config.gameSettings.ofRainSplash;
        }
        return true;
    }

    public static boolean isPortalParticles() {
        if (gameSettings != null) {
            return Config.gameSettings.ofPortalParticles;
        }
        return true;
    }

    public static boolean isDepthFog() {
        if (gameSettings != null) {
            return Config.gameSettings.ofDepthFog;
        }
        return true;
    }

    public static float getAmbientOcclusionLevel() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAoLevel;
        }
        return 0.0f;
    }

    private static Method getMethod(Class cls, String methodName, Object[] params) {
        Method[] methods = cls.getMethods();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method m = methods[i2];
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != params.length) continue;
            return m;
        }
        Config.dbg("No method found for: " + cls.getName() + "." + methodName + "(" + Config.arrayToString(params) + ")");
        return null;
    }

    public static String arrayToString(Object[] arr) {
        StringBuffer buf = new StringBuffer(arr.length * 5);
        for (int i2 = 0; i2 < arr.length; ++i2) {
            Object obj = arr[i2];
            if (i2 > 0) {
                buf.append(", ");
            }
            buf.append(String.valueOf(obj));
        }
        return buf.toString();
    }

    public static Minecraft getMinecraft() {
        return minecraft;
    }

    public static int getIconWidthTerrain() {
        return iconWidthTerrain;
    }

    public static int getIconWidthItems() {
        return iconWidthItems;
    }

    public static void setIconWidthItems(int iconWidth) {
        iconWidthItems = iconWidth;
    }

    public static void setIconWidthTerrain(int iconWidth) {
        iconWidthTerrain = iconWidth;
    }

    public static int getMaxDynamicTileWidth() {
        return 64;
    }

    public static int getSideGrassTexture(ali blockAccess, int x, int y, int z2, int side, int tileNum) {
        if (!Config.isBetterGrass()) {
            return tileNum;
        }
        int fullTileNum = 0;
        int destBlockId = 2;
        if (tileNum == 77) {
            fullTileNum = 78;
            destBlockId = 110;
        }
        if (Config.isBetterGrassFancy()) {
            --y;
            switch (side) {
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                }
            }
            int blockId = blockAccess.a(x, y, z2);
            if (blockId != destBlockId) {
                return tileNum;
            }
        }
        return fullTileNum;
    }

    public static int getSideSnowGrassTexture(ali blockAccess, int x, int y, int z2, int side) {
        if (!Config.isBetterGrass()) {
            return 68;
        }
        if (Config.isBetterGrassFancy()) {
            switch (side) {
                case 2: {
                    --z2;
                    break;
                }
                case 3: {
                    ++z2;
                    break;
                }
                case 4: {
                    --x;
                    break;
                }
                case 5: {
                    ++x;
                }
            }
            int blockId = blockAccess.a(x, y, z2);
            if (blockId != 78 && blockId != 80) {
                return 68;
            }
        }
        return 66;
    }

    public static boolean isBetterGrass() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofBetterGrass != 3;
    }

    public static boolean isBetterGrassFancy() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofBetterGrass == 2;
    }

    public static long getTextureUpdateTime() {
        return textureUpdateTime;
    }

    public static void setTextureUpdateTime(long fontRendererUpdateTime) {
        textureUpdateTime = fontRendererUpdateTime;
    }

    public static boolean isWeatherEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofWeather;
    }

    public static boolean isSkyEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofSky;
    }

    public static boolean isSunMoonEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofSunMoon;
    }

    public static boolean isStarsEnabled() {
        if (gameSettings == null) {
            return true;
        }
        return Config.gameSettings.ofStars;
    }

    public static void sleep(long ms2) {
        try {
            Thread.currentThread();
            Thread.sleep(ms2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static boolean isTimeDayOnly() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofTime == 1;
    }

    public static boolean isTimeNightOnly() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofTime == 3;
    }

    public static boolean isClearWater() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofClearWater;
    }

    public static boolean isDrippingWaterLava() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofDrippingWaterLava;
    }

    public static boolean isBetterSnow() {
        if (gameSettings == null) {
            return false;
        }
        return Config.gameSettings.ofBetterSnow;
    }

    public static Dimension getFullscreenDimension() {
        if (gameSettings == null) {
            return new Dimension(desktopDisplayMode.getWidth(), desktopDisplayMode.getHeight());
        }
        String dimStr = Config.gameSettings.ofFullscreenMode;
        if (dimStr.equals("Default")) {
            return new Dimension(desktopDisplayMode.getWidth(), desktopDisplayMode.getHeight());
        }
        String[] dimStrs = Config.tokenize(dimStr, " x");
        if (dimStrs.length < 2) {
            return new Dimension(desktopDisplayMode.getWidth(), desktopDisplayMode.getHeight());
        }
        return new Dimension(Config.parseInt(dimStrs[0], -1), Config.parseInt(dimStrs[1], -1));
    }

    public static int parseInt(String str, int defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static float parseFloat(String str, float defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            return defVal;
        }
    }

    public static String[] tokenize(String str, String delim) {
        StringTokenizer tok = new StringTokenizer(str, delim);
        ArrayList<String> list = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            list.add(token);
        }
        String[] strs = list.toArray(new String[list.size()]);
        return strs;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktopDisplayMode;
    }

    public static void setDesktopDisplayMode(DisplayMode desktopDisplayMode) {
        Config.desktopDisplayMode = desktopDisplayMode;
    }

    public static DisplayMode[] getFullscreenDisplayModes() {
        try {
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            ArrayList<DisplayMode> list = new ArrayList<DisplayMode>();
            for (int i2 = 0; i2 < modes.length; ++i2) {
                DisplayMode dm2 = modes[i2];
                if (desktopDisplayMode != null && (dm2.getBitsPerPixel() != desktopDisplayMode.getBitsPerPixel() || dm2.getFrequency() != desktopDisplayMode.getFrequency())) continue;
                list.add(dm2);
            }
            DisplayMode[] fsModes = list.toArray(new DisplayMode[list.size()]);
            Comparator comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    DisplayMode dm1 = (DisplayMode)o1;
                    DisplayMode dm2 = (DisplayMode)o2;
                    if (dm1.getWidth() != dm2.getWidth()) {
                        return dm2.getWidth() - dm1.getWidth();
                    }
                    if (dm1.getHeight() != dm2.getHeight()) {
                        return dm2.getHeight() - dm1.getHeight();
                    }
                    return 0;
                }
            };
            Arrays.sort(fsModes, comp);
            return fsModes;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new DisplayMode[]{desktopDisplayMode};
        }
    }

    public static String[] getFullscreenModes() {
        DisplayMode[] modes = Config.getFullscreenDisplayModes();
        String[] names = new String[modes.length];
        for (int i2 = 0; i2 < modes.length; ++i2) {
            String name;
            DisplayMode mode = modes[i2];
            names[i2] = name = "" + mode.getWidth() + "x" + mode.getHeight();
        }
        return names;
    }

    public static DisplayMode getDisplayMode(Dimension dim) throws LWJGLException {
        DisplayMode[] modes = Display.getAvailableDisplayModes();
        for (int i2 = 0; i2 < modes.length; ++i2) {
            DisplayMode dm2 = modes[i2];
            if (dm2.getWidth() != dim.width || dm2.getHeight() != dim.height || desktopDisplayMode != null && (dm2.getBitsPerPixel() != desktopDisplayMode.getBitsPerPixel() || dm2.getFrequency() != desktopDisplayMode.getFrequency())) continue;
            return dm2;
        }
        return desktopDisplayMode;
    }

    public static boolean isAnimatedTerrain() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedTerrain;
        }
        return true;
    }

    public static boolean isAnimatedItems() {
        if (gameSettings != null) {
            return Config.gameSettings.ofAnimatedItems;
        }
        return true;
    }

    public static boolean isSwampColors() {
        if (gameSettings != null) {
            return Config.gameSettings.ofSwampColors;
        }
        return true;
    }

    public static boolean isRandomMobs() {
        if (gameSettings != null) {
            return Config.gameSettings.ofRandomMobs;
        }
        return true;
    }

    public static void checkGlError(String loc) {
        int i2 = GL11.glGetError();
        if (i2 != 0) {
            String text = GLU.gluErrorString((int)i2);
            System.out.println("OpenGlError: " + i2 + " (" + text + "), at: " + loc);
        }
    }

    public static boolean isSmoothBiomes() {
        if (gameSettings != null) {
            return Config.gameSettings.ofSmoothBiomes;
        }
        return true;
    }

    public static boolean isCustomColors() {
        if (gameSettings != null) {
            return Config.gameSettings.ofCustomColors;
        }
        return true;
    }

    public static boolean isShowCapes() {
        if (gameSettings != null) {
            return Config.gameSettings.ofShowCapes;
        }
        return true;
    }

    public static boolean isConnectedTextures() {
        if (gameSettings != null) {
            return Config.gameSettings.ofConnectedTextures != 3;
        }
        return false;
    }

    public static boolean isNaturalTextures() {
        if (gameSettings != null) {
            return Config.gameSettings.ofNaturalTextures;
        }
        return false;
    }

    public static boolean isConnectedTexturesFancy() {
        if (gameSettings != null) {
            return Config.gameSettings.ofConnectedTextures == 2;
        }
        return false;
    }

    public static String[] readLines(File file) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        FileInputStream fis = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "ASCII");
        BufferedReader br = new BufferedReader(isr);
        while ((line = br.readLine()) != null) {
            list.add(line);
        }
        String[] lines = list.toArray(new String[list.size()]);
        return lines;
    }

    public static String readFile(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        return Config.readInputStream(fin, "ASCII");
    }

    public static String readInputStream(InputStream in) throws IOException {
        return Config.readInputStream(in, "ASCII");
    }

    public static String readInputStream(InputStream in, String encoding) throws IOException {
        String line;
        InputStreamReader inr = new InputStreamReader(in, encoding);
        BufferedReader br = new BufferedReader(inr);
        StringBuffer sb2 = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb2.append(line);
            sb2.append("\n");
        }
        return sb2.toString();
    }

    public static hu getGameSettings() {
        return gameSettings;
    }

    public static String getNewRelease() {
        return newRelease;
    }

    public static void setNewRelease(String newRelease) {
        Config.newRelease = newRelease;
    }

    public static int compareRelease(String rel1, String rel2) {
        int rev2;
        String[] rels2;
        String branch2;
        String[] rels1 = Config.splitRelease(rel1);
        String branch1 = rels1[0];
        if (!branch1.equals(branch2 = (rels2 = Config.splitRelease(rel2))[0])) {
            return branch1.compareTo(branch2);
        }
        int rev1 = Config.parseInt(rels1[1], -1);
        if (rev1 != (rev2 = Config.parseInt(rels2[1], -1))) {
            return rev1 - rev2;
        }
        String suf1 = rels1[2];
        String suf2 = rels2[2];
        return suf1.compareTo(suf2);
    }

    private static String[] splitRelease(String relStr) {
        int pos;
        if (relStr == null || relStr.length() <= 0) {
            return new String[]{"", "", ""};
        }
        String branch = relStr.substring(0, 1);
        if (relStr.length() <= 1) {
            return new String[]{branch, "", ""};
        }
        for (pos = 1; pos < relStr.length() && Character.isDigit(relStr.charAt(pos)); ++pos) {
        }
        String revision = relStr.substring(1, pos);
        if (pos >= relStr.length()) {
            return new String[]{branch, revision, ""};
        }
        String suffix = relStr.substring(pos);
        return new String[]{branch, revision, suffix};
    }

    public static int intHash(int x) {
        x = x ^ 0x3D ^ x >> 16;
        x += x << 3;
        x ^= x >> 4;
        x *= 668265261;
        x ^= x >> 15;
        return x;
    }

    public static int getRandom(int x, int y, int z2, int face) {
        int rand = Config.intHash(face + 37);
        rand = Config.intHash(rand + x);
        rand = Config.intHash(rand + z2);
        rand = Config.intHash(rand + y);
        return rand;
    }
}

